/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib;

import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.gems.SilentGems;

public class TooltipHelper {
    public static final String FORMAT_INT = "%d";
    public static final String FORMAT_INT_LARGE = "%,d";
    public static final String FORMAT_FLOAT = "%.2f";

    public static String getAsColoredPercentage(String key, float value) {
        return TooltipHelper.getAsColoredPercentage(key, value, 100, false);
    }

    public static String getAsColoredPercentage(String key, float value, int whitePercentage, boolean addPlus) {
        int percent = Math.round(value * 100.0f);
        TextFormatting color = percent > whitePercentage ? TextFormatting.GREEN : (percent < whitePercentage ? TextFormatting.RED : TextFormatting.WHITE);
        return SilentGems.i18n.miscText("tooltip." + key, new Object[]{color + (addPlus && percent > 0 ? "+" : "") + percent + "%"});
    }

    public static String numberToPercent(float value, int whitePercentage, boolean addPlus) {
        int percent = Math.round(value * 100.0f);
        TextFormatting color = percent > whitePercentage ? TextFormatting.GREEN : (percent < whitePercentage ? TextFormatting.RED : TextFormatting.WHITE);
        return color + (addPlus && percent > 0 ? "+" : "") + percent + "%";
    }

    public static String get(String key, int value) {
        return TooltipHelper.get(key, value, false);
    }

    public static String get(String key, int value, boolean addSpaces) {
        String number = String.format(value > 9999 ? FORMAT_INT_LARGE : FORMAT_INT, value);
        return (addSpaces ? "  " : "") + SilentGems.i18n.miscText("tooltip." + key, new Object[]{number});
    }

    public static String get(String key, float value) {
        return TooltipHelper.get(key, value, false);
    }

    public static String get(String key, float value, boolean addSpaces) {
        if (value == (float)((int)value)) {
            return TooltipHelper.get(key, (int)value, addSpaces);
        }
        String number = String.format(FORMAT_FLOAT, Float.valueOf(value)).replaceFirst("0+$", "");
        return (addSpaces ? "  " : "") + SilentGems.i18n.miscText("tooltip." + key, new Object[]{number});
    }

    public static String get(String key, String value, boolean addSpaces) {
        return (addSpaces ? "  " : "") + SilentGems.i18n.miscText("tooltip." + key, new Object[]{value});
    }
}

