/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.module;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.common.config.Configuration;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.tool.ItemGemSword;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.gems.util.ToolHelper;

public class ModuleEntityRandomEquipment {
    public static final String MODULE_NAME = "mob_equipment";
    public static boolean MODULE_ENABLED = true;
    public static float SWORD_CHANCE = 0.075f;
    public static float KATANA_CHANCE = 0.5f;
    public static float MACHETE_CHANCE = 0.4f;
    public static float SUPER_CHANCE = 0.25f;
    public static float SWORD_EXTRA_GEM_CHANCE = 0.33f;
    public static float SELECT_EXTRA_GEM_CHANCE = 0.6f;
    public static float EQUIPMENT_DROP_CHANCE = 0.11f;
    public static float SWORD_MULTI_HUMAN = 2.0f;
    public static float SWORD_MULTI_SKELETON = 0.5f;
    public static float SWORD_MULTI_ZOMBIE = 1.0f;

    public static void loadConfig(Configuration c) {
        String cat = "main" + "." + MODULE_NAME;
        c.setCategoryComment(cat, "Configs for mobs spawning with gem equipment.");
        MODULE_ENABLED = c.getBoolean("Enabled", cat, MODULE_ENABLED, "Enables/disables mob gem equipment spawns.");
        SWORD_CHANCE = c.getFloat("SwordChance", cat, SWORD_CHANCE, 0.0f, 1.0f, "Base chance of a mob getting a gem sword.");
        KATANA_CHANCE = c.getFloat("KatanaChance", cat, KATANA_CHANCE, 0.0f, 1.0f, "Chance that a super-tier sword will be a katana.");
        MACHETE_CHANCE = c.getFloat("MacheteChance", cat, MACHETE_CHANCE, 0.0f, 1.0f, "Chance that a machete will be given instead of a classic sword.");
        SUPER_CHANCE = c.getFloat("SuperChance", cat, SUPER_CHANCE, 0.0f, 1.0f, "Chance that equipment will be super-tier if given.");
        SWORD_EXTRA_GEM_CHANCE = c.getFloat("SwordExtraGemChance", cat, SWORD_EXTRA_GEM_CHANCE, 0.0f, 1.0f, "Chance that a sword (not katanas) will get a third gem. The cheaters!");
        SELECT_EXTRA_GEM_CHANCE = c.getFloat("SelectExtraGemChance", cat, SELECT_EXTRA_GEM_CHANCE, 0.0f, 1.0f, "Chance that another gem will be selected after the previous one (for example, after one is\nselected this is the chance of getting a second.)");
        EQUIPMENT_DROP_CHANCE = c.getFloat("EquipmentDropChance", cat, EQUIPMENT_DROP_CHANCE, 0.0f, 1.0f, "Chance the item will be dropped on death (vanilla is 0.085)");
        SWORD_MULTI_HUMAN = c.getFloat("SwordMulti.Human", cat, SWORD_MULTI_HUMAN, 0.0f, 100.0f, "Multiplier for the chance that a Headcrumbs mob will spawn with gem equipment.");
        SWORD_MULTI_SKELETON = c.getFloat("SwordMulti.Skeleton", cat, SWORD_MULTI_SKELETON, 0.0f, 100.0f, "Multiplier for the chance that a Skelton will spawn with gem equipment.");
        SWORD_MULTI_ZOMBIE = c.getFloat("SwordMulti.Zombie", cat, SWORD_MULTI_ZOMBIE, 0.0f, 100.0f, "Multiplier for the chance that a Zombie will spawn with gem equipment.");
    }

    public static void tryGiveMobEquipment(EntityLivingBase entity) {
        if (!MODULE_ENABLED || entity.field_70170_p.field_72995_K || !(entity instanceof EntityMob)) {
            return;
        }
        EnumDifficulty worldDiff = entity.field_70170_p.func_175659_aa();
        DifficultyInstance localDiff = entity.field_70170_p.func_175649_E(entity.func_180425_c());
        Random rand = SilentGems.random;
        ItemStack sword = ItemStack.field_190927_a;
        if (entity instanceof EntityZombie) {
            if (ModuleEntityRandomEquipment.selectBasedOnDifficulty(SWORD_MULTI_ZOMBIE * SWORD_CHANCE, worldDiff, localDiff, rand)) {
                sword = ModuleEntityRandomEquipment.generateRandomMeleeWeapon(entity, rand);
            }
        } else if (entity instanceof EntitySkeleton && ModuleEntityRandomEquipment.selectBasedOnDifficulty(SWORD_MULTI_SKELETON * SWORD_CHANCE, worldDiff, localDiff, rand)) {
            sword = ModuleEntityRandomEquipment.generateRandomMeleeWeapon(entity, rand);
        }
        ItemStack currentMain = entity.func_184582_a(EntityEquipmentSlot.MAINHAND);
        if (!(sword.func_190926_b() || !currentMain.func_190926_b() && currentMain.func_77942_o())) {
            String makerName = SilentGems.i18n.miscText("tooltip.OriginalOwner.Mob", new Object[]{entity.func_70005_c_()});
            ToolHelper.setOriginalOwner(sword, makerName);
            entity.func_184201_a(EntityEquipmentSlot.MAINHAND, sword);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_184642_a(EntityEquipmentSlot.MAINHAND, EQUIPMENT_DROP_CHANCE);
            }
        }
    }

    @Nonnull
    public static ItemStack generateRandomMeleeWeapon(EntityLivingBase entity, Random rand) {
        int maxGemCount;
        ItemGemSword item;
        boolean genMachete;
        DifficultyInstance localDiff;
        EnumDifficulty worldDiff = entity.field_70170_p.func_175659_aa();
        boolean superTier = ModuleEntityRandomEquipment.selectBasedOnDifficulty(SUPER_CHANCE, worldDiff, localDiff = entity.field_70170_p.func_175649_E(entity.func_180425_c()), rand);
        boolean genKatana = superTier && rand.nextFloat() < KATANA_CHANCE;
        boolean bl = genMachete = !genKatana && rand.nextFloat() < MACHETE_CHANCE;
        if (genMachete) {
            item = ModItems.machete;
            maxGemCount = 3;
        } else if (genKatana) {
            item = ModItems.katana;
            maxGemCount = 3;
        } else {
            item = ModItems.sword;
            maxGemCount = rand.nextFloat() < SWORD_EXTRA_GEM_CHANCE ? 3 : 2;
        }
        Set<EnumGem> gemSet = ModuleEntityRandomEquipment.selectRandomGems(maxGemCount, rand);
        List<EnumGem> gemList = ModuleEntityRandomEquipment.expandGemsSet(gemSet, maxGemCount, rand);
        ArrayList mats = Lists.newArrayList();
        for (EnumGem gem : gemList) {
            mats.add(superTier ? gem.getItemSuper() : gem.getItem());
        }
        return item.constructTool(superTier, mats.toArray(new ItemStack[0]));
    }

    public static void equipEntityWithItem(EntityLivingBase entity, ItemStack stack, EntityEquipmentSlot slot) {
        if (entity == null || stack.func_190926_b()) {
            return;
        }
        ItemStack current = entity.func_184582_a(slot);
        if (!current.func_190926_b() && current.func_77942_o()) {
            return;
        }
        String makerName = SilentGems.i18n.miscText("tooltip.OriginalOwner.Mob", new Object[]{entity.func_70005_c_()});
        ItemStack copy = stack.func_77946_l();
        ToolHelper.setOriginalOwner(copy, makerName);
        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, copy);
    }

    public static Set<EnumGem> selectRandomGems(int maxCount, Random rand) {
        HashSet gems = Sets.newHashSet();
        for (int i = 0; i < maxCount; ++i) {
            int index = rand.nextInt(EnumGem.values().length);
            gems.add(EnumGem.values()[index]);
            if (!(rand.nextFloat() > SELECT_EXTRA_GEM_CHANCE)) continue;
            return gems;
        }
        return gems;
    }

    public static List<EnumGem> expandGemsSet(Set<EnumGem> gems, int targetCount, Random rand) {
        ArrayList list = Lists.newArrayList(gems.iterator());
        for (int i = list.size(); i < targetCount; ++i) {
            list.add(list.get(rand.nextInt(gems.size())));
        }
        return list;
    }

    public static boolean selectBasedOnDifficulty(float baseChance, EnumDifficulty worldDifficulty, DifficultyInstance localDifficulty, Random rand) {
        float f = 1.0f;
        switch (worldDifficulty) {
            case PEACEFUL: {
                return false;
            }
            case EASY: {
                f = 0.5f;
                break;
            }
            case NORMAL: {
                f = 1.0f;
                break;
            }
            case HARD: {
                f = 1.75f;
            }
        }
        return rand.nextFloat() < (f *= 1.0f + localDifficulty.func_180170_c()) * baseChance;
    }
}

