/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.part;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.IArmor;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.lib.IPartPosition;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.tool.part.ToolPartMain;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.tool.ItemGemBow;
import net.silentchaos512.gems.item.tool.ItemGemShield;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.util.StackHelper;

public class ToolPartGem
extends ToolPartMain {
    private EnumGem gem;
    private Map<String, ModelResourceLocation> modelMap = Maps.newHashMap();

    ToolPartGem(EnumGem gem, boolean supercharged) {
        super("silentgems:" + gem.name().toLowerCase() + (supercharged ? "_super" : ""), supercharged ? gem.getItemSuper() : gem.getItem());
        this.craftingOreDictName = supercharged ? gem.getItemSuperOreName() : gem.getItemOreName();
        this.gem = gem;
        this.tier = supercharged ? EnumMaterialTier.SUPER : EnumMaterialTier.REGULAR;
    }

    public EnumGem getGem() {
        return this.gem;
    }

    @Override
    public boolean matchesForDecorating(ItemStack partRep, boolean matchOreDict) {
        if (partRep.func_77973_b() == ModItems.gemShard && partRep.func_77952_i() == this.gem.ordinal()) {
            return true;
        }
        if (matchOreDict && StackHelper.matchesOreDict((ItemStack)partRep, (String)this.gem.getShardOreName())) {
            return true;
        }
        return super.matchesForDecorating(partRep, matchOreDict);
    }

    @Override
    public int getRepairAmount(ItemStack toolOrArmor, ItemStack partRep) {
        if (partRep.func_77973_b() == ModItems.gemShard) {
            return super.getRepairAmount(toolOrArmor, this.gem.getItem()) / 10;
        }
        return super.getRepairAmount(toolOrArmor, partRep);
    }

    @Override
    public int getColor(ItemStack toolOrArmor, IPartPosition position, int animationFrame) {
        boolean isTextureUncolored;
        Item item = toolOrArmor.func_77973_b();
        boolean bl = isTextureUncolored = position == ToolPartPosition.ROD_DECO || item instanceof IArmor || item instanceof ItemGemShield || item instanceof ItemGemBow;
        if (isTextureUncolored || ToolHelper.isBroken(toolOrArmor)) {
            return this.gem.getColor();
        }
        return 0xFFFFFF;
    }

    @Override
    public String getDisplayName(ItemStack stack) {
        if (stack.func_82837_s() || stack.func_77973_b() != ModItems.gem && stack.func_77973_b() != ModItems.gemSuper) {
            return stack.func_82833_r();
        }
        return SilentGems.i18n.translate("item", "gem" + stack.func_77952_i() + ".name", new Object[0]);
    }

    @Override
    public String getDisplayNamePrefix(ItemStack stack) {
        return this.tier == EnumMaterialTier.SUPER ? SilentGems.i18n.itemSubText("gem", "superPrefix", new Object[0]) : "";
    }

    @Override
    public ModelResourceLocation getModel(ItemStack tool, ToolPartPosition pos, int frame) {
        String name = tool.func_77973_b().getRegistryName().func_110623_a();
        name = "silentgems:" + name + "/" + name;
        String gemNum = tool.func_77973_b() instanceof ItemGemBow ? "" : "" + this.gem.ordinal();
        String frameNum = frame == 3 ? "_3" : "";
        switch (pos) {
            case HEAD: {
                name = name + gemNum + frameNum;
                break;
            }
            case ROD_DECO: {
                name = name + "_deco";
                break;
            }
            default: {
                return null;
            }
        }
        if (this.modelMap.containsKey(name)) {
            return this.modelMap.get(name);
        }
        name = name.toLowerCase();
        ModelResourceLocation model = new ModelResourceLocation(name, "inventory");
        this.modelMap.put(name, model);
        return model;
    }

    @Override
    public int getDurability() {
        return this.gem.getDurability(this.tier);
    }

    @Override
    public float getHarvestSpeed() {
        return this.gem.getMiningSpeed(this.tier);
    }

    @Override
    public int getHarvestLevel() {
        return this.tier == EnumMaterialTier.SUPER ? 4 : 2;
    }

    @Override
    public float getMeleeDamage() {
        return this.gem.getMeleeDamage(this.tier);
    }

    @Override
    public float getMagicDamage() {
        return this.gem.getMagicDamage(this.tier);
    }

    @Override
    public int getEnchantability() {
        return this.gem.getEnchantability(this.tier);
    }

    @Override
    public float getMeleeSpeed() {
        return this.gem.getMeleeSpeed(this.tier);
    }

    @Override
    public float getChargeSpeed() {
        return this.gem.getChargeSpeed(this.tier);
    }

    @Override
    public float getProtection() {
        return this.gem.getProtection(this.tier);
    }

    @Override
    public EnumMaterialTier getTier() {
        return this.tier;
    }
}

