/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.part;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.lib.IPartPosition;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.tool.part.ToolPartRod;
import net.silentchaos512.gems.item.ItemGemArrow;
import net.silentchaos512.gems.item.tool.ItemGemShield;

public class ToolPartRodGems
extends ToolPartRod {
    private Map<String, ModelResourceLocation> modelMap = Maps.newHashMap();
    private final String rodName;
    public final int color;

    ToolPartRodGems(String name, EnumMaterialTier tier, ItemStack stack, int color, float durabilityMulti, float harvestSpeedMulti, float meleeDamageMulti, float magicDamageMulti, float enchantabilityMulti) {
        super("silentgems:" + name, stack, durabilityMulti, harvestSpeedMulti, meleeDamageMulti, magicDamageMulti, enchantabilityMulti);
        this.rodName = name.toLowerCase().replaceFirst("rod", "rod_").replaceFirst("_stone", "_generic");
        this.tier = tier;
        this.color = color;
    }

    ToolPartRodGems(String name, EnumMaterialTier tier, ItemStack stack, int color, String oreName, float durabilityMulti, float harvestSpeedMulti, float meleeDamageMulti, float magicDamageMulti, float enchantabilityMulti) {
        super("silentgems:" + name, stack, oreName, durabilityMulti, harvestSpeedMulti, meleeDamageMulti, magicDamageMulti, enchantabilityMulti);
        this.rodName = name.toLowerCase().replaceFirst("rod", "rod_").replaceFirst("_stone", "_generic");
        this.tier = tier;
        this.color = color;
    }

    @Override
    public ModelResourceLocation getModel(ItemStack tool, ToolPartPosition pos, int frame) {
        String name = tool.func_77973_b().getRegistryName().func_110623_a();
        name = "silentgems:" + name.toLowerCase() + "/" + name + "_" + this.rodName;
        if (this.modelMap.containsKey(name)) {
            return this.modelMap.get(name);
        }
        name = name.toLowerCase();
        ModelResourceLocation model = new ModelResourceLocation(name, "inventory");
        this.modelMap.put(name, model);
        return model;
    }

    @Override
    public int getColor(ItemStack toolOrArmor, IPartPosition position, int animationFrame) {
        if (toolOrArmor.func_77973_b() instanceof ItemGemShield || toolOrArmor.func_77973_b() instanceof ItemGemArrow || this.rodName.equals("rod_generic")) {
            return this.color;
        }
        return 0xFFFFFF;
    }
}

