/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.soul;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.IArmor;
import net.silentchaos512.gems.api.IGearItem;
import net.silentchaos512.gems.api.tool.ToolStats;
import net.silentchaos512.gems.compat.gear.SGearProxy;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.item.ItemSoulGem;
import net.silentchaos512.gems.item.ItemToolSoul;
import net.silentchaos512.gems.lib.TooltipHelper;
import net.silentchaos512.gems.lib.soul.EnumSoulElement;
import net.silentchaos512.gems.lib.soul.SoulSkill;
import net.silentchaos512.gems.network.NetworkHandler;
import net.silentchaos512.gems.network.message.MessageSoulSync;
import net.silentchaos512.gems.util.SoulManager;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.util.ChatHelper;
import org.lwjgl.input.Keyboard;

public class ToolSoul {
    public static final float XP_FACTOR_KILLS = 0.35f;
    public static final float XP_FACTOR_TILLING = 4.0f;
    public static final float XP_FACTOR_BLOCK_MINED = 1.0f;
    public static final float XP_FACTOR_ARMOR_DAMAGED = 3.0f;
    public static final int XP_MAX_PER_BLOCK = 20;
    public static final float XP_MIN_BLOCK_HARDNESS = 0.5f;
    public static final int AP_START = 50;
    public static final int AP_PER_LEVEL = 10;
    public static final int AP_REGEN_DELAY = 120;
    static final int BASE_XP = 30;
    static final float XP_CURVE_FACTOR = 3.0f;
    String name = "";
    boolean readyToSave = false;
    int xp = 0;
    int level = 1;
    EnumSoulElement element1;
    EnumSoulElement element2 = EnumSoulElement.NONE;
    int actionPoints = 50;
    Map<SoulSkill, Integer> skills = new LinkedHashMap<SoulSkill, Integer>();
    public int climbTimer = 0;
    public int coffeeCooldown = 0;
    int ticksExisted = 0;
    final int apRegenSalt = SilentGems.random.nextInt(60);
    final int skillActivateSalt = SilentGems.random.nextInt(100);

    public void addXp(int amount, ItemStack tool, EntityPlayer player) {
        if (player instanceof FakePlayer && !GemsConfig.SOULS_GAIN_XP_FROM_FAKE_PLAYERS) {
            return;
        }
        this.xp += amount;
        boolean packetSent = false;
        while (this.xp >= this.getXpToNextLevel()) {
            SoulSkill skillLearned = this.levelUp(tool, player);
            Integer skillLevel = this.getSkillLevel(skillLearned);
            this.sendUpdatePacket(tool, player, skillLearned, skillLevel);
            packetSent = true;
        }
        if (!packetSent) {
            this.sendUpdatePacket(tool, player, null, 0);
        }
    }

    public int getXp() {
        return this.xp;
    }

    public void setXp(int packetAmount) {
        this.xp = packetAmount;
    }

    public int getXpToNextLevel() {
        return this.getXpForLevel(this.level + 1);
    }

    public int getXpForLevel(int target) {
        return 30 * (int)Math.pow(target, 3.0);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int packetAmount) {
        this.level = packetAmount;
    }

    public String getName(ItemStack tool) {
        if (this.name.isEmpty()) {
            if (!tool.func_190926_b()) {
                return tool.func_82833_r();
            }
            return SilentGems.i18n.miscText("toolsoul.nameless", new Object[0]);
        }
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public boolean hasName() {
        return !this.name.isEmpty();
    }

    @Nullable
    private SoulSkill levelUp(ItemStack tool, EntityPlayer player) {
        if (player == null || player.field_70170_p.field_72995_K) {
            return null;
        }
        ++this.level;
        String line = SilentGems.i18n.miscText("toolsoul.levelUp", new Object[]{this.getName(tool), this.level});
        ChatHelper.sendMessage((EntityPlayer)player, (String)line);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.0f);
        this.addActionPoints(10);
        SoulSkill toLearn = SoulSkill.selectSkillToLearn(this, tool);
        if (toLearn != null) {
            this.addOrLevelSkill(toLearn, tool, player);
        }
        ToolSoul.recalculateGearStats(tool, player);
        SoulManager.setSoul(tool, this, false);
        this.readyToSave = false;
        return toLearn;
    }

    public int getXpForBlockHarvest(World world, BlockPos pos, IBlockState state) {
        ItemStack blockStack;
        float hardness = state.func_185887_b(world, pos);
        if (hardness < 0.5f) {
            return 0;
        }
        int oreBonus = 0;
        Block block = state.func_177230_c();
        int blockMeta = state.func_177230_c().func_176201_c(state);
        if (block == Blocks.field_150439_ay) {
            block = Blocks.field_150450_ax;
            blockMeta = 0;
        }
        if (!(blockStack = new ItemStack(block, 1, blockMeta)).func_190926_b()) {
            for (int oreId : OreDictionary.getOreIDs((ItemStack)blockStack)) {
                String oreName = OreDictionary.getOreName((int)oreId);
                if (!oreName.startsWith("ore") && !oreName.startsWith("log")) continue;
                oreBonus = this.level / 2;
                break;
            }
        } else {
            SilentGems.logHelper.warn("ToolSoul#getXpForBlockHarvest: Invalid block stack for " + block + " (meta " + blockMeta + ")", new Object[0]);
        }
        if (state.func_185904_a() == Material.field_151575_d) {
            hardness /= 2.0f;
        }
        int clamp = MathHelper.func_76125_a((int)Math.round(1.0f * hardness), (int)1, (int)20);
        return oreBonus + clamp;
    }

    public static void recalculateGearStats(ItemStack stack, EntityPlayer player) {
        if (stack.func_77973_b() instanceof IGearItem) {
            ToolHelper.recalculateStats(stack);
        } else if (SGearProxy.isGearItem(stack)) {
            SGearProxy.recalculateStats(stack, player);
        }
    }

    public int getActionPoints() {
        return this.actionPoints;
    }

    public void addActionPoints(int amount) {
        this.actionPoints = MathHelper.func_76125_a((int)(this.actionPoints + amount), (int)0, (int)this.getMaxActionPoints());
    }

    public void setActionPoints(int packetAmount) {
        this.actionPoints = packetAmount;
    }

    public int getMaxActionPoints() {
        return 50 + 10 * (this.level - 1);
    }

    public EnumSoulElement getPrimaryElement() {
        return this.element1;
    }

    public EnumSoulElement getSecondaryElement() {
        return this.element2;
    }

    public boolean addOrLevelSkill(SoulSkill skill, ItemStack tool, EntityPlayer player) {
        if (skill == null) {
            return false;
        }
        if (this.skills.containsKey(skill)) {
            int level = this.skills.get(skill);
            if (level < skill.maxLevel) {
                this.skills.put(skill, ++level);
                if (player != null) {
                    ChatHelper.sendMessage((EntityPlayer)player, (String)SilentGems.i18n.miscText("toolsoul.skillLearned", new Object[]{skill.getLocalizedName(tool, level)}));
                }
                return true;
            }
            return false;
        }
        this.skills.put(skill, 1);
        if (player != null) {
            ChatHelper.sendMessage((EntityPlayer)player, (String)SilentGems.i18n.miscText("toolsoul.skillLearned", new Object[]{skill.getLocalizedName(tool, 1)}));
        }
        return true;
    }

    public void setSkillLevel(SoulSkill skill, int skillLevel, ItemStack tool, EntityPlayer player) {
        if (skill == null) {
            return;
        }
        if (skillLevel <= 0) {
            this.skills.remove(skill);
        }
        this.skills.put(skill, skillLevel > skill.maxLevel ? skill.maxLevel : skillLevel);
    }

    public boolean hasSkill(SoulSkill skill) {
        return this.skills.containsKey(skill);
    }

    public int getSkillLevel(SoulSkill skill) {
        if (!this.hasSkill(skill)) {
            return 0;
        }
        return this.skills.get(skill);
    }

    public void addInformation(ItemStack stack, World world, List<String> list, boolean advanced) {
        String color = "" + TextFormatting.GREEN;
        list.add(color + SilentGems.i18n.miscText("toolsoul.level", new Object[]{this.level, this.xp, this.getXpToNextLevel()}));
        list.add(color + SilentGems.i18n.miscText("toolsoul.actionPoints", new Object[]{this.actionPoints, this.getMaxActionPoints()}));
        boolean skillsKeyDown = Keyboard.isKeyDown((int)31);
        if (skillsKeyDown || stack.func_77973_b() instanceof ItemToolSoul) {
            String e1 = this.element1 == null ? "None" : this.element1.getDisplayName();
            String e2 = this.element2 == null ? "None" : this.element2.getDisplayName();
            String elements = e1 + (e2.equalsIgnoreCase("none") ? "" : ", " + e2);
            list.add(SilentGems.i18n.miscText("toolsoul.elements", new Object[]{elements}));
        }
        if (skillsKeyDown) {
            color = "  " + TextFormatting.YELLOW;
            float durability = ToolSoul.getDurabilityModifierForDisplay(this);
            float harvestSpeed = ToolSoul.getHarvestSpeedModifierForDisplay(this);
            float meleeDamage = ToolSoul.getMeleeDamageModifierForDisplay(this);
            float magicDamage = ToolSoul.getMagicDamageModifierForDisplay(this);
            float protection = ToolSoul.getProtectionModifierForDisplay(this);
            if (durability != 0.0f) {
                list.add(color + TooltipHelper.getAsColoredPercentage("Durability", durability, 0, true));
            }
            if (harvestSpeed != 0.0f) {
                list.add(color + TooltipHelper.getAsColoredPercentage("HarvestSpeed", harvestSpeed, 0, true));
            }
            if (meleeDamage != 0.0f) {
                list.add(color + TooltipHelper.getAsColoredPercentage("MeleeDamage", meleeDamage, 0, true));
            }
            if (magicDamage != 0.0f) {
                list.add(color + TooltipHelper.getAsColoredPercentage("MagicDamage", magicDamage, 0, true));
            }
            if (protection != 0.0f) {
                list.add(color + TooltipHelper.getAsColoredPercentage("Protection", protection, 0, true));
            }
            for (Map.Entry<SoulSkill, Integer> entry : this.skills.entrySet()) {
                SoulSkill skill = entry.getKey();
                int level = entry.getValue();
                list.add("  " + skill.getLocalizedName(stack, level));
            }
        } else {
            list.add(TextFormatting.GOLD + SilentGems.i18n.miscText("tooltip.keyForSkills", new Object[0]));
        }
    }

    public void applyToStats(ToolStats stats) {
        stats.durability *= this.getDurabilityModifier();
        stats.harvestSpeed *= this.getHarvestSpeedModifier();
        stats.meleeDamage *= this.getMeleeDamageModifier();
        stats.magicDamage *= this.getMagicDamageModifier();
        stats.protection *= this.getProtectionModifier();
        for (Map.Entry<SoulSkill, Integer> entry : this.skills.entrySet()) {
            SoulSkill skill = entry.getKey();
            int level = entry.getValue();
            skill.applyToStats(stats, level);
        }
    }

    protected float getDurabilityModifier() {
        return 1.0f + this.element1.durabilityModifier + this.element2.durabilityModifier / 2.0f;
    }

    protected float getHarvestSpeedModifier() {
        return 1.0f + this.element1.harvestSpeedModifier + this.element2.harvestSpeedModifier / 2.0f;
    }

    protected float getMeleeDamageModifier() {
        return 1.0f + this.element1.meleeDamageModifier + this.element2.meleeDamageModifier / 2.0f;
    }

    protected float getMagicDamageModifier() {
        return 1.0f + this.element1.magicDamageModifier + this.element2.magicDamageModifier / 2.0f;
    }

    protected float getProtectionModifier() {
        return 1.0f + this.element1.protectionModifier + this.element2.protectionModifier / 2.0f;
    }

    public static float getDurabilityModifierForDisplay(@Nullable ToolSoul soul) {
        if (soul == null) {
            return 0.0f;
        }
        float val = soul.getDurabilityModifier();
        SoulSkill skill = SoulSkill.DURABILITY_BOOST;
        val = ToolSoul.getSkillStatModifier(soul, val, skill);
        return val - 1.0f;
    }

    public static float getHarvestSpeedModifierForDisplay(@Nullable ToolSoul soul) {
        if (soul == null) {
            return 0.0f;
        }
        float val = soul.getHarvestSpeedModifier();
        SoulSkill skill = SoulSkill.HARVEST_SPEED_BOOST;
        val = ToolSoul.getSkillStatModifier(soul, val, skill);
        return val - 1.0f;
    }

    public static float getMeleeDamageModifierForDisplay(@Nullable ToolSoul soul) {
        if (soul == null) {
            return 0.0f;
        }
        float val = soul.getMeleeDamageModifier();
        SoulSkill skill = SoulSkill.MELEE_DAMAGE_BOOST;
        val = ToolSoul.getSkillStatModifier(soul, val, skill);
        return val - 1.0f;
    }

    public static float getMagicDamageModifierForDisplay(@Nullable ToolSoul soul) {
        if (soul == null) {
            return 0.0f;
        }
        float val = soul.getMagicDamageModifier();
        SoulSkill skill = SoulSkill.MAGIC_DAMAGE_BOOST;
        val = ToolSoul.getSkillStatModifier(soul, val, skill);
        return val - 1.0f;
    }

    public static float getProtectionModifierForDisplay(@Nullable ToolSoul soul) {
        if (soul == null) {
            return 0.0f;
        }
        float val = soul.getProtectionModifier();
        SoulSkill skill = SoulSkill.PROTECTION_BOOST;
        val = ToolSoul.getSkillStatModifier(soul, val, skill);
        return val - 1.0f;
    }

    private static float getSkillStatModifier(ToolSoul soul, float val, SoulSkill skill) {
        if (skill != null && soul.skills != null && soul.skills.containsKey(skill)) {
            int lvl = soul.skills.get(skill);
            val += skill.getStatBoostMulti() * (float)lvl;
        }
        return val;
    }

    public static ToolSoul construct(ItemSoulGem.Soul ... souls) {
        EnumMap<EnumSoulElement, Integer> elements = new EnumMap<EnumSoulElement, Integer>(EnumSoulElement.class);
        for (ItemSoulGem.Soul soul : souls) {
            if (soul == null) {
                SilentGems.logHelper.error("Got a null soul when constructing a tool soul", new Object[]{new NullPointerException("soul is null")});
                continue;
            }
            int current = elements.getOrDefault((Object)soul.element1, 0);
            elements.put(soul.element1, current + 5);
            if (soul.element2 == EnumSoulElement.NONE) continue;
            current = elements.getOrDefault((Object)soul.element2, 0);
            elements.put(soul.element2, current + 3);
        }
        ToolSoul toolSoul = new ToolSoul();
        toolSoul.element1 = ToolSoul.selectHighestWeight(elements);
        elements.remove((Object)toolSoul.element1);
        if (!elements.isEmpty()) {
            toolSoul.element2 = ToolSoul.selectHighestWeight(elements);
        }
        return toolSoul;
    }

    public static ToolSoul randomSoul() {
        ToolSoul soul = new ToolSoul();
        ArrayList<EnumSoulElement> elements = new ArrayList<EnumSoulElement>();
        for (EnumSoulElement elem : EnumSoulElement.values()) {
            if (elem == EnumSoulElement.NONE) continue;
            elements.add(elem);
        }
        soul.element1 = (EnumSoulElement)((Object)elements.get(SilentGems.random.nextInt(elements.size())));
        elements.remove((Object)soul.element1);
        elements.add(EnumSoulElement.NONE);
        soul.element2 = (EnumSoulElement)((Object)elements.get(SilentGems.random.nextInt(elements.size())));
        return soul;
    }

    private static EnumSoulElement selectHighestWeight(Map<EnumSoulElement, Integer> elements) {
        EnumSoulElement element = EnumSoulElement.NONE;
        int highestWeight = 0;
        for (Map.Entry<EnumSoulElement, Integer> entry : elements.entrySet()) {
            EnumSoulElement elementInMap = entry.getKey();
            int weightInMap = entry.getValue();
            if (weightInMap <= highestWeight && (weightInMap != highestWeight || elementInMap.weight <= element.weight)) continue;
            element = entry.getKey();
            highestWeight = entry.getValue();
        }
        return element;
    }

    public void updateTick(ItemStack tool, EntityPlayer player) {
        boolean sendUpdate = false;
        if (!player.field_70170_p.field_72995_K) {
            ++this.ticksExisted;
            int regenDelay = 120;
            if ((this.ticksExisted + this.apRegenSalt) % regenDelay == 0) {
                this.addActionPoints(1);
                sendUpdate = true;
            }
            if (this.coffeeCooldown > 0) {
                --this.coffeeCooldown;
            }
        }
        boolean inMainHand = player.func_184614_ca() == tool;
        boolean isInHand = inMainHand || player.func_184592_cb() == tool;
        boolean isArmor = tool.func_77973_b() instanceof IArmor;
        int time = this.ticksExisted + this.skillActivateSalt;
        for (SoulSkill skill : this.skills.keySet()) {
            if (!isInHand && !isArmor && !skill.canActivateWhenUnequipped()) continue;
            int skillLevel = this.skills.get(skill);
            if (time % skill.getActivateDelay() != 0 || !skill.activate(this, tool, player, skillLevel)) continue;
            this.addActionPoints(-skill.apCost);
            if (player.field_70170_p.field_72995_K || !skill.sendChatMessageOnActivation()) continue;
            ChatHelper.sendMessage((EntityPlayer)player, (String)SilentGems.i18n.miscText("toolsoul.activated", new Object[]{this.getName(tool), skill.getLocalizedName(tool, skillLevel)}));
        }
        if (this.readyToSave && !inMainHand) {
            this.readyToSave = false;
            SoulManager.setSoul(tool, this, false);
        }
        if (sendUpdate) {
            this.sendUpdatePacket(tool, player, null, 0);
        }
    }

    public void setReadyToSave(boolean value) {
        this.readyToSave = value;
    }

    public boolean activateSkillsOnBlock(ItemStack tool, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ) {
        AtomicBoolean activated = new AtomicBoolean(false);
        this.skills.forEach((skill, level) -> activated.set(activated.get() || skill.activateOnBlock(this, tool, player, (int)level, world, pos, facing, hitX, hitY, hitZ)));
        return activated.get();
    }

    public boolean activateSkillsOnEntity(ItemStack tool, EntityPlayer player, EntityLivingBase target) {
        AtomicBoolean activated = new AtomicBoolean(false);
        this.skills.forEach((skill, level) -> activated.set(activated.get() || skill.onDamageEntity(this, tool, player, (int)level, target)));
        return activated.get();
    }

    public static ToolSoul readFromNBT(NBTTagCompound tags) {
        ToolSoul soul = new ToolSoul();
        soul.name = tags.func_74779_i("name");
        String e1 = tags.func_74779_i("element1");
        String e2 = tags.func_74779_i("element2");
        for (EnumSoulElement element : EnumSoulElement.values()) {
            if (element.name().equalsIgnoreCase(e1)) {
                soul.element1 = element;
                continue;
            }
            if (!element.name().equalsIgnoreCase(e2)) continue;
            soul.element2 = element;
        }
        soul.xp = tags.func_74762_e("xp");
        soul.level = tags.func_74762_e("level");
        soul.actionPoints = tags.func_74762_e("ap");
        soul.skills.clear();
        NBTTagList tagList = tags.func_150295_c("skills", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            SoulSkill skill = SoulSkill.getById(tagCompound.func_74779_i("id"));
            if (skill == null) continue;
            short level = tagCompound.func_74765_d("level");
            soul.skills.put(skill, Integer.valueOf(level));
        }
        return soul;
    }

    public void writeToNBT(NBTTagCompound tags) {
        if (!this.name.isEmpty()) {
            tags.func_74778_a("name", this.name);
        }
        tags.func_74778_a("element1", this.element1.name());
        tags.func_74778_a("element2", this.element2.name());
        tags.func_74768_a("xp", this.xp);
        tags.func_74768_a("level", this.level);
        tags.func_74768_a("ap", this.actionPoints);
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<SoulSkill, Integer> entry : this.skills.entrySet()) {
            SoulSkill skill = entry.getKey();
            int level = entry.getValue();
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74778_a("id", skill.id);
            tagCompound.func_74777_a("level", (short)level);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tags.func_74782_a("skills", (NBTBase)tagList);
    }

    public String toString() {
        return "ToolSoul{Level: " + this.level + ", XP: " + this.xp + ", Elements: {" + this.element1.name() + ", " + this.element2.name() + "}}";
    }

    private void sendUpdatePacket(ItemStack tool, EntityPlayer player, SoulSkill skillLearned, int skillLevel) {
        if (!player.field_70170_p.field_72995_K) {
            UUID uuid = ToolHelper.getSoulUUID(tool);
            MessageSoulSync message = new MessageSoulSync(uuid, this.xp, this.level, this.actionPoints, skillLearned, skillLevel);
            NetworkHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)player);
        }
    }
}

