/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.soul;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.ItemPart;
import net.silentchaos512.gear.api.parts.ItemPartData;
import net.silentchaos512.gear.api.parts.PartOrigins;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gems.lib.soul.ToolSoul;
import net.silentchaos512.gems.util.SoulManager;
import net.silentchaos512.utils.MathUtils;

public class ToolSoulPart
extends ItemPart {
    public static final PartType PART_TYPE = PartType.create((String)"gear_soul", (String)"S", ToolSoulPart::new);
    public static final IPartPosition PART_POSITION = new IPartPosition(){

        public String getTexturePrefix() {
            return "";
        }

        public String getModelIndex() {
            return "";
        }
    };

    public ToolSoulPart(ResourceLocation name, PartOrigins origin) {
        super(name, origin);
    }

    public PartType getType() {
        return PART_TYPE;
    }

    public IPartPosition getPartPosition() {
        return PART_POSITION;
    }

    public void addInformation(ItemPartData itemPartData, ItemStack itemStack, World world, List<String> list, boolean b) {
    }

    public String getTypeName() {
        return "gear_soul";
    }

    @Nullable
    public ResourceLocation getTexture(ItemPartData part, ItemStack gear, String gearClass, IPartPosition position, int animationFrame) {
        return null;
    }

    @Nullable
    public ResourceLocation getBrokenTexture(ItemPartData part, ItemStack gear, String gearClass, IPartPosition position) {
        return null;
    }

    public Collection<StatInstance> getStatModifiers(ItemStack gear, ItemStat stat, ItemPartData part) {
        float amount;
        ArrayList<StatInstance> mods = new ArrayList<StatInstance>();
        ToolSoul soul = SoulManager.getSoul(!gear.func_190926_b() ? gear : part.getCraftingItem());
        if (soul != null && !MathUtils.doublesEqual((double)(amount = ToolSoulPart.getSoulStatModifier(soul, stat)), (double)0.0)) {
            mods.add(ToolSoulPart.getSoulBoostedModifier(stat, amount - 1.0f));
        }
        return mods;
    }

    private static float getSoulStatModifier(ToolSoul soul, ItemStat stat) {
        if (stat == CommonItemStats.ARMOR) {
            return soul.getProtectionModifier();
        }
        if (stat == CommonItemStats.DURABILITY) {
            return soul.getDurabilityModifier();
        }
        if (stat == CommonItemStats.HARVEST_SPEED) {
            return soul.getHarvestSpeedModifier();
        }
        if (stat == CommonItemStats.MAGIC_DAMAGE) {
            return soul.getMagicDamageModifier();
        }
        if (stat == CommonItemStats.MELEE_DAMAGE) {
            return soul.getMeleeDamageModifier();
        }
        return 0.0f;
    }

    private static StatInstance getSoulBoostedModifier(ItemStat stat, float value) {
        return new StatInstance("silentgems:soul/" + stat.getName().func_110623_a(), value, StatInstance.Operation.MUL1);
    }
}

