/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.potion;

import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.lib.EnumModParticles;
import net.silentchaos512.gems.util.ModDamageSource;
import net.silentchaos512.lib.util.Color;

public class PotionFreezing
extends Potion {
    public static final int CONTINUOUS_DAMAGE_DELAY = 40;
    public static final int CONTINUOUS_DAMAGE_AMOUNT = 1;
    public static boolean CONTINUOUS_DAMAGE_ENABLED = true;
    public AttributeModifier modifier;

    public PotionFreezing() {
        super(true, 9239551);
        this.func_76390_b("effect.silentgems.freezing");
        this.modifier = new AttributeModifier(UUID.fromString("c45e3a61-996a-4cea-977c-5d315365631a"), this.func_76393_a(), -0.5, 2);
    }

    public void func_76394_a(EntityLivingBase entityLiving, int amplifier) {
        if (CONTINUOUS_DAMAGE_ENABLED) {
            PotionEffect effect = entityLiving.func_70660_b((Potion)this);
            if (effect == null) {
                return;
            }
            int damageDelay = 40;
            if (entityLiving.func_70045_F()) {
                damageDelay /= 4;
            }
            if (effect.func_76459_b() % damageDelay == 0) {
                boolean damageAmount = true;
                entityLiving.func_70097_a(ModDamageSource.FREEZING, (float)damageAmount);
            }
        }
        Random rand = SilentGems.random;
        for (int i = 0; i < 2; ++i) {
            double posX = entityLiving.field_70165_t + (double)(1.2f * (rand.nextFloat() - 0.5f) * entityLiving.field_70130_N);
            double posY = entityLiving.field_70163_u + (double)(1.1f * rand.nextFloat() * entityLiving.field_70131_O);
            double posZ = entityLiving.field_70161_v + (double)(1.2f * (rand.nextFloat() - 0.5f) * entityLiving.field_70130_N);
            double motionX = 0.005 * rand.nextGaussian();
            double motionY = 0.005 * rand.nextGaussian();
            double motionZ = 0.005 * rand.nextGaussian();
            SilentGems.proxy.spawnParticles(EnumModParticles.FREEZING, new Color(7791602), entityLiving.field_70170_p, posX, posY, posZ, motionX, motionY, motionZ);
        }
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }

    public void func_111185_a(EntityLivingBase entityLiving, AbstractAttributeMap attributeMap, int amplifier) {
        IAttributeInstance iattributeinstance = attributeMap.func_111151_a(SharedMonsterAttributes.field_111263_d);
        if (iattributeinstance != null) {
            double amount = this.modifier.func_111164_d() * (double)(amplifier + 1);
            if (entityLiving instanceof EntityPlayer) {
                amount /= 2.0;
            }
            iattributeinstance.func_111124_b(this.modifier);
            iattributeinstance.func_111121_a(new AttributeModifier(this.modifier.func_111167_a(), this.func_76393_a() + " " + amplifier, amount, this.modifier.func_111169_c()));
        }
    }

    public void func_111187_a(EntityLivingBase entityLivingBaseIn, AbstractAttributeMap attributeMapIn, int amplifier) {
        IAttributeInstance iattributeinstance = attributeMapIn.func_111151_a(SharedMonsterAttributes.field_111263_d);
        if (iattributeinstance != null) {
            iattributeinstance.func_111124_b(this.modifier);
        }
    }
}

