/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.recipe;

import com.google.gson.JsonObject;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.recipe.DummyRecipe;

public class EnchantmentTokenRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext jsonContext, JsonObject jsonObject) {
        ShapedOreRecipe recipe = ShapedOreRecipe.factory((JsonContext)jsonContext, (JsonObject)jsonObject);
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = recipe.getRecipeWidth();
        primer.height = recipe.getRecipeHeight();
        primer.mirrored = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"mirrored", (boolean)true);
        primer.input = recipe.func_192400_c();
        JsonObject resultObj = jsonObject.getAsJsonObject("result");
        if (resultObj == null || !resultObj.has("enchantment")) {
            throw new NullPointerException("Missing enchantment in token recipe!");
        }
        String key = resultObj.get("enchantment").getAsString();
        Enchantment enchantment = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)new ResourceLocation(key));
        if (enchantment == null) {
            if (SilentGems.instance.isDevBuild()) {
                throw new NullPointerException("Enchantment '" + key + "' not found!");
            }
            return new DummyRecipe();
        }
        ItemStack result = ModItems.enchantmentToken.constructToken(enchantment);
        result.func_190920_e(recipe.func_77571_b().func_190916_E());
        return new ShapedOreRecipe(new ResourceLocation("silentgems", "enchantment_token"), result, primer);
    }
}

