/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.recipe;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.DyeUtils;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.gems.lib.urn.IUrnUpgradeItem;
import net.silentchaos512.gems.lib.urn.UrnHelper;
import net.silentchaos512.gems.lib.urn.UrnUpgrade;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.lib.recipe.RecipeBaseSL;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.StackHelper;

public class RecipeSoulUrnModify
extends RecipeBaseSL {
    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        StackList list = StackHelper.getNonEmptyStacks((IInventory)inv);
        ItemStack urn = list.uniqueMatch(RecipeSoulUrnModify::isSoulUrn);
        Collection mods = list.allMatches(RecipeSoulUrnModify::isModifierItem);
        Collection dyes = list.allMatches(DyeUtils::isDye);
        for (ItemStack mod : mods) {
            if (!(mod.func_77973_b() instanceof IUrnUpgradeItem)) continue;
            IUrnUpgradeItem upgradeItem = (IUrnUpgradeItem)mod.func_77973_b();
            NonNullList<UrnUpgrade> currentUpgrades = UrnUpgrade.ListHelper.load(urn);
            if (!UrnUpgrade.ListHelper.contains(currentUpgrades, upgradeItem.getSerializer())) continue;
            return false;
        }
        return !urn.func_190926_b() && (list.size() == 1 || !mods.isEmpty() || !dyes.isEmpty());
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        StackList list = StackHelper.getNonEmptyStacks((IInventory)inv);
        ItemStack urn = list.uniqueMatch(RecipeSoulUrnModify::isSoulUrn).func_77946_l();
        Collection mods = list.allMatches(RecipeSoulUrnModify::isModifierItem);
        Collection dyes = list.allMatches(DyeUtils::isDye);
        if (mods.isEmpty() && dyes.isEmpty()) {
            boolean lidless = UrnHelper.isLidless(urn);
            UrnHelper.setLidless(urn, !lidless);
        } else {
            mods.forEach(mod -> RecipeSoulUrnModify.applyModifierItem(urn, mod));
            RecipeSoulUrnModify.applyDyes(urn, dyes);
        }
        return urn;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((Block)ModBlocks.soulUrn);
    }

    private static boolean isSoulUrn(ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.soulUrn);
    }

    private static boolean isModifierItem(ItemStack stack) {
        return stack.func_77973_b() == ModItems.gem || stack.func_77973_b() instanceof IUrnUpgradeItem;
    }

    private static void applyModifierItem(ItemStack urn, ItemStack mod) {
        SilentGems.logHelper.debug("RecipeSoulUrnModify#applyModifierItem: {}, {}", new Object[]{urn, mod});
        if (mod.func_77973_b() == ModItems.gem) {
            EnumGem gem = EnumGem.getFromStack(mod);
            UrnHelper.setGem(urn, gem);
        } else if (mod.func_77973_b() instanceof IUrnUpgradeItem) {
            IUrnUpgradeItem upgradeItem = (IUrnUpgradeItem)mod.func_77973_b();
            NBTTagCompound urnSubcompound = urn.func_190925_c("BlockEntityTag");
            NonNullList<UrnUpgrade> list = UrnUpgrade.ListHelper.load(urnSubcompound);
            list.add(upgradeItem.getSerializer().deserialize(new NBTTagCompound()));
            UrnUpgrade.ListHelper.save(list, urnSubcompound);
        }
    }

    private static void applyDyes(ItemStack urn, Collection<ItemStack> dyes) {
        int[] componentSums = new int[3];
        int maxColorSum = 0;
        int colorCount = 0;
        int clayColor = UrnHelper.getClayColor(urn);
        if (clayColor != 9985861) {
            float r = (float)(clayColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(clayColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(clayColor & 0xFF) / 255.0f;
            maxColorSum = (int)((float)maxColorSum + Math.max(r, Math.max(g, b)) * 255.0f);
            componentSums[0] = (int)((float)componentSums[0] + r * 255.0f);
            componentSums[1] = (int)((float)componentSums[1] + g * 255.0f);
            componentSums[2] = (int)((float)componentSums[2] + b * 255.0f);
            ++colorCount;
        }
        for (ItemStack dye : dyes) {
            float[] componentValues = DyeUtils.colorFromStack((ItemStack)dye).orElse(EnumDyeColor.WHITE).func_193349_f();
            int r = (int)(componentValues[0] * 255.0f);
            int g = (int)(componentValues[1] * 255.0f);
            int b = (int)(componentValues[2] * 255.0f);
            maxColorSum += Math.max(r, Math.max(g, b));
            componentSums[0] = componentSums[0] + r;
            componentSums[1] = componentSums[1] + g;
            componentSums[2] = componentSums[2] + b;
            ++colorCount;
        }
        if (colorCount > 0) {
            int r = componentSums[0] / colorCount;
            int g = componentSums[1] / colorCount;
            int b = componentSums[2] / colorCount;
            float maxAverage = (float)maxColorSum / (float)colorCount;
            float max = Math.max(r, Math.max(g, b));
            r = (int)((float)r * maxAverage / max);
            g = (int)((float)g * maxAverage / max);
            b = (int)((float)b * maxAverage / max);
            int finalColor = (r << 8) + g;
            finalColor = (finalColor << 8) + b;
            UrnHelper.setClayColor(urn, finalColor);
        }
    }

    public static Collection<IRecipe> getExampleRecipes() {
        ArrayList<IRecipe> result = new ArrayList<IRecipe>();
        RecipeMaker recipes = SilentGems.registry.getRecipeMaker();
        ItemStack urnBasic = ModBlocks.soulUrn.getStack(9985861, null);
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            result.add(recipes.makeShapeless(ModBlocks.soulUrn.getStack(enumDyeColor.func_193350_e(), null), new ItemStack[]{urnBasic, new ItemStack(Items.field_151100_aR, 1, enumDyeColor.func_176767_b())}));
        }
        for (EnumGem enumGem : EnumGem.values()) {
            result.add(recipes.makeShapeless(ModBlocks.soulUrn.getStack(9985861, enumGem), new ItemStack[]{urnBasic, enumGem.getItem()}));
        }
        return result;
    }
}

