/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.skills;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.handler.PlayerDataHandler;
import net.silentchaos512.gems.lib.soul.ToolSoul;
import net.silentchaos512.gems.skills.ToolSkillDigger;
import net.silentchaos512.gems.util.SoulManager;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.util.ChatHelper;

public class SkillAreaMiner
extends ToolSkillDigger {
    public static final float DIG_SPEED_MULTIPLIER = 0.33f;
    public static final int CHAOS_COST = 100;
    public static final SkillAreaMiner INSTANCE = new SkillAreaMiner();

    @Override
    public void onGetBreakSpeed(PlayerEvent.BreakSpeed event) {
        int cost;
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(event.getEntityPlayer());
        int n = cost = event.getEntityPlayer().field_71075_bZ.field_75098_d ? 0 : 100;
        if (data.chaos >= cost) {
            event.setNewSpeed(event.getNewSpeed() * 0.33f);
        }
    }

    @Override
    public int getCost(ItemStack tool, EntityPlayer player, BlockPos pos) {
        return player.field_71075_bZ.field_75098_d ? 0 : 100;
    }

    @Override
    public boolean activate(ItemStack tool, EntityPlayer player, BlockPos pos) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        Item item = tool.func_77973_b();
        if (state == null || state.func_177230_c() == null) {
            return false;
        }
        if (ToolHelper.getToolTier(tool).ordinal() < EnumMaterialTier.SUPER.ordinal() || !ToolHelper.isSpecialAbilityEnabled(tool)) {
            return false;
        }
        if (!this.isToolEffective(tool, world, pos, state)) {
            return false;
        }
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
        int cost = this.getCost(tool, player, pos);
        if (data.chaos < cost) {
            String msg = SilentGems.i18n.translate("skill", "all.insufficientChaos", new Object[0]);
            ChatHelper.sendStatusMessage((EntityPlayer)player, (String)msg, (boolean)true);
            return false;
        }
        data.drainChaos(cost);
        RayTraceResult mop = this.raytraceFromEntity(world, (Entity)player, false, 4.5);
        if (mop == null) {
            return false;
        }
        int sideHit = mop.field_178784_b.func_176745_a();
        int xRange = 1;
        int yRange = 1;
        int zRange = 0;
        switch (sideHit) {
            case 0: 
            case 1: {
                yRange = 0;
                zRange = 1;
                break;
            }
            case 2: 
            case 3: {
                xRange = 1;
                zRange = 0;
                break;
            }
            case 4: 
            case 5: {
                xRange = 0;
                zRange = 1;
            }
        }
        int blocksBroken = 0;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
            for (int yPos = y - yRange; yPos <= y + yRange; ++yPos) {
                for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                    if (xPos == x && yPos == y && zPos == z || !this.breakExtraBlock(tool, player.field_70170_p, new BlockPos(xPos, yPos, zPos), player, pos)) continue;
                    ++blocksBroken;
                }
            }
        }
        ToolHelper.incrementStatBlocksMined(tool, blocksBroken);
        return true;
    }

    protected boolean isToolEffective(ItemStack tool, World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        if (tool.func_150998_b(state)) {
            return true;
        }
        if (tool.func_77973_b() instanceof ITool) {
            for (Material material : ((ITool)tool.func_77973_b()).getExtraEffectiveMaterials(tool)) {
                if (state.func_185904_a() != material) continue;
                return true;
            }
        }
        return ForgeHooks.isToolEffective((IBlockAccess)world, (BlockPos)pos, (ItemStack)tool);
    }

    public boolean breakExtraBlock(ItemStack tool, World world, BlockPos pos, EntityPlayer playerEntity, BlockPos refPos) {
        boolean canceled;
        if (world.func_175623_d(pos)) {
            return false;
        }
        if (!(playerEntity instanceof EntityPlayerMP)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        EntityPlayerMP player = (EntityPlayerMP)playerEntity;
        if (!this.isToolEffective(tool, world, pos, state)) {
            return false;
        }
        IBlockState refState = world.func_180495_p(refPos);
        float refStrength = player.getDigSpeed(refState, refPos) / refState.func_185887_b(world, refPos) / 30.0f;
        float strength = ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) || refStrength / strength > 10.0f) {
            return false;
        }
        int xpDropped = ForgeHooks.onBlockBreakEvent((World)world, (GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (BlockPos)pos);
        boolean bl = canceled = xpDropped == -1;
        if (canceled) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_176208_a(world, pos, state, (EntityPlayer)player);
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)player, false)) {
                block.func_176206_d(world, pos, state);
            }
            if (!world.field_72995_K) {
                player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            }
            return true;
        }
        tool.func_179548_a(world, state, pos, (EntityPlayer)player);
        ToolSoul soul = SoulManager.getSoul(tool);
        if (soul != null) {
            SoulManager.addSoulXp(soul.getXpForBlockHarvest(world, pos, state), tool, (EntityPlayer)player);
        }
        if (!world.field_72995_K) {
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)player, true)) {
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, (EntityPlayer)player, pos, state, world.func_175625_s(pos), tool);
                block.func_180637_b(world, pos, xpDropped);
            }
            player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            int meta = block.func_176201_c(state);
            world.func_175718_b(2001, pos, Block.func_149682_b((Block)block) + (meta << 12));
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)player, true)) {
                block.func_176206_d(world, pos, state);
            }
            tool.func_179548_a(world, state, pos, (EntityPlayer)player);
        }
        return true;
    }

    private RayTraceResult raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            d1 += 1.62;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        if (player instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3d vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, par3, !par3, par3);
    }

    @Override
    public String getTranslatedName() {
        return SilentGems.i18n.translate("skill", "AreaMiner", new Object[0]);
    }
}

