/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.tile;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.lib.EnumModParticles;
import net.silentchaos512.gems.tile.TilePhantomLight;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.tile.TileInventorySL;
import net.silentchaos512.lib.util.Color;

public class TileChaosFlowerPot
extends TileInventorySL
implements ITickable {
    public static final int TRY_LIGHT_DELAY = 80;
    public static final int LIGHT_DISTANCE = 8;
    public static final int TE_SEARCH_RADIUS = 7;
    int ticksExisted = 0;
    @SyncVariable(name="flower")
    int flowerId = -1;

    public void func_73660_a() {
        int delay;
        if (this.ticksExisted == 0) {
            ItemStack stack = this.getFlowerItemStack();
            if (!stack.func_190926_b()) {
                this.flowerId = stack.func_77952_i();
            }
            this.ticksExisted += SilentGems.random.nextInt(300);
        }
        int n = delay = this.ticksExisted < 600 ? 10 : 80;
        if (++this.ticksExisted % delay == 0) {
            this.tryPlacePhantomLight();
        }
    }

    private boolean tryPlacePhantomLight() {
        if (this.field_145850_b.field_72995_K || this.getFlowerItemStack().func_190926_b()) {
            return false;
        }
        Random rand = SilentGems.random;
        boolean longRange = rand.nextFloat() < 0.5f;
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        int dist = 8 + (longRange ? 6 : 0);
        int k = longRange ? 8 : 4;
        int angleFactor = rand.nextInt(2 * k);
        Vec3d vec = new Vec3d((double)dist, 0.0, 0.0);
        vec = vec.func_178785_b((float)angleFactor / (float)k * (float)Math.PI);
        x = (int)((long)x + Math.round(vec.field_72450_a));
        z = (int)((long)z + Math.round(vec.field_72449_c));
        BlockPos.MutableBlockPos tryPos = new BlockPos.MutableBlockPos(x, y += 2, z);
        if (SilentGems.proxy.isClientPlayerHoldingDebugItem()) {
            Color debugColor = new Color(0.4f, 0.0f, 1.0f);
            for (int i = 0; i < 100; ++i) {
                SilentGems.proxy.spawnParticles(EnumModParticles.CHAOS, debugColor, this.field_145850_b, (double)x + 0.5, y, (double)z + 0.5, (double)0.005f * rand.nextGaussian(), 0.25 * rand.nextGaussian(), (double)0.005f * rand.nextGaussian());
            }
            float f = 0.0f;
            while ((double)f < Math.PI * 2) {
                Vec3d v = new Vec3d((double)dist, 0.0, 0.0).func_178785_b(f);
                SilentGems.proxy.spawnParticles(EnumModParticles.CHAOS, debugColor, this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 + v.field_72450_a, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5 + v.field_72449_c, 0.0, 0.0, 0.0);
                f = (float)((double)f + 0.09817477042468103);
            }
        }
        if (this.canPlacePhantomLightAt((BlockPos)tryPos)) {
            this.placePhantomLightAt((BlockPos)tryPos);
            return true;
        }
        for (int ty = y + 1; ty > y - 2; --ty) {
            for (int tx = x - 1; tx < x + 2; ++tx) {
                for (int tz = z - 1; tz < z + 2; ++tz) {
                    tryPos.func_181079_c(tx, ty, tz);
                    if (!this.canPlacePhantomLightAt((BlockPos)tryPos)) continue;
                    this.placePhantomLightAt((BlockPos)tryPos);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canPlacePhantomLightAt(BlockPos target) {
        TileEntity te;
        BlockPos pos;
        int i;
        if (!this.field_145850_b.func_175623_d(target) || this.field_145850_b.func_175642_b(EnumSkyBlock.BLOCK, target) > 9) {
            return false;
        }
        Class<?> clazz = null;
        for (i = 0; i < 7 && clazz == null; ++i) {
            pos = target.func_177981_b(i);
            te = this.field_145850_b.func_175625_s(pos);
            if (te != null) {
                clazz = te.getClass();
                continue;
            }
            if (this.field_145850_b.func_175623_d(pos)) continue;
            return true;
        }
        for (i = 0; i < 7; ++i) {
            pos = target.func_177979_c(i);
            te = this.field_145850_b.func_175625_s(pos);
            if (te != null && clazz == te.getClass()) {
                return false;
            }
            if (this.field_145850_b.func_175623_d(pos)) continue;
            return true;
        }
        return true;
    }

    private void placePhantomLightAt(BlockPos target) {
        this.field_145850_b.func_175656_a(target, ModBlocks.phantomLight.func_176223_P());
        TileEntity tile = this.field_145850_b.func_175625_s(target);
        if (tile instanceof TilePhantomLight) {
            TilePhantomLight tileLight = (TilePhantomLight)tile;
            tileLight.setSpawnerPos(this.field_174879_c);
        }
    }

    public int getFlowerId() {
        return this.flowerId;
    }

    @Nonnull
    public ItemStack getFlowerItemStack() {
        return this.func_70301_a(0);
    }

    public void setFlowerItemStack(@Nonnull ItemStack stack) {
        this.func_70299_a(0, stack);
        this.flowerId = stack.func_77952_i();
        this.ticksExisted = 0;
    }

    public int func_70302_i_() {
        return 1;
    }

    public String func_70005_c_() {
        return "ChaosFlowerPot";
    }
}

