/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.energy.IChaosAccepter;
import net.silentchaos512.gems.api.lib.EnumMaterialGrade;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartMain;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.tile.TileSidedInventorySL;
import net.silentchaos512.lib.util.StackHelper;

public class TileMaterialGrader
extends TileSidedInventorySL
implements ITickable,
IChaosAccepter {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT_START = 1;
    public static final int INVENTORY_SIZE = 5;
    private static final int[] SLOTS_INPUT = new int[]{0};
    private static final int[] SLOTS_OUTPUT = IntStream.range(1, 6).toArray();
    private static final int[] SLOTS_ALL = IntStream.range(0, 6).toArray();
    public static final int ANALYZE_SPEED_NO_CHAOS = 1;
    public static final int ANALYZE_SPEED_WITH_CHAOS = 6;
    public static final int BASE_ANALYZE_TIME = 1200;
    public static final int CHAOS_PER_TICK = 25;
    public static final int MAX_CHARGE = 100000;
    @SyncVariable(name="Energy")
    protected int chaosStored = 0;
    @SyncVariable(name="Progress")
    protected int progress = 0;
    protected boolean requireClientSync = false;
    private final IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    private final IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    private final IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    @Override
    public int getCharge() {
        return this.chaosStored;
    }

    @Override
    public int getMaxCharge() {
        return 100000;
    }

    @Override
    public int receiveCharge(int maxReceive, boolean simulate) {
        int amount = Math.min(this.getMaxCharge() - this.getCharge(), maxReceive);
        if (!simulate && amount > 0 && !this.field_145850_b.field_72995_K) {
            this.chaosStored += amount;
            this.requireClientSync = true;
        }
        return amount;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack input = this.func_70301_a(0);
        ToolPart part = ToolPartRegistry.fromStack(input);
        if (part != null && part instanceof ToolPartMain && EnumMaterialGrade.fromStack(input) == EnumMaterialGrade.NONE) {
            boolean useChaos;
            boolean bl = useChaos = this.chaosStored >= 25;
            if (this.progress < 1200) {
                if (useChaos) {
                    this.chaosStored -= 25;
                }
                this.progress += useChaos ? 6 : 1;
                this.requireClientSync = true;
            }
            int outputSlot = this.getFreeOutputSlot();
            if (this.progress >= 1200 && outputSlot > 0) {
                this.progress = 0;
                ItemStack stack = input.func_77946_l();
                stack.func_190920_e(1);
                input.func_190918_g(1);
                EnumMaterialGrade.selectRandom(SilentGems.random).setGradeOnStack(stack);
                this.func_70299_a(outputSlot, stack);
                if (input.func_190916_E() <= 0) {
                    this.func_70299_a(0, ItemStack.field_190927_a);
                }
                this.requireClientSync = true;
            }
        } else {
            this.progress = 0;
        }
        if (this.requireClientSync) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.requireClientSync = false;
        }
    }

    public int getFreeOutputSlot() {
        for (int i = 1; i < 5; ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.chaosStored;
            }
            case 1: {
                return this.progress;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.chaosStored = value;
                break;
            }
            case 1: {
                this.progress = value;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tags = new NBTTagCompound();
        this.writeSyncVars(tags, SyncVariable.Type.PACKET);
        ItemStack input = this.func_70301_a(0);
        if (!input.func_190926_b()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            input.func_77955_b(tagCompound);
            tags.func_74782_a("InputItem", (NBTBase)tagCompound);
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tags);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tags = super.func_189517_E_();
        this.writeSyncVars(tags, SyncVariable.Type.PACKET);
        NBTTagList tagList = new NBTTagList();
        ItemStack input = this.func_70301_a(0);
        if (!input.func_190926_b()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)0);
            input.func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tags.func_74782_a("Items", (NBTBase)tagList);
        return tags;
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound tags = pkt.func_148857_g();
        this.readSyncVars(tags);
        if (tags.func_74764_b("InputItem")) {
            this.func_70299_a(0, StackHelper.loadFromNBT((NBTTagCompound)tags.func_74775_l("InputItem")));
        } else {
            this.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    @Nonnull
    public int[] func_180463_a(EnumFacing side) {
        switch (side) {
            case DOWN: {
                return SLOTS_OUTPUT;
            }
            case UP: {
                return SLOTS_INPUT;
            }
        }
        return SLOTS_ALL;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            if (stack.func_190926_b()) {
                return false;
            }
            if (!this.func_70301_a(index).func_190926_b() && !this.func_70301_a(index).func_77969_a(stack)) {
                return false;
            }
            EnumMaterialGrade grade = EnumMaterialGrade.fromStack(stack);
            if (grade != EnumMaterialGrade.NONE) {
                return false;
            }
            ToolPart part = ToolPartRegistry.fromStack(stack);
            return part instanceof ToolPartMain;
        }
        return false;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0 && this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index != 0;
    }

    public List<String> getDebugLines() {
        ArrayList list = Lists.newArrayList();
        list.add(String.format("Chaos: %,d / %,d", this.getCharge(), this.getMaxCharge()));
        list.add(String.format("progress = %d", this.progress));
        return list;
    }

    public int func_70302_i_() {
        return 5;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

