/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.silentgemstic;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.init.Items;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.silentgemstic.SilentGemsTiC;
import net.silentchaos512.silentgemstic.TConstructMaterialGem;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;

public class TConstructGemsCompat {
    private static final Map<String, Material> materials = new LinkedHashMap<String, Material>();
    private static final Map<String, MaterialIntegration> materialIntegrations = new LinkedHashMap<String, MaterialIntegration>();
    private static final Map<String, CompletionStage<?>> materialIntegrationStages = new LinkedHashMap();

    public static void preInit() {
        SilentGemsTiC.log.info("Loading TConstruct compatibility module...", new Object[0]);
        try {
            for (EnumGem gem : EnumGem.values()) {
                TConstructGemsCompat.register(gem, EnumMaterialTier.REGULAR);
            }
            for (EnumGem gem : EnumGem.values()) {
                TConstructGemsCompat.register(gem, EnumMaterialTier.SUPER);
            }
            TConstructGemsCompat.preIntegrate(materials, materialIntegrations, materialIntegrationStages);
        }
        catch (NoSuchMethodError ex) {
            SilentGemsTiC.log.warn("Failed to load TConstruct module. Are Tinkers tools disabled?", new Object[0]);
            ex.printStackTrace();
        }
        catch (Exception ex) {
            SilentGemsTiC.log.error("Unknown error while loading TConstruct module.", new Object[0]);
            ex.printStackTrace();
        }
    }

    private static void preIntegrate(Map<String, Material> materials, Map<String, MaterialIntegration> materialIntegrations, Map<String, CompletionStage<?>> materialIntegrationStages) {
        materials.forEach((k, v) -> {
            if (!materialIntegrations.containsKey(k)) {
                ((CompletionStage)materialIntegrationStages.getOrDefault(k, CompletableFuture.completedFuture(null))).thenRun(() -> {
                    MaterialIntegration mi = v.getRepresentativeItem().func_77973_b() == Items.field_151166_bC ? new MaterialIntegration(v, v.getFluid()) : (v.getFluid() != null ? new MaterialIntegration(v, v.getFluid(), k).toolforge() : new MaterialIntegration(v));
                    TinkerRegistry.integrate((MaterialIntegration)mi).preInit();
                    materialIntegrations.put((String)k, mi);
                });
            }
        });
    }

    private static void register(EnumGem gem, EnumMaterialTier tier) {
        TConstructMaterialGem material = new TConstructMaterialGem(gem, tier);
        String itemOreName = tier == EnumMaterialTier.SUPER ? gem.getItemSuperOreName() : gem.getItemOreName();
        material.addItem(itemOreName, 1, 144);
        material.setCraftable(true);
        SilentGemsTiC.proxy.setTinkersRenderColor(material, gem.getColor());
        int durability = gem.getDurability(tier);
        float miningSpeed = gem.getMiningSpeed(tier);
        float meleeDamage = gem.getMeleeDamage(tier);
        float meleeSpeed = gem.getMeleeSpeed(tier);
        int harvestLevel = gem.getHarvestLevel(tier);
        float drawDelay = Math.max(38.4f - 1.4f * meleeSpeed * miningSpeed, 10.0f);
        TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new HeadMaterialStats(durability, miningSpeed, meleeDamage, harvestLevel), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.875f, durability / 8), new ExtraMaterialStats(durability / 8), new BowMaterialStats(20.0f / drawDelay, 1.0f, 0.4f * meleeDamage - 1.0f), new ArrowShaftMaterialStats(1.0f, 0)});
        materials.put(material.identifier, material);
    }
}

