/*
 * Decompiled with CFR 0.152.
 */
package it.jdijack.jjmeteor.util;

import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class Utils {
    public static int getWorldMinutes(World world) {
        int time = (int)Math.abs((world.func_72820_D() + 6000L) % 24000L);
        return time % 1000 * 6 / 100;
    }

    public static int getWorldHours(World world) {
        int time = (int)Math.abs((world.func_72820_D() + 6000L) % 24000L);
        return (int)((float)time / 1000.0f);
    }

    public static void drawMeteor(int r, BlockPos pos, World world, IBlockState state) {
        if (world != null) {
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            for (int x = -r; x < r; ++x) {
                for (int z = -r; z < r; ++z) {
                    BlockPos superficie = world.func_175672_r(new BlockPos(i + x, 0, k + z));
                    double dist = MathHelper.func_76129_c((float)(x * x + z * z));
                    if (dist > (double)r || world.func_180495_p(superficie.func_177977_b()).func_177230_c() instanceof BlockLog) continue;
                    world.func_175656_a(superficie, state);
                }
            }
        }
    }

    public static void drawSpherePiena(int r, BlockPos pos, World world, IBlockState state) {
        if (world != null) {
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            for (int x = -r; x < r; ++x) {
                for (int y = -r; y < r; ++y) {
                    for (int z = -r; z < r; ++z) {
                        double dist = MathHelper.func_76129_c((float)(x * x + y * y + z * z));
                        if (dist > (double)r) continue;
                        world.func_175656_a(new BlockPos(i + x, j + y, k + z), state);
                    }
                }
            }
        }
    }

    public static void drawSphereCava(int rad, BlockPos pos, World world, IBlockState state) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        j += rad;
        if (rad > 0) {
            for (int x = -rad - 1; x < rad + 1; ++x) {
                for (int y = -rad - 1; y < rad + 1; ++y) {
                    for (int z = -rad - 1; z < rad + 1; ++z) {
                        if (Utils.calcDistance(i, j, k, i + x, j + y, k + z) == rad) {
                            world.func_175656_a(new BlockPos(i + x, j + y, k + z), state);
                            continue;
                        }
                        world.func_175656_a(new BlockPos(i + x, j + y, k + z), Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
    }

    private static int calcDistance(int orgx, int orgy, int orgz, int posx, int posy, int posz) {
        int xoff = Math.abs(orgx - posx);
        int yoff = Math.abs(orgy - posy);
        int zoff = Math.abs(orgz - posz);
        return (int)Math.round(Math.sqrt(xoff * xoff + zoff * zoff + yoff * yoff));
    }
}

