/*
 * Decompiled with CFR 0.152.
 */
package erebus.core.helper;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class Spiral {
    private final int width;
    private final int length;
    private Point point;
    private Direction direction = Direction.E;
    private final List<Point> list = new ArrayList<Point>();

    public Spiral(int width, int length) {
        this.width = width;
        this.length = length;
    }

    public List<Point> spiral() {
        this.point = new Point(0, 0);
        int steps = 1;
        while (this.list.size() < this.width * this.length) {
            this.advance(steps);
            this.advance(steps);
            ++steps;
        }
        return this.list;
    }

    private void advance(int step) {
        for (int i = 0; i < step; ++i) {
            if (this.inBounds(this.point)) {
                this.list.add(this.point);
            }
            this.point = this.direction.advance(this.point);
        }
        this.direction = Direction.next(this.direction);
    }

    private boolean inBounds(Point p) {
        return this.between(-this.width / 2, this.width / 2, p.x) && this.between(-this.length / 2, this.length / 2, p.y);
    }

    private boolean between(int min, int max, int value) {
        return min <= value && value <= max;
    }

    private static enum Direction {
        E(1, 0),
        N(0, 1),
        W(-1, 0),
        S(0, -1);

        private final int dx;
        private final int dy;

        private Direction(int dx, int dy) {
            this.dx = dx;
            this.dy = dy;
        }

        Point advance(Point point) {
            return new Point(point.x + this.dx, point.y + this.dy);
        }

        public static Direction next(Direction dir) {
            int ordinal = dir.ordinal() + 1;
            if (ordinal >= Direction.values().length) {
                ordinal = 0;
            }
            return Direction.values()[ordinal];
        }
    }
}

