/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.biomes.decorators;

import erebus.ModBlocks;
import erebus.blocks.BlockDarkFruitVine;
import erebus.blocks.BlockDoubleHeightPlant;
import erebus.blocks.BlockSmallPlant;
import erebus.world.biomes.decorators.BiomeDecoratorBaseErebus;
import erebus.world.biomes.decorators.data.FeatureType;
import erebus.world.biomes.decorators.data.OreSettings;
import erebus.world.biomes.decorators.data.SurfaceType;
import erebus.world.feature.decoration.WorldGenPonds;
import erebus.world.feature.plant.WorldGenGiantFlowers;
import erebus.world.feature.plant.WorldGenMossPatch;
import erebus.world.feature.plant.WorldGenNettlePatch;
import erebus.world.feature.tree.WorldGenCypressTree;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BiomeDecoratorElysianFields
extends BiomeDecoratorBaseErebus {
    protected final WorldGenPonds genPonds = new WorldGenPonds();
    protected final WorldGenerator genTreeCypress = new WorldGenCypressTree();
    protected final WorldGenerator genGiantFlowers = new WorldGenGiantFlowers();
    protected final WorldGenerator genMossPatch = new WorldGenMossPatch(0);
    protected final WorldGenNettlePatch genNettle = new WorldGenNettlePatch();
    protected boolean generateFlowers = true;

    @Override
    protected void populate() {
        if (this.rand.nextInt(3) == 0) {
            this.attempt = 0;
            while (this.attempt < 25) {
                this.xx = this.x + 16;
                this.yy = 20 + this.rand.nextInt(90);
                this.zz = this.z + 16;
                BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
                if (this.checkSurface(SurfaceType.GRASS, pos)) {
                    this.genPonds.prepare((this.rand.nextDouble() + 0.7) * 1.5);
                    this.genPonds.func_180709_b(this.world, this.rand, pos.func_177984_a());
                    if (this.rand.nextBoolean()) break;
                }
                ++this.attempt;
            }
        }
    }

    @Override
    protected void decorate() {
        BlockPos pos;
        this.attempt = 0;
        while (this.attempt < 105) {
            this.xx = this.x + this.offsetXZ();
            this.zz = this.z + this.offsetXZ();
            this.yy = 20 + this.rand.nextInt(80);
            pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos)) {
                this.genTreeCypress.func_180709_b(this.world, this.rand, pos.func_177984_a());
                break;
            }
            ++this.attempt;
        }
        if (this.generateFlowers && this.rand.nextBoolean()) {
            for (int attempt = 0; attempt < 65; ++attempt) {
                int zz;
                int yy;
                int xx = this.x + this.offsetXZ();
                BlockPos pos2 = new BlockPos(xx, yy = 15 + this.rand.nextInt(90), zz = this.z + this.offsetXZ());
                if (!this.checkSurface(SurfaceType.GRASS, pos2)) continue;
                this.genGiantFlowers.func_180709_b(this.world, this.rand, pos2.func_177984_a());
                break;
            }
        }
        this.attempt = 0;
        while (this.attempt < this.rand.nextInt(4)) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 25 + this.rand.nextInt(75);
            this.zz = this.z + this.offsetXZ();
            pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos)) {
                this.genNettle.func_180709_b(this.world, this.rand, pos.func_177984_a());
                break;
            }
            ++this.attempt;
        }
        IBlockState tallGrassState = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS);
        this.attempt = 0;
        while (this.attempt < 70) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 20 + this.rand.nextInt(80);
            this.zz = this.z + this.offsetXZ();
            int n = this.yy = this.rand.nextInt(3) == 0 ? 40 + this.rand.nextInt(35) : 22;
            while (this.yy < 100) {
                BlockPos pos3 = new BlockPos(this.xx, this.yy, this.zz);
                if (this.checkSurface(SurfaceType.GRASS, pos3)) {
                    if (this.rand.nextInt(10) == 0 && this.world.func_175623_d(pos3.func_177981_b(2))) {
                        Blocks.field_150398_cm.func_176491_a(this.world, pos3.func_177984_a(), BlockDoublePlant.EnumPlantType.GRASS, 2);
                        break;
                    }
                    if (!this.world.func_175623_d(pos3.func_177984_a())) break;
                    this.world.func_175656_a(pos3.func_177984_a(), tallGrassState);
                    break;
                }
                this.yy += this.rand.nextBoolean() ? 2 : 1;
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 10) {
            this.xx = this.x + this.offsetXZ();
            this.zz = this.z + this.offsetXZ();
            this.yy = 20;
            while (this.yy < 100) {
                BlockPos pos4 = new BlockPos(this.xx, this.yy, this.zz);
                if (this.checkSurface(SurfaceType.GRASS, pos4)) {
                    if (this.rand.nextInt(10) == 0 && this.world.func_175623_d(pos4.func_177981_b(2))) {
                        ModBlocks.DOUBLE_PLANT.placeAt(this.world, pos4.func_177984_a(), BlockDoubleHeightPlant.EnumPlantType.TALL_FERN, 2);
                        break;
                    }
                    if (!this.world.func_175623_d(pos4.func_177984_a())) break;
                    this.world.func_180501_a(pos4.func_177984_a(), ModBlocks.SMALL_PLANT.func_176223_P().func_177226_a(BlockSmallPlant.PLANT_TYPE, (Comparable)((Object)BlockSmallPlant.EnumSmallPlantType.FERN)), 2);
                    break;
                }
                this.yy += this.rand.nextBoolean() ? 2 : 1;
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 5) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 20 + this.rand.nextInt(80);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos5 = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos5) && this.world.func_175623_d(pos5.func_177984_a()) && this.world.func_175623_d(pos5.func_177981_b(2))) {
                ModBlocks.DOUBLE_PLANT.placeAt(this.world, pos5.func_177984_a(), BlockDoubleHeightPlant.EnumPlantType.WEEPING_BLUEBELL, 2);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 10) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 30 + this.rand.nextInt(90);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos6 = new BlockPos(this.xx, this.yy, this.zz);
            if (this.world.func_180495_p(pos6).func_185915_l()) {
                for (int hangerY = this.rand.nextInt(20); hangerY > 0; --hangerY) {
                    if (!this.world.func_175623_d(pos6.func_177979_c(hangerY))) continue;
                    this.world.func_180501_a(pos6.func_177979_c(hangerY), ModBlocks.DARK_FRUIT_VINE.func_176223_P().func_177226_a((IProperty)BlockDarkFruitVine.DARK_VINE_AGE, (Comparable)Integer.valueOf(4)), 2);
                }
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 15) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 30 + this.rand.nextInt(80);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos7 = new BlockPos(this.xx, this.yy, this.zz);
            if (this.world.func_175623_d(pos7)) {
                this.genMossPatch.func_180709_b(this.world, this.rand, pos7);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 15) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 20 + this.rand.nextInt(80);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos8 = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos8) && this.world.func_175623_d(pos8.func_177984_a()) && this.world.func_175623_d(pos8.func_177981_b(2))) {
                ModBlocks.DOUBLE_PLANT.placeAt(this.world, pos8.func_177984_a(), BlockDoubleHeightPlant.EnumPlantType.TALL_BLOOM, 2);
            }
            ++this.attempt;
        }
    }

    @Override
    protected void modifyOreGen(OreSettings oreGen, OreSettings.OreType oreType, boolean extraOres) {
        switch (oreType) {
            case COAL: {
                oreGen.setIterations(extraOres ? 2 : 3, extraOres ? 3 : 4).setY(5, 48);
                break;
            }
            case IRON: {
                oreGen.setChance(0.75f).setIterations(extraOres ? 2 : 3, extraOres ? 4 : 5).setY(5, 42);
                break;
            }
            case GOLD: {
                oreGen.setIterations(extraOres ? 2 : 3);
                break;
            }
            case EMERALD: {
                oreGen.setIterations(2, 4).setCheckArea(2);
                break;
            }
            case JADE: {
                oreGen.setIterations(2, 5);
                break;
            }
            case PETRIFIED_WOOD: {
                oreGen.setChance(0.0f);
                break;
            }
            case FOSSIL: {
                oreGen.setChance(0.25f).setOreAmount(5, 8);
            }
        }
    }

    @Override
    public void generateFeature(FeatureType featureType) {
        if (featureType == FeatureType.RED_GEM) {
            this.attempt = 0;
            while (this.attempt < 2 + this.rand.nextInt(2)) {
                genRedGem.func_180709_b(this.world, this.rand, new BlockPos(this.x + this.offsetXZ(), 64 + this.rand.nextInt(60), this.z + this.offsetXZ()));
                ++this.attempt;
            }
        } else {
            super.generateFeature(featureType);
        }
    }

    public static class BiomeDecoratorElysianForest
    extends BiomeDecoratorElysianFields {
        private static final IBlockState OAK_TRUNK = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK);
        private static final IBlockState OAK_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        private static final IBlockState BIRCH_TRUNK = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH);
        private static final IBlockState BIRCH_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.BIRCH).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        private final WorldGenerator genOakTree = new WorldGenTrees(false, 5, OAK_TRUNK, OAK_LEAF, false);
        private final WorldGenerator genBirchTree = new WorldGenTrees(false, 5, BIRCH_TRUNK, BIRCH_LEAF, false);

        public BiomeDecoratorElysianForest() {
            this.generateFlowers = false;
        }

        @Override
        protected void populate() {
            if (this.rand.nextInt(4) == 0) {
                this.attempt = 0;
                while (this.attempt < 45) {
                    this.xx = this.x + 16;
                    this.yy = 20 + this.rand.nextInt(90);
                    this.zz = this.z + 16;
                    BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
                    if (this.checkSurface(SurfaceType.GRASS, pos)) {
                        this.genPonds.prepare((this.rand.nextDouble() + 0.7) * 1.5);
                        this.genPonds.func_180709_b(this.world, this.rand, pos.func_177984_a());
                        if (this.rand.nextBoolean()) break;
                    }
                    ++this.attempt;
                }
            }
            super.populate();
        }

        @Override
        public void decorate() {
            BlockPos pos;
            this.attempt = 0;
            while (this.attempt < 400) {
                this.xx = this.x + this.offsetXZ();
                this.zz = this.z + this.offsetXZ();
                this.yy = 20 + this.rand.nextInt(80);
                pos = new BlockPos(this.xx, this.yy, this.zz);
                if (this.checkSurface(SurfaceType.GRASS, pos)) {
                    if (this.rand.nextBoolean()) {
                        this.genOakTree.func_180709_b(this.world, this.rand, pos.func_177984_a());
                    } else {
                        this.genBirchTree.func_180709_b(this.world, this.rand, pos.func_177984_a());
                    }
                }
                ++this.attempt;
            }
            this.attempt = 0;
            while (this.attempt < 300) {
                this.xx = this.x + this.offsetXZ();
                this.zz = this.z + this.offsetXZ();
                this.yy = 20 + this.rand.nextInt(80);
                pos = new BlockPos(this.xx, this.yy, this.zz);
                if (this.checkSurface(SurfaceType.GRASS, pos.func_177984_a())) {
                    this.genTreeCypress.func_180709_b(this.world, this.rand, pos.func_177984_a());
                }
                ++this.attempt;
            }
            super.decorate();
        }
    }
}

