/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.tree;

import erebus.blocks.EnumWood;
import erebus.world.feature.tree.WorldGenTreeBase;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenBalsamTree
extends WorldGenTreeBase {
    public WorldGenBalsamTree() {
        super(EnumWood.BALSAM);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int height = rand.nextInt(4) + 12;
        int maxRadius = 5;
        boolean alternate = rand.nextBoolean();
        for (int xx = x - maxRadius; xx <= x + maxRadius; ++xx) {
            for (int zz = z - maxRadius; zz <= z + maxRadius; ++zz) {
                for (int yy = y + 2; yy < y + height; ++yy) {
                    if (world.func_175623_d(new BlockPos(xx, yy, zz))) continue;
                    return false;
                }
            }
        }
        for (int yy = y; yy < y + height; ++yy) {
            if (yy < y + height - 1) {
                world.func_180501_a(new BlockPos(x, yy, z), this.log.func_176203_a(0), 2);
            }
            if (yy == y + height - 1) {
                this.createLeaves(world, x, yy, z);
                this.placeLeaves(world, x, yy + 1, z);
            }
            if (yy == y + height - 7 || yy == y + height - 10) {
                if (alternate) {
                    this.createBranch(world, rand, x + 1, yy - rand.nextInt(2), z, 1, 1);
                    this.createBranch(world, rand, x - 1, yy - rand.nextInt(2), z, 2, 1);
                    alternate = false;
                } else {
                    this.createBranch(world, rand, x, yy - rand.nextInt(2), z + 1, 3, 1);
                    this.createBranch(world, rand, x, yy - rand.nextInt(2), z - 1, 4, 1);
                    alternate = true;
                }
            }
            if (yy != y + height - 4) continue;
            if (alternate) {
                this.createBranch(world, rand, x + 1, yy - rand.nextInt(2), z, 1, 1);
                this.createBranch(world, rand, x - 1, yy - rand.nextInt(2), z, 2, 1);
                alternate = false;
                continue;
            }
            this.createBranch(world, rand, x, yy - rand.nextInt(2), z + 1, 3, 1);
            this.createBranch(world, rand, x, yy - rand.nextInt(2), z - 1, 4, 1);
            alternate = true;
        }
        return true;
    }

    private void createBranch(World world, Random rand, int x, int y, int z, int dir, int branchLength) {
        int meta = dir;
        for (int i = 0; i <= branchLength; ++i) {
            if (i >= 1) {
                ++y;
                meta = 0;
            }
            if (dir == 1) {
                world.func_180501_a(new BlockPos(x + i, y, z), this.log.func_176203_a(meta == 0 ? 0 : 4), 2);
                if (i == branchLength) {
                    this.createLeaves(world, x + i, y, z);
                    this.placeLeaves(world, x + i + 2, y, z);
                }
            }
            if (dir == 2) {
                world.func_180501_a(new BlockPos(x - i, y, z), this.log.func_176203_a(meta == 0 ? 0 : 4), 2);
                if (i == branchLength) {
                    this.createLeaves(world, x - i, y, z);
                    this.placeLeaves(world, x - i - 2, y, z);
                }
            }
            if (dir == 3) {
                world.func_180501_a(new BlockPos(x, y, z + i), this.log.func_176203_a(meta == 0 ? 0 : 8), 2);
                if (i == branchLength) {
                    this.createLeaves(world, x, y, z + i);
                    this.placeLeaves(world, x, y, z + i + 2);
                }
            }
            if (dir != 4) continue;
            world.func_180501_a(new BlockPos(x, y, z - i), this.log.func_176203_a(meta == 0 ? 0 : 8), 2);
            if (i != branchLength) continue;
            this.createLeaves(world, x, y, z - i);
            this.placeLeaves(world, x, y, z - i - 2);
        }
    }

    private void createLeaves(World world, int x, int y, int z) {
        for (int d = -1; d < 2; ++d) {
            for (int d2 = -1; d2 < 2; ++d2) {
                this.placeLeaves(world, x + d, y, z + d2);
            }
        }
    }

    private void placeLeaves(World world, int x, int y, int z) {
        if (world.func_175623_d(new BlockPos(x, y, z))) {
            world.func_180501_a(new BlockPos(x, y, z), this.leaves, 2);
        }
    }
}

