/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.gui.client.GuiEnderInfuser;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.inventory.container.ContainerEnderInfuser;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperSelective;
import fi.dy.masa.enderutilities.item.base.IChargeable;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.IItemHandler;

public class TileEntityEnderInfuser
extends TileEntityEnderUtilitiesInventory
implements ITickable {
    private static final int SLOT_MATERIAL = 0;
    private static final int SLOT_CAP_IN = 1;
    private static final int SLOT_CAP_OUT = 2;
    public static final int AMOUNT_PER_ENDERPEARL = 250;
    public static final int AMOUNT_PER_ENDEREYE = 500;
    public static final int ENDER_CHARGE_PER_MILLIBUCKET = 4;
    public static final int MAX_AMOUNT = 4000;
    public int amountStored;
    public int meltingProgress;
    public boolean isCharging;
    public int chargeableItemCapacity;
    public int chargeableItemStartingCharge;
    public int chargeableItemCurrentCharge;

    public TileEntityEnderInfuser() {
        super("ender_infuser");
        this.itemHandlerBase = new ItemStackHandlerTileEntity(3, this);
        this.itemHandlerExternal = new ItemHandlerWrapperEnderInfuser(this.getBaseItemHandler());
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        if (nbt.func_150297_b("Fluid", 10)) {
            this.amountStored = nbt.func_74775_l("Fluid").func_74762_e("Amount");
        }
        this.meltingProgress = nbt.func_74771_c("Progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Amount", this.amountStored);
        tag.func_74778_a("FluidName", "ender");
        nbt.func_74782_a("Fluid", (NBTBase)tag);
        nbt.func_74774_a("Progress", (byte)this.meltingProgress);
        return nbt;
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        boolean dirty = false;
        if (!this.getBaseItemHandler().getStackInSlot(0).func_190926_b()) {
            Item item = this.getBaseItemHandler().getStackInSlot(0).func_77973_b();
            int amount = 0;
            if (item == Items.field_151079_bi) {
                amount = 250;
            } else if (item == Items.field_151061_bv) {
                amount = 500;
            }
            if (amount > 0 && amount + this.amountStored <= 4000) {
                this.meltingProgress += 2;
                if (this.meltingProgress >= 100) {
                    this.amountStored += amount;
                    this.meltingProgress = 0;
                    this.getBaseItemHandler().extractItem(0, 1, false);
                }
                dirty = true;
            }
        } else {
            this.meltingProgress = 0;
        }
        ItemStack inputStack = this.getBaseItemHandler().getStackInSlot(1);
        if (!inputStack.func_190926_b()) {
            ItemStack chargeableStack = inputStack;
            Item item = inputStack.func_77973_b();
            if (item instanceof IChargeable || item instanceof IModular) {
                int charge;
                int filled;
                boolean isModular = false;
                IChargeable iChargeable = null;
                if (item instanceof IChargeable) {
                    iChargeable = (IChargeable)item;
                } else {
                    chargeableStack = UtilItemModular.getSelectedModuleStack(inputStack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR);
                    if (!chargeableStack.func_190926_b() && chargeableStack.func_77973_b() instanceof IChargeable) {
                        iChargeable = (IChargeable)chargeableStack.func_77973_b();
                        isModular = true;
                    }
                }
                if (iChargeable != null && this.amountStored > 0 && (filled = iChargeable.addCharge(chargeableStack, charge = (this.amountStored >= 10 ? 10 : this.amountStored) * 4, false)) > 0) {
                    if (!this.isCharging) {
                        this.chargeableItemCapacity = iChargeable.getCapacity(chargeableStack);
                        this.chargeableItemCurrentCharge = this.chargeableItemStartingCharge = iChargeable.getCharge(chargeableStack);
                        this.isCharging = true;
                    }
                    if (filled < charge) {
                        charge = filled;
                    }
                    charge = iChargeable.addCharge(chargeableStack, charge, true);
                    int used = (int)Math.ceil(charge / 4);
                    this.amountStored -= used;
                    this.chargeableItemCurrentCharge += charge;
                    dirty = true;
                    if (isModular) {
                        UtilItemModular.setSelectedModuleStack(inputStack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR, chargeableStack);
                    }
                }
                if (iChargeable != null && iChargeable.getCharge(chargeableStack) >= iChargeable.getCapacity(chargeableStack)) {
                    this.isCharging = false;
                    this.chargeableItemCurrentCharge = 0;
                    this.chargeableItemStartingCharge = 0;
                    this.chargeableItemCapacity = 0;
                    if (this.getBaseItemHandler().insertItem(2, this.getBaseItemHandler().extractItem(1, 1, true), true).func_190926_b()) {
                        this.getBaseItemHandler().insertItem(2, this.getBaseItemHandler().extractItem(1, 1, false), false);
                        dirty = true;
                    }
                }
            }
        } else {
            this.isCharging = false;
            this.chargeableItemCurrentCharge = 0;
            this.chargeableItemStartingCharge = 0;
            this.chargeableItemCapacity = 0;
        }
        if (dirty) {
            this.func_70296_d();
        }
    }

    @Override
    public ContainerEnderInfuser getContainer(EntityPlayer player) {
        return new ContainerEnderInfuser(player, this);
    }

    @Override
    public Object getGui(EntityPlayer player) {
        return new GuiEnderInfuser(this.getContainer(player), this);
    }

    private class ItemHandlerWrapperEnderInfuser
    extends ItemHandlerWrapperSelective {
        public ItemHandlerWrapperEnderInfuser(IItemHandler baseHandler) {
            super(baseHandler);
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            if (slot == 1) {
                Item item = stack.func_77973_b();
                return item instanceof IChargeable || item instanceof IModular && ((IModular)item).getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR) > 0;
            }
            return slot == 0 && (stack.func_77973_b() == Items.field_151079_bi || stack.func_77973_b() == Items.field_151061_bv);
        }

        @Override
        public boolean canExtractFromSlot(int slot) {
            return slot == 2;
        }
    }
}

