/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.event.ArmSwingSpeedEvent;
import thebetweenlands.client.handler.ArrowPredictionRenderer;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;

public class ElixirClientHandler {
    public static final ElixirClientHandler INSTANCE = new ElixirClientHandler();
    private Map<Entity, EntityTrail> entityTrails = new HashMap<Entity, EntityTrail>();
    private Vec3d playerPos;
    private final Comparator<TrailPos> dstSorter = new Comparator<TrailPos>(){

        @Override
        public int compare(TrailPos v1, TrailPos v2) {
            double d2;
            double d1 = v1.pos.func_72438_d(ElixirClientHandler.this.playerPos);
            if (d1 < (d2 = v2.pos.func_72438_d(ElixirClientHandler.this.playerPos))) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    };

    public EntityTrail getTrail(Entity entity) {
        EntityTrail trail = this.entityTrails.get(entity);
        if (trail == null) {
            trail = new EntityTrail(entity);
            this.entityTrails.put(entity, trail);
        }
        return trail;
    }

    @SubscribeEvent
    public void onArmSwingSpeed(ArmSwingSpeedEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (ElixirEffectRegistry.EFFECT_SLUGARM.isActive(living)) {
            int strength = ElixirEffectRegistry.EFFECT_SLUGARM.getStrength(living);
            event.setSpeed(event.getSpeed() / (float)(2 << strength));
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (event.phase == TickEvent.Phase.END) {
            if (player != null && player.field_70170_p != null && player.field_70170_p.field_72995_K && player == Minecraft.func_71410_x().field_71439_g) {
                if (ElixirEffectRegistry.EFFECT_HUNTERSSENSE.isActive((EntityLivingBase)player)) {
                    Map.Entry<Entity, EntityTrail> entry;
                    Vec3d pos;
                    int strength = ElixirEffectRegistry.EFFECT_HUNTERSSENSE.getStrength((EntityLivingBase)player);
                    World world = player.field_70170_p;
                    List entityList = world.func_72872_a(Entity.class, player.func_174813_aQ().func_72314_b(50.0, 50.0, 50.0));
                    ArrayList<TrailPos> availablePositions = new ArrayList<TrailPos>();
                    for (Entity e : entityList) {
                        if (e == player) continue;
                        EntityTrail trail = this.getTrail(e);
                        trail.update(strength);
                        TrailPos lastPos = null;
                        for (int i = 0; i < trail.cachedPositions.size(); ++i) {
                            pos = (Vec3d)trail.cachedPositions.get(i);
                            if (lastPos != null) {
                                lastPos.nextPos = pos;
                            }
                            TrailPos tp = new TrailPos(pos, i, e);
                            availablePositions.add(tp);
                            lastPos = tp;
                        }
                    }
                    this.playerPos = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    availablePositions.sort(this.dstSorter);
                    int maxPointCount = 200;
                    int pointCount = Math.min(maxPointCount, availablePositions.size());
                    int crawlTicks = MathHelper.func_76141_d((float)(140.0f - 30.0f * (float)strength));
                    for (int i = 0; i < pointCount; ++i) {
                        TrailPos tp = (TrailPos)availablePositions.get(i);
                        if ((player.field_70173_aa - MathHelper.func_76141_d((float)((float)crawlTicks / 80.0f * (float)tp.index))) % crawlTicks != 0) continue;
                        pos = tp.pos;
                        if (tp.nextPos != null) {
                            int subSegments = 10;
                            Vec3d nextPos = tp.nextPos;
                            for (int s = 0; s <= subSegments; ++s) {
                                if ((player.field_70173_aa - MathHelper.func_76141_d((float)((float)crawlTicks / 80.0f * ((float)tp.index + (float)s / (float)subSegments)))) % crawlTicks != 0) continue;
                                double tpx = pos.field_72450_a + 0.5;
                                double tpy = pos.field_72448_b + (double)0.05f;
                                double tpz = pos.field_72449_c + 0.5;
                                double tpx2 = nextPos.field_72450_a + 0.5;
                                double tpy2 = nextPos.field_72448_b;
                                double tpz2 = nextPos.field_72449_c + 0.5;
                                double tpxi = tpx + (tpx2 - tpx) / (double)subSegments * (double)s;
                                double tpyi = tpy + (tpy2 - tpy) / (double)subSegments * (double)s;
                                double tpzi = tpz + (tpz2 - tpz) / (double)subSegments * (double)s;
                                BLParticles.PORTAL.spawn(world, tpxi, tpyi, tpzi, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withScale(0.3f));
                            }
                            continue;
                        }
                        double tpx = pos.field_72450_a + 0.5;
                        double tpy = pos.field_72448_b + (double)0.05f;
                        double tpz = pos.field_72449_c + 0.5;
                        BLParticles.PORTAL.spawn(world, tpx, tpy, tpz, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withScale(0.3f));
                    }
                    Iterator<Map.Entry<Entity, EntityTrail>> it = this.entityTrails.entrySet().iterator();
                    while (it.hasNext() && (entry = it.next()) != null) {
                        EntityTrail trail = entry.getValue();
                        if (trail.entity != null && !((EntityTrail)trail).entity.field_70128_L && entityList.contains(entry.getKey())) continue;
                        it.remove();
                    }
                } else {
                    this.entityTrails.clear();
                }
                if (ElixirEffectRegistry.EFFECT_SWIFTARM.isActive((EntityLivingBase)player) && Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d() && !player.func_184585_cz()) {
                    try {
                        RayTraceResult target = Minecraft.func_71410_x().field_71476_x;
                        if (target == null || target.field_72308_g != null || target.field_72313_a == RayTraceResult.Type.MISS) {
                            Minecraft.func_71410_x().func_147116_af();
                        } else if (target != null && !player.field_82175_bq) {
                            Minecraft.func_71410_x().func_147115_a(true);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                this.entityTrails.clear();
            }
            if (player != null) {
                this.updatePlayerRootboundTicks((EntityLivingBase)player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFogColors(EntityViewRenderEvent.FogColors event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            NBTTagCompound nbt = player.getEntityData();
            if (ElixirEffectRegistry.EFFECT_BASILISK.isActive((EntityLivingBase)player) || ElixirEffectRegistry.EFFECT_PETRIFY.isActive((EntityLivingBase)player)) {
                player.field_70127_C = player.field_70125_A = nbt.func_74760_g("thebetweenlands.petrify.pitch");
                player.field_70126_B = player.field_70177_z = nbt.func_74760_g("thebetweenlands.petrify.yaw");
                player.field_70758_at = player.field_70759_as = nbt.func_74760_g("thebetweenlands.petrify.yawHead");
            }
        }
    }

    @SubscribeEvent
    public void onShootArrow(ArrowLooseEvent event) {
        if (event.getEntityPlayer() == Minecraft.func_71410_x().field_71439_g) {
            ArrowPredictionRenderer.setRandomYawPitch();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderWorld(RenderWorldLastEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_70170_p != null && ElixirEffectRegistry.EFFECT_SAGITTARIUS.isActive((EntityLivingBase)player)) {
            ArrowPredictionRenderer.render(Math.min((float)(ElixirEffectRegistry.EFFECT_SAGITTARIUS.getStrength((EntityLivingBase)player) + 1) / 3.0f, 1.0f));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updatePlayerRootboundTicks(EntityLivingBase entity) {
        NBTTagCompound nbt = entity.getEntityData();
        if (entity.func_70660_b(ElixirEffectRegistry.ROOT_BOUND) != null || ElixirEffectRegistry.EFFECT_BASILISK.isActive(entity) || ElixirEffectRegistry.EFFECT_PETRIFY.isActive(entity)) {
            nbt.func_74768_a("thebetweenlands.stuckTicks", 5);
        } else {
            int rootBoundTicks = nbt.func_74762_e("thebetweenlands.stuckTicks");
            if (rootBoundTicks > 1) {
                nbt.func_74768_a("thebetweenlands.stuckTicks", rootBoundTicks - 1);
            } else {
                nbt.func_82580_o("thebetweenlands.stuckTicks");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFovUpdate(FOVUpdateEvent event) {
        EntityPlayer entity = event.getEntity();
        NBTTagCompound nbt = entity.getEntityData();
        if (entity.func_70660_b(ElixirEffectRegistry.ROOT_BOUND) != null || ElixirEffectRegistry.EFFECT_BASILISK.isActive((EntityLivingBase)entity) || ElixirEffectRegistry.EFFECT_PETRIFY.isActive((EntityLivingBase)entity) || nbt.func_74764_b("thebetweenlands.stuckTicks")) {
            event.setNewfov(1.0f);
        }
    }

    private static class TrailPos {
        private final Vec3d pos;
        private Vec3d nextPos;
        private final Entity entity;
        private final int index;

        private TrailPos(Vec3d pos, int index, Entity entity) {
            this.pos = pos;
            this.index = index;
            this.entity = entity;
        }
    }

    private static class EntityTrail {
        private static final int MAX_CACHE_SIZE = 80;
        private Entity entity;
        private List<Vec3d> cachedPositions = new ArrayList<Vec3d>();

        private EntityTrail(Entity entity) {
            this.entity = entity;
        }

        private void update(int strength) {
            if (this.entity != null && !this.entity.field_70128_L) {
                Vec3d newPos = new Vec3d(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
                if (this.cachedPositions.size() > 0) {
                    Vec3d lastPos = this.cachedPositions.get(this.cachedPositions.size() - 1);
                    if (lastPos.func_72438_d(newPos) > 0.5) {
                        this.cachedPositions.add(newPos);
                    }
                    if (this.cachedPositions.size() > 80 + 20 * (strength + 1)) {
                        this.cachedPositions.remove(0);
                    }
                } else {
                    this.cachedPositions.add(newPos);
                }
            }
        }
    }
}

