/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.entity.IMultipartDummyRendererDelegate;
import thebetweenlands.client.render.entity.layer.LayerOverlay;
import thebetweenlands.client.render.model.entity.ModelDecayPitPlug;
import thebetweenlands.client.render.model.entity.ModelDecayPitTarget;
import thebetweenlands.client.render.model.entity.ModelDecayPitTargetShield;
import thebetweenlands.client.render.particle.entity.ParticleBeam;
import thebetweenlands.common.entity.EntityDecayPitTarget;
import thebetweenlands.common.entity.EntityDecayPitTargetPart;
import thebetweenlands.common.entity.mobs.EntityMultipartDummy;
import thebetweenlands.util.LightingUtil;
import thebetweenlands.util.RenderUtils;

@SideOnly(value=Side.CLIENT)
public class RenderDecayPitTarget
extends Render<EntityDecayPitTarget>
implements IMultipartDummyRendererDelegate<EntityDecayPitTarget> {
    private static final ResourceLocation BEAM_TEXTURE = new ResourceLocation("thebetweenlands:textures/particle/chain_beam.png");
    public static final ResourceLocation PLUG_TEXTURE = new ResourceLocation("thebetweenlands", "textures/entity/decay_pit_plug.png");
    public static final ResourceLocation PLUG_TEXTURE_GLOW = new ResourceLocation("thebetweenlands", "textures/entity/decay_pit_plug_glow.png");
    private static final ModelDecayPitPlug PLUG_MODEL = new ModelDecayPitPlug();
    public static final ResourceLocation SHIELD_TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_target_shield.png");
    private static final ModelDecayPitTargetShield SHIELD_MODEL = new ModelDecayPitTargetShield();
    public static final ResourceLocation TARGET_TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_target.png");
    public static final ResourceLocation TARGET_TEXTURE_GLOW = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_target_glow.png");
    private static final ModelDecayPitTarget TARGET_MODEL = new ModelDecayPitTarget();

    public RenderDecayPitTarget(RenderManager manager) {
        super(manager);
    }

    public void doRender(EntityDecayPitTarget entity, double x, double y, double z, float entityYaw, float partialTicks) {
        int frameCounter = RenderUtils.getFrameCounter();
        if (entity.renderedFrame != frameCounter) {
            entity.renderedFrame = frameCounter;
            this.renderBeams(entity, x, y, z, entityYaw, partialTicks, true);
            double smoothedMainX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
            double smoothedMainY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks;
            double smoothedMainZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)(y + 1.5), (double)z);
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            this.func_110776_a(PLUG_TEXTURE);
            PLUG_MODEL.render(0.0625f);
            this.renderPlugGlowLayer(entity, 0.0625f);
            GlStateManager.func_179121_F();
            EntityDecayPitTargetPart hitPart = null;
            if (this.func_177068_d().func_178634_b()) {
                hitPart = entity.rayTraceShields(Minecraft.func_71410_x().field_71439_g.func_174824_e(partialTicks), Minecraft.func_71410_x().field_71439_g.func_70676_i(partialTicks));
            }
            for (EntityDecayPitTargetPart part : entity.parts) {
                float floatate = part.field_70126_B + (part.field_70177_z - part.field_70126_B) * partialTicks;
                double smoothedX = part.field_70169_q + (part.field_70165_t - part.field_70169_q) * (double)partialTicks;
                double smoothedY = part.field_70167_r + (part.field_70163_u - part.field_70167_r) * (double)partialTicks;
                double smoothedZ = part.field_70166_s + (part.field_70161_v - part.field_70166_s) * (double)partialTicks;
                if (part == entity.target_north || part == entity.target_east || part == entity.target_south || part == entity.target_west || part == entity.bottom) continue;
                if (hitPart == part) {
                    GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                this.renderCogShield(part, x + smoothedX - smoothedMainX, y + smoothedY - smoothedMainY, z + smoothedZ - smoothedMainZ, floatate);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)(y + 4.5), (double)z);
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            this.func_110776_a(TARGET_TEXTURE);
            TARGET_MODEL.render(0.0625f);
            this.renderTargetGlowLayer(entity, 0.0625f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
        }
    }

    public void renderMultipass(EntityDecayPitTarget entity, double x, double y, double z, float entityYaw, float partialTicks) {
        int frameCounter = RenderUtils.getFrameCounter();
        if (entity.renderedFrameMultipass != frameCounter) {
            entity.renderedFrameMultipass = frameCounter;
            this.renderBeams(entity, x, y, z, entityYaw, partialTicks, false);
        }
    }

    private void renderBeams(EntityDecayPitTarget entity, double x, double y, double z, float entityYaw, float partialTicks, boolean innerBeams) {
        double yStart = (double)entity.field_70131_O - 1.0;
        for (int i = 0; i < 4; ++i) {
            double diffZ2;
            float beamAlpha = (float)entity.beamTransparencyTicks[i] / 15.0f;
            double diffX2 = i == 0 ? 1.7 : (i == 1 ? -1.7 : 0.0);
            double diffY2 = 0.0;
            double d = i == 2 ? 1.7 : (diffZ2 = i == 3 ? -1.7 : 0.0);
            double diffX = i == 0 ? 12.0 : (i == 1 ? -12.0 : 0.0);
            double diffY = 2.5 + (double)((float)entity.getProgress() * entity.MOVE_UNIT) - yStart;
            double diffZ = i == 2 ? 12.0 : (i == 3 ? -12.0 : 0.0);
            LightingUtil.INSTANCE.setLighting(255);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            GlStateManager.func_179129_p();
            this.func_110776_a(BEAM_TEXTURE);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)(y + yStart), (double)z);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            GlStateManager.func_179132_a((boolean)false);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            if (innerBeams) {
                ParticleBeam.buildBeam(diffX2, diffY2, diffZ2, new Vec3d(-diffX2, -diffY2, -diffZ2), 0.4f, 0.0f, 4.0f, ActiveRenderInfo.func_178808_b(), ActiveRenderInfo.func_178803_d(), ActiveRenderInfo.func_178805_e(), ActiveRenderInfo.func_178807_f(), ActiveRenderInfo.func_178809_c(), (vx, vy, vz, u, v) -> buffer.func_181662_b(vx, vy, vz).func_187315_a(u + (double)(((float)entity.field_70173_aa + partialTicks) * 0.15f), v).func_181669_b(255, 255, 255, (int)(beamAlpha * 255.0f)).func_181675_d());
            } else {
                ParticleBeam.buildBeam(diffX, diffY, diffZ, new Vec3d(-(diffX - diffX2), -(diffY - diffY2), -(diffZ - diffZ2)), 0.4f, 0.0f, 4.0f, ActiveRenderInfo.func_178808_b(), ActiveRenderInfo.func_178803_d(), ActiveRenderInfo.func_178805_e(), ActiveRenderInfo.func_178807_f(), ActiveRenderInfo.func_178809_c(), (vx, vy, vz, u, v) -> buffer.func_181662_b(vx, vy, vz).func_187315_a(u + (double)(((float)entity.field_70173_aa + partialTicks) * 0.15f), v).func_181669_b(255, 255, 255, (int)(beamAlpha * 255.0f)).func_181675_d());
            }
            tessellator.func_78381_a();
            GlStateManager.func_179092_a((int)516, (float)Math.max(0.0f, 0.5f + (beamAlpha - 1.0f) * 0.5f));
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            if (innerBeams) {
                ParticleBeam.buildBeam(diffX2, diffY2, diffZ2, new Vec3d(-diffX2, -diffY2, -diffZ2), 0.4f, 0.0f, 4.0f, ActiveRenderInfo.func_178808_b(), ActiveRenderInfo.func_178803_d(), ActiveRenderInfo.func_178805_e(), ActiveRenderInfo.func_178807_f(), ActiveRenderInfo.func_178809_c(), (vx, vy, vz, u, v) -> buffer.func_181662_b(vx, vy, vz).func_187315_a(u + (double)(((float)entity.field_70173_aa + partialTicks) * 0.15f), v).func_181669_b(255, 255, 255, (int)(beamAlpha * 255.0f)).func_181675_d());
            } else {
                ParticleBeam.buildBeam(diffX, diffY, diffZ, new Vec3d(-(diffX - diffX2), -(diffY - diffY2), -(diffZ - diffZ2)), 0.4f, 0.0f, 4.0f, ActiveRenderInfo.func_178808_b(), ActiveRenderInfo.func_178803_d(), ActiveRenderInfo.func_178805_e(), ActiveRenderInfo.func_178807_f(), ActiveRenderInfo.func_178809_c(), (vx, vy, vz, u, v) -> buffer.func_181662_b(vx, vy, vz).func_187315_a(u + (double)(((float)entity.field_70173_aa + partialTicks) * 0.15f), v).func_181669_b(255, 255, 255, (int)(beamAlpha * 255.0f)).func_181675_d());
            }
            tessellator.func_78381_a();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179121_F();
            GlStateManager.func_179089_o();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            LightingUtil.INSTANCE.revert();
        }
    }

    public void renderPlugGlowLayer(EntityDecayPitTarget entity, float scale) {
        this.func_110776_a(PLUG_TEXTURE_GLOW);
        LayerOverlay.renderOverlay(entity, () -> PLUG_MODEL.render(scale), true, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderTargetGlowLayer(EntityDecayPitTarget entity, float scale) {
        this.func_110776_a(TARGET_TEXTURE_GLOW);
        LayerOverlay.renderOverlay(entity, () -> TARGET_MODEL.render(scale), true, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void setLightmap(EntityDecayPitTarget entity, Boolean useEntityBrightness) {
        int i = 61680;
        if (useEntityBrightness.booleanValue()) {
            i = entity.func_70070_b();
        }
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
    }

    private void renderCogShield(EntityDecayPitTargetPart entity, double x, double y, double z, float angle) {
        GlStateManager.func_179094_E();
        this.func_110776_a(SHIELD_TEXTURE);
        GlStateManager.func_179137_b((double)x, (double)(y + 1.5), (double)z);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        SHIELD_MODEL.render(0.0625f);
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(EntityDecayPitTarget entity) {
        return null;
    }

    public boolean func_188295_H_() {
        return true;
    }

    @Override
    public void setRenderFromMultipart(EntityMultipartDummy dummy) {
    }
}

