/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.entity.ModelShambler;
import thebetweenlands.common.entity.mobs.EntityShambler;

@SideOnly(value=Side.CLIENT)
public class RenderShambler
extends RenderLiving<EntityShambler> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/shambler.png");
    public final ModelShambler model = new ModelShambler();

    public RenderShambler(RenderManager rendermanagerIn) {
        super(rendermanagerIn, (ModelBase)new ModelShambler(), 0.5f);
    }

    public void doRender(EntityShambler entity, double x, double y, double z, float yaw, float partialTicks) {
        super.func_76986_a((EntityLiving)entity, x, y, z, yaw, partialTicks);
        if (entity.getTongueLength() > 0) {
            double ex = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double ey = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double ez = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            double rx = ex - x;
            double ry = ey - y;
            double rz = ez - z;
            for (int i = 0; i < entity.tongue_array.length; ++i) {
                this.renderTonguePart(entity, entity.tongue_array[i], rx, ry, rz, partialTicks);
            }
        }
    }

    protected ResourceLocation getEntityTexture(EntityShambler entity) {
        return TEXTURE;
    }

    private void renderTonguePart(EntityShambler entity, MultiPartEntityPart part, double rx, double ry, double rz, float partialTicks) {
        double x = part.field_70142_S + (part.field_70165_t - part.field_70142_S) * (double)partialTicks - rx;
        double y = part.field_70137_T + (part.field_70163_u - part.field_70137_T) * (double)partialTicks - ry;
        double z = part.field_70136_U + (part.field_70161_v - part.field_70136_U) * (double)partialTicks - rz;
        float yaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks;
        float pitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
        this.func_110776_a(TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y - 0.85), (double)z);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(180.0f + yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f + pitch), (float)1.0f, (float)0.0f, (float)0.0f);
        if (part == entity.tongue_end) {
            this.model.renderTongueEnd(0.0625f);
        } else {
            this.model.renderTonguePart(0.0625f);
        }
        GlStateManager.func_179121_F();
    }

    private void renderDebugBoundingBox(Entity entity, double x, double y, double z, float yaw, float partialTicks, double xOff, double yOff, double zOff) {
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.field_72340_a - entity.field_70165_t + x + xOff, axisalignedbb.field_72338_b - entity.field_70163_u + y + yOff, axisalignedbb.field_72339_c - entity.field_70161_v + z + zOff, axisalignedbb.field_72336_d - entity.field_70165_t + x + xOff, axisalignedbb.field_72337_e - entity.field_70163_u + y + yOff, axisalignedbb.field_72334_f - entity.field_70161_v + z + zOff);
        RenderGlobal.func_189697_a((AxisAlignedBB)axisalignedbb1, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
    }
}

