/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity;

import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.entity.IMultipartDummyRendererDelegate;
import thebetweenlands.client.render.entity.RenderWallLivingRoot;
import thebetweenlands.client.render.tile.RenderDecayPitControl;
import thebetweenlands.common.entity.mobs.EntityMultipartDummy;
import thebetweenlands.common.entity.mobs.EntitySludgeMenace;
import thebetweenlands.common.entity.mobs.EntityWallLivingRoot;
import thebetweenlands.util.RenderUtils;

@SideOnly(value=Side.CLIENT)
public class RenderSludgeMenace
extends RenderWallLivingRoot
implements IMultipartDummyRendererDelegate<EntitySludgeMenace> {
    public static final ResourceLocation HULL_TEXTURE = new ResourceLocation("thebetweenlands:textures/entity/sludge_menace_hull.png");
    public static final ResourceLocation DECAY_HOLE_TEXTURE_1 = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_hole_1.png");
    public static final ResourceLocation DECAY_HOLE_TEXTURE_2 = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_hole_2.png");
    public static final ResourceLocation DECAY_HOLE_TEXTURE_3 = new ResourceLocation("thebetweenlands:textures/entity/decay_pit_hole_3.png");

    public RenderSludgeMenace(RenderManager renderManager) {
        super(renderManager, HULL_TEXTURE);
    }

    @Override
    public void doRender(EntityWallLivingRoot entity, double x, double y, double z, float entityYaw, float partialTicks) {
        EntitySludgeMenace sludge = (EntitySludgeMenace)entity;
        int frameCounter = RenderUtils.getFrameCounter();
        if (sludge.renderedFrame != frameCounter) {
            sludge.renderedFrame = frameCounter;
            super.doRender(entity, x, y, z, entityYaw, partialTicks);
        }
    }

    @Override
    protected void renderEntityModel(EntityWallLivingRoot entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, float partialTicks) {
        super.renderEntityModel(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, partialTicks);
        if (this.field_77045_g == BLANK_MODEL) {
            int part;
            this.func_177091_f();
            float ringRotation = (float)entity.field_70173_aa + partialTicks;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)entity.getArmSize(partialTicks));
            GlStateManager.func_179132_a((boolean)false);
            this.func_110776_a(DECAY_HOLE_TEXTURE_1);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (part = 0; part < 24; ++part) {
                RenderDecayPitControl.buildRingQuads(buffer, 0.0, 0.203f, 0.0, 15.0f * (float)part, 2.25, 2.25, 0.0, 0.0, false);
            }
            tessellator.func_78381_a();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.0);
            GlStateManager.func_179114_b((float)ringRotation, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)0.0);
            GlStateManager.func_179128_n((int)5888);
            this.func_110776_a(DECAY_HOLE_TEXTURE_2);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (part = 0; part < 24; ++part) {
                RenderDecayPitControl.buildRingQuads(buffer, 0.0, 0.703f, 0.0, 15.0f * (float)part, 2.0, 2.0, 0.0, 0.0, false);
            }
            tessellator.func_78381_a();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.0);
            GlStateManager.func_179114_b((float)(ringRotation * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)0.0);
            GlStateManager.func_179128_n((int)5888);
            this.func_110776_a(DECAY_HOLE_TEXTURE_3);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (part = 0; part < 24; ++part) {
                RenderDecayPitControl.buildRingQuads(buffer, 0.0, 0.953f, 0.0, 15.0f * (float)part, 2.25, 2.25, 0.0, 0.0, false);
            }
            tessellator.func_78381_a();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
            this.func_177090_c((EntityLivingBase)entity, partialTicks);
        }
    }

    @Override
    protected float getUvScale(EntityWallLivingRoot entity, float partialTicks) {
        return 1.0f;
    }

    @Override
    protected float calculateHullContraction(EntityWallLivingRoot entity, int i, float armSize, float partialTicks) {
        List<EntitySludgeMenace.Bulge> bulges = ((EntitySludgeMenace)entity).getBulges(partialTicks);
        float bulgeSize = 0.0f;
        if (bulges != null) {
            for (EntitySludgeMenace.Bulge bulge : bulges) {
                float bulgePos = bulge.renderPosition * (float)entity.armSegments.size();
                bulgeSize += (float)Math.cos(Math.min((double)(Math.abs(bulgePos - (float)i) / bulge.type.length), 1.5707963267948966)) * bulge.renderSize;
            }
        }
        float baseSize = (1.0f - (float)i / (float)(entity.armSegments.size() - 1) + 0.2f) * armSize;
        float animation = ((float)Math.sin(-((float)entity.field_70173_aa + partialTicks) * 0.2f + (float)i) + 0.5f) * 0.5f * 0.2f + 0.8f;
        return Math.max(Math.min(bulgeSize, 1.2f), baseSize * animation);
    }

    @Override
    protected void renderBodyHull(EntityWallLivingRoot entity, float partialTicks) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.renderBodyHull(entity, partialTicks);
        GlStateManager.func_179084_k();
    }

    @Override
    public void setRenderFromMultipart(EntityMultipartDummy dummy) {
    }
}

