/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity.layer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import thebetweenlands.client.render.entity.RenderPlayerRower;
import thebetweenlands.client.render.model.entity.rowboat.ModelBipedRower;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.util.Matrix;

public class LayerRowerArmor
extends LayerBipedArmor {
    private final RenderPlayerRower rower;
    private final ModelBiped initialPose = new ModelBipedRower(0.0f);
    private final GlintDelegate glint = new GlintDelegate();
    private Map<ModelBiped, ArmorRenderer> cache = new HashMap<ModelBiped, ArmorRenderer>();
    private Set<Item> naughtyList = new HashSet<Item>();

    public LayerRowerArmor(RenderPlayerRower renderer) {
        super((RenderLivingBase)renderer);
        this.rower = renderer;
    }

    protected void func_177177_a() {
        this.field_177189_c = new ModelBipedRower(0.5f);
        this.field_177186_d = new ModelBipedRower(1.0f);
    }

    public ModelBipedRower getLeggings() {
        return (ModelBipedRower)this.field_177189_c;
    }

    public ModelBipedRower getChest() {
        return (ModelBipedRower)this.field_177186_d;
    }

    public void func_177141_a(EntityLivingBase living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.renderArmorLayer(living, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.CHEST);
        this.renderArmorLayer(living, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.LEGS);
        this.renderArmorLayer(living, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.FEET);
        this.renderArmorLayer(living, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.HEAD);
    }

    private void renderArmorLayer(EntityLivingBase living, float limbSwing, float limbSwingAmount, float delta, float age, float headYaw, float headPitch, float scale, EntityEquipmentSlot slot) {
        ItemArmor itemarmor;
        ItemStack stack = living.func_184582_a(slot);
        Item item = stack.func_77973_b();
        if (item instanceof ItemArmor && (itemarmor = (ItemArmor)item).func_185083_B_() == slot) {
            ArmorRenderer armor = this.getModel(living, stack, slot, (ModelBiped)this.func_188360_a(slot));
            armor.setup(living, limbSwing, limbSwingAmount, delta, slot);
            this.rower.func_110776_a(this.getArmorResource((Entity)living, stack, slot, null));
            if (itemarmor.hasOverlay(stack)) {
                int rgb = itemarmor.func_82814_b(stack);
                float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                float b = (float)(rgb & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
                armor.render(living, limbSwing, limbSwingAmount, age, headYaw, headPitch, scale, slot);
                this.rower.func_110776_a(this.getArmorResource((Entity)living, stack, slot, "overlay"));
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            armor.render(living, limbSwing, limbSwingAmount, age, headYaw, headPitch, scale, slot);
            if (stack.func_77962_s()) {
                this.glint.render(living, armor, limbSwing, limbSwingAmount, delta, age, headYaw, headPitch, scale, slot);
            }
        }
    }

    private ArmorRenderer getModel(EntityLivingBase entity, ItemStack stack, EntityEquipmentSlot slot, ModelBiped model) {
        ModelBiped result = this.getArmorModelHook(entity, stack, slot, model);
        if (result == model) {
            return this.cache.computeIfAbsent(model, x$0 -> new BuiltInArmorRenderer((ModelBiped)x$0));
        }
        if (result == this.getArmorModelHook(entity, stack, slot, model)) {
            return this.cache.computeIfAbsent(result, this::createCustomArmorModel);
        }
        if (this.naughtyList.add(stack.func_77973_b())) {
            ResourceLocation reg = stack.func_77973_b().getRegistryName();
            String name = "???";
            String owner = "???";
            if (reg != null) {
                name = reg.toString();
                ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(reg.func_110624_b());
                if (mod != null) {
                    owner = mod.getName();
                }
            }
            TheBetweenlands.logger.warn("Expect decreased rendering performance of item \"{}\" registered as \"{}\" with class \"{}\" as it appears to not cache its custom model, leaking video memory. Report to mod \"{}\"!", (Object)stack.func_82833_r(), (Object)name, (Object)stack.func_77973_b().getClass().getName(), (Object)owner);
        }
        return this.createCustomArmorModel(result);
    }

    private CustomArmorRenderer createCustomArmorModel(ModelBiped model) {
        return new CustomArmorRenderer(model, this.getForearmModels(model.field_178724_i), this.getForearmModels(model.field_178723_h));
    }

    private List<ModelRenderer> getForearmModels(ModelRenderer model) {
        if (model.field_78805_m == null) {
            return Collections.emptyList();
        }
        ArrayList<ModelRenderer> lower = new ArrayList<ModelRenderer>();
        double armHalfLen = 6.0;
        Matrix m = new Matrix();
        for (ModelRenderer child : model.field_78805_m) {
            m.setIdentity();
            m.translate(child.field_78800_c, child.field_78797_d, child.field_78798_e);
            m.rotate(child.field_78808_h, 0.0, 0.0, 1.0);
            m.rotate(child.field_78796_g, 0.0, 1.0, 0.0);
            m.rotate(child.field_78795_f, 1.0, 0.0, 0.0);
            double half = 0.0;
            for (ModelBox box : child.field_78804_l) {
                float lenX = box.field_78248_d - box.field_78252_a;
                float lenY = box.field_78249_e - box.field_78250_b;
                float lenZ = box.field_78246_f - box.field_78251_c;
                float px = 0.5f * lenX;
                float py = 0.5f * lenY;
                float pz = 0.5f * lenZ;
                if (lenX > lenY && lenX > lenZ) {
                    px = 0.0f;
                } else if (lenY > lenX && lenY > lenZ) {
                    py = 0.0f;
                } else {
                    pz = 0.0f;
                }
                half += m.transform((Vec3d)new Vec3d((double)((double)(box.field_78252_a + px)), (double)((double)(box.field_78250_b + py)), (double)((double)(box.field_78251_c + pz)))).field_72448_b - armHalfLen;
                half += m.transform((Vec3d)new Vec3d((double)((double)(box.field_78248_d - px)), (double)((double)(box.field_78249_e - py)), (double)((double)(box.field_78246_f - pz)))).field_72448_b - armHalfLen;
            }
            if (!(half > 0.0)) continue;
            lower.add(child);
        }
        return lower;
    }

    class GlintDelegate
    extends ModelBase {
        ArmorRenderer model;
        EntityEquipmentSlot slot;

        GlintDelegate() {
        }

        public void func_78088_a(Entity living, float limbSwing, float limbSwingAmount, float age, float headYaw, float headPitch, float scale) {
            this.model.render((EntityLivingBase)living, limbSwing, limbSwingAmount, age, headYaw, headPitch, scale, this.slot);
        }

        void render(EntityLivingBase living, ArmorRenderer model, float limbSwing, float limbSwingAmount, float delta, float age, float headYaw, float headPitch, float scale, EntityEquipmentSlot slot) {
            this.model = model;
            this.slot = slot;
            LayerArmorBase.func_188364_a((RenderLivingBase)LayerRowerArmor.this.rower, (EntityLivingBase)living, (ModelBase)this, (float)limbSwing, (float)limbSwingAmount, (float)delta, (float)age, (float)headYaw, (float)headPitch, (float)scale);
        }
    }

    class CustomArmorRenderer
    extends ModelArmorRenderer {
        final List<ModelRenderer> leftForearmParts;
        final List<ModelRenderer> rightForearmParts;
        boolean init;

        CustomArmorRenderer(ModelBiped model, List<ModelRenderer> leftForearmParts, List<ModelRenderer> rightForearmParts) {
            super(model);
            this.init = true;
            this.leftForearmParts = leftForearmParts;
            this.rightForearmParts = rightForearmParts;
        }

        @Override
        void render(EntityLivingBase living, float limbSwing, float limbSwingAmount, float age, float headYaw, float headPitch, float scale, EntityEquipmentSlot slot) {
            if (this.init) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)0.0, (double)-10000.0, (double)0.0);
                GlStateManager.func_179139_a((double)0.0, (double)0.0, (double)0.0);
                this.model.func_78088_a((Entity)living, limbSwing, limbSwing, age, headYaw, headPitch, scale);
                GlStateManager.func_179121_F();
                this.init = false;
            }
            this.model.func_78087_a(0.0f, 0.0f, age, 0.0f, 0.0f, scale, (Entity)living);
            GlStateManager.func_179094_E();
            switch (slot) {
                case HEAD: {
                    this.transform(((ModelBiped)((LayerRowerArmor)LayerRowerArmor.this).field_177186_d).field_78115_e, scale);
                    this.renderHead(((ModelBiped)((LayerRowerArmor)LayerRowerArmor.this).field_177186_d).field_78115_e, ((ModelBiped)((LayerRowerArmor)LayerRowerArmor.this).field_177186_d).field_78116_c, this.model.field_78116_c, scale);
                    break;
                }
                case CHEST: {
                    this.render(((ModelBiped)((LayerRowerArmor)LayerRowerArmor.this).field_177186_d).field_78115_e, this.model.field_78115_e, scale);
                    this.transform(((ModelBiped)((LayerRowerArmor)LayerRowerArmor.this).field_177186_d).field_78115_e, scale);
                    this.renderArm(((ModelBiped)((LayerRowerArmor)LayerRowerArmor.this).field_177186_d).field_78115_e, ((ModelBiped)((LayerRowerArmor)LayerRowerArmor.this).field_177186_d).field_178724_i, ((LayerRowerArmor)LayerRowerArmor.this).initialPose.field_178724_i, LayerRowerArmor.this.getChest().leftForearm, this.model.field_178724_i, scale);
                    this.renderArm(((ModelBiped)((LayerRowerArmor)LayerRowerArmor.this).field_177186_d).field_78115_e, ((ModelBiped)((LayerRowerArmor)LayerRowerArmor.this).field_177186_d).field_178723_h, ((LayerRowerArmor)LayerRowerArmor.this).initialPose.field_178723_h, LayerRowerArmor.this.getChest().rightForearm, this.model.field_178723_h, scale);
                    break;
                }
                case LEGS: {
                    this.render(((ModelBiped)((LayerRowerArmor)LayerRowerArmor.this).field_177189_c).field_78115_e, this.model.field_78115_e, scale);
                }
                case FEET: {
                    this.render(((ModelBiped)((LayerRowerArmor)LayerRowerArmor.this).field_177186_d).field_178722_k, this.model.field_178722_k, scale);
                    this.render(((ModelBiped)((LayerRowerArmor)LayerRowerArmor.this).field_177186_d).field_178721_j, this.model.field_178721_j, scale);
                }
            }
            GlStateManager.func_179121_F();
        }

        private void renderArm(ModelRenderer body, ModelRenderer upperArm, ModelRenderer initialArm, ModelRenderer lowerArm, ModelRenderer model, float scale) {
            GlStateManager.func_179094_E();
            this.transform(upperArm, scale);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-initialArm.field_78800_c * scale), (float)((-initialArm.field_78797_d - body.field_78797_d) * scale), (float)(-initialArm.field_78798_e * scale));
            List forearmModels = LayerRowerArmor.this.getForearmModels(model);
            this.renderExcluding(model, forearmModels, scale);
            GlStateManager.func_179121_F();
            this.transform(lowerArm, scale);
            GlStateManager.func_179109_b((float)((model.field_78800_c - initialArm.field_78800_c) * scale), (float)(-lowerArm.field_78797_d * scale), (float)0.0f);
            for (ModelRenderer m : forearmModels) {
                m.func_78785_a(scale);
            }
            GlStateManager.func_179121_F();
        }

        private void renderExcluding(ModelRenderer model, List<ModelRenderer> exclusions, float scale) {
            if (model.field_78805_m != null) {
                model.field_78805_m.removeAll(exclusions);
            }
            this.render(model, scale);
            if (model.field_78805_m != null) {
                model.field_78805_m.addAll(exclusions);
            }
        }

        private void renderHead(ModelRenderer body, ModelRenderer pose, ModelRenderer model, float scale) {
            GlStateManager.func_179094_E();
            this.transform(pose, scale);
            GlStateManager.func_179109_b((float)(-pose.field_78800_c * scale), (float)((-pose.field_78797_d - body.field_78797_d) * scale), (float)(-pose.field_78798_e * scale));
            this.render(model, scale);
            GlStateManager.func_179121_F();
        }

        private void render(ModelRenderer pose, ModelRenderer model, float scale) {
            GlStateManager.func_179094_E();
            this.transform(pose, scale);
            GlStateManager.func_179109_b((float)(-pose.field_78800_c * scale), (float)(-pose.field_78797_d * scale), (float)(-pose.field_78798_e * scale));
            this.render(model, scale);
            GlStateManager.func_179121_F();
        }

        private void render(ModelRenderer model, float scale) {
            float rx = model.field_78795_f;
            float ry = model.field_78796_g;
            float rz = model.field_78808_h;
            model.field_78795_f = 0.0f;
            model.field_78796_g = 0.0f;
            model.field_78808_h = 0.0f;
            model.func_78785_a(scale);
            model.field_78795_f = rx;
            model.field_78796_g = ry;
            model.field_78808_h = rz;
        }

        private void transform(ModelRenderer model, float scale) {
            boolean show = model.field_78806_j;
            model.field_78806_j = true;
            model.func_78794_c(scale);
            model.field_78806_j = show;
        }
    }

    class BuiltInArmorRenderer
    extends ModelArmorRenderer {
        BuiltInArmorRenderer(ModelBiped model) {
            super(model);
        }

        @Override
        void render(EntityLivingBase living, float limbSwing, float limbSwingAmount, float age, float headYaw, float headPitch, float scale, EntityEquipmentSlot slot) {
            this.model.func_78088_a((Entity)living, limbSwing, limbSwingAmount, age, headYaw, headPitch, scale);
        }
    }

    abstract class ModelArmorRenderer
    extends ArmorRenderer {
        final ModelBiped model;

        ModelArmorRenderer(ModelBiped model) {
            this.model = model;
        }

        @Override
        void setup(EntityLivingBase living, float limbSwing, float limbSwingAmount, float delta, EntityEquipmentSlot slot) {
            this.model.func_178686_a((ModelBase)LayerRowerArmor.this.rower.getMainModel());
            this.model.func_78086_a(living, limbSwing, limbSwingAmount, delta);
            LayerRowerArmor.this.func_188359_a(this.model, slot);
        }
    }

    static abstract class ArmorRenderer {
        ArmorRenderer() {
        }

        abstract void setup(EntityLivingBase var1, float var2, float var3, float var4, EntityEquipmentSlot var5);

        abstract void render(EntityLivingBase var1, float var2, float var3, float var4, float var5, float var6, float var7, EntityEquipmentSlot var8);
    }
}

