/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.util.QuadBuilder;

public class ModelConnectedTexture
implements IModel {
    protected final List<ConnectedTextureQuad> connectedTextures;
    protected final ResourceLocation particleTexture;
    protected final boolean ambientOcclusion;

    public ModelConnectedTexture() {
        this(TextureMap.field_174945_f, true, (List<ConnectedTextureQuad>)ImmutableList.of());
    }

    public ModelConnectedTexture(ResourceLocation particleTexture, boolean ambientOcclusion, List<ConnectedTextureQuad> textures) {
        this.particleTexture = particleTexture;
        this.ambientOcclusion = ambientOcclusion;
        this.connectedTextures = textures;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        if (!this.connectedTextures.isEmpty()) {
            ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
            for (ConnectedTextureQuad quad : this.connectedTextures) {
                Collections.addAll(textures, quad.textures);
            }
            return textures;
        }
        return ImmutableList.of();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap map = PerspectiveMapWrapper.getTransforms((IModelState)state);
        Optional transformation = state.apply(Optional.empty());
        for (ConnectedTextureQuad connectedTexture : this.connectedTextures) {
            connectedTexture.bake(bakedTextureGetter, transformation, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map, format);
        }
        return new ModelBakedConnectedFace(transformation, map, format, bakedTextureGetter.apply(this.particleTexture), this.ambientOcclusion, this.connectedTextures);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        JsonParser parser = new JsonParser();
        boolean changed = false;
        List<ConnectedTextureQuad> connectedTextures = this.connectedTextures;
        if (customData.containsKey((Object)"connected_texture_faces")) {
            changed = true;
            connectedTextures = new ArrayList<ConnectedTextureQuad>();
            JsonElement jsonObj = parser.parse((String)customData.get((Object)"connected_texture_faces"));
            Preconditions.checkState((jsonObj != null && !jsonObj.isJsonNull() && jsonObj.isJsonArray() ? 1 : 0) != 0, (Object)"Connected texture model must provide a connected_texture_faces array");
            JsonArray array = jsonObj.getAsJsonArray();
            for (JsonElement element : array) {
                JsonObject ctJson = element.getAsJsonObject();
                Preconditions.checkState((ctJson.has("indices") && ctJson.get("indices").isJsonArray() && ctJson.get("indices").getAsJsonArray().size() == 4 ? 1 : 0) != 0, (Object)"Connected texture face must provide 4 indices");
                String[] indices = new String[4];
                JsonArray indicesArray = ctJson.get("indices").getAsJsonArray();
                for (int i = 0; i < 4; ++i) {
                    indices[i] = indicesArray.get(i).getAsString();
                }
                Preconditions.checkState((ctJson.has("vertices") && ctJson.get("vertices").isJsonArray() && ctJson.get("vertices").getAsJsonArray().size() == 4 ? 1 : 0) != 0, (Object)"Connected texture face must provide 4 vertices");
                Vertex[] vertices = new Vertex[4];
                JsonArray verticesArray = ctJson.get("vertices").getAsJsonArray();
                for (int i = 0; i < 4; ++i) {
                    JsonObject vertexJson = verticesArray.get(i).getAsJsonObject();
                    vertices[i] = new Vertex(vertexJson.get("x").getAsDouble(), vertexJson.get("y").getAsDouble(), vertexJson.get("z").getAsDouble(), vertexJson.get("u").getAsFloat(), vertexJson.get("v").getAsFloat());
                }
                Preconditions.checkState((ctJson.has("connected_textures") && ctJson.get("connected_textures").isJsonArray() && ctJson.get("connected_textures").getAsJsonArray().size() == 5 ? 1 : 0) != 0, (Object)"Connected texture face must provide 5 textures");
                ResourceLocation[] textures = new ResourceLocation[5];
                JsonArray texturesArray = ctJson.get("connected_textures").getAsJsonArray();
                for (int i = 0; i < 5; ++i) {
                    textures[i] = new ResourceLocation(texturesArray.get(i).getAsString());
                }
                int tintIndex = -1;
                if (ctJson.has("tintindex")) {
                    tintIndex = ctJson.get("tintindex").getAsInt();
                }
                EnumFacing cullFace = null;
                if (ctJson.has("cullface")) {
                    cullFace = EnumFacing.func_176739_a((String)ctJson.get("cullface").getAsString());
                }
                float minU = 0.0f;
                float minV = 0.0f;
                float maxU = 1.0f;
                float maxV = 1.0f;
                if (ctJson.has("minU")) {
                    minU = ctJson.get("minU").getAsFloat();
                }
                if (ctJson.has("minV")) {
                    minV = ctJson.get("minV").getAsFloat();
                }
                if (ctJson.has("maxU")) {
                    maxU = ctJson.get("maxU").getAsFloat();
                }
                if (ctJson.has("maxV")) {
                    maxV = ctJson.get("maxV").getAsFloat();
                }
                connectedTextures.add(new ConnectedTextureQuad(textures, indices, vertices, cullFace, tintIndex, minU, minV, maxU, maxV));
            }
        }
        boolean ambientOcclusion = this.ambientOcclusion;
        if (customData.containsKey((Object)"ambient_occlusion")) {
            changed = true;
            ambientOcclusion = parser.parse((String)customData.get((Object)"ambient_occlusion")).getAsBoolean();
        }
        ResourceLocation particleTexture = this.particleTexture;
        if (customData.containsKey((Object)"particle_texture")) {
            changed = true;
            particleTexture = new ResourceLocation(parser.parse((String)customData.get((Object)"particle_texture")).getAsString());
        }
        if (changed) {
            return new ModelConnectedTexture(particleTexture == null ? TextureMap.field_174945_f : particleTexture, ambientOcclusion, connectedTextures);
        }
        return this;
    }

    public static class ModelBakedConnectedFace
    implements IBakedModel {
        protected final ConnectedTextureQuad[][] connectedTextures;
        protected final TextureAtlasSprite particleTexture;
        protected final boolean ambientOcclusion;
        protected final VertexFormat format;
        protected final TRSRTransformation transformation;
        protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;

        private ModelBakedConnectedFace(Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, TextureAtlasSprite particleTexture, boolean ambientOcclusion, List<ConnectedTextureQuad> connectedTextures) {
            this.ambientOcclusion = ambientOcclusion;
            this.format = format;
            this.transforms = transforms;
            this.transformation = transformation.isPresent() ? transformation.get() : null;
            this.particleTexture = particleTexture;
            this.connectedTextures = new ConnectedTextureQuad[EnumFacing.field_82609_l.length + 1][];
            ArrayList<ConnectedTextureQuad> connectedTextureQuads = new ArrayList<ConnectedTextureQuad>();
            for (int i = 0; i < EnumFacing.field_82609_l.length + 1; ++i) {
                EnumFacing face = i == 0 ? null : EnumFacing.field_82609_l[i - 1];
                connectedTextureQuads.clear();
                for (ConnectedTextureQuad tex : connectedTextures) {
                    if (face != tex.cullFace) continue;
                    connectedTextureQuads.add(tex);
                }
                this.connectedTextures[i == 0 ? 0 : face.func_176745_a() + 1] = connectedTextureQuads.toArray(new ConnectedTextureQuad[0]);
            }
        }

        public List<BakedQuad> func_188616_a(IBlockState stateOld, EnumFacing side, long rand) {
            IExtendedBlockState state = (IExtendedBlockState)stateOld;
            ImmutableMap properties = state.getUnlistedProperties();
            int faceIndex = side == null ? 0 : side.func_176745_a() + 1;
            ConnectedTextureQuad[] connectedTextures = this.connectedTextures[faceIndex];
            if (connectedTextures.length > 0) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (ConnectedTextureQuad tex : connectedTextures) {
                    int[] indices = new int[4];
                    block1: for (Map.Entry entry : properties.entrySet()) {
                        String property = ((IUnlistedProperty)entry.getKey()).getName();
                        for (int i = 0; i < 4; ++i) {
                            if (!tex.indices[i].equals(property)) continue;
                            if (((Optional)entry.getValue()).isPresent()) {
                                indices[i] = (Integer)((Optional)entry.getValue()).get();
                                continue;
                            }
                            indices[3] = 0;
                            indices[2] = 0;
                            indices[1] = 0;
                            indices[0] = 0;
                            break block1;
                        }
                    }
                    for (int i = 0; i < 4; ++i) {
                        builder.add((Object)tex.quads[i][indices[i]]);
                    }
                }
                return builder.build();
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return this.ambientOcclusion;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particleTexture;
        }
    }

    protected static class ConnectedTextureQuad {
        protected final ResourceLocation[] textures;
        protected final String[] indices;
        protected final Vertex[] verts;
        protected final EnumFacing cullFace;
        protected final int tintIndex;
        protected final float minU;
        protected final float minV;
        protected final float maxU;
        protected final float maxV;
        protected final BakedQuad[][] quads;

        protected ConnectedTextureQuad(ResourceLocation[] textures, String[] indices, Vertex[] verts, EnumFacing cullFace, int tintIndex, float minU, float minV, float maxU, float maxV) {
            this.textures = textures;
            this.indices = indices;
            this.verts = verts;
            this.cullFace = cullFace;
            this.tintIndex = tintIndex;
            this.quads = new BakedQuad[4][this.textures.length];
            this.minU = minU;
            this.minV = minV;
            this.maxU = maxU;
            this.maxV = maxV;
        }

        public BakedQuad[][] getQuads() {
            return this.quads;
        }

        public void bake(Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format) {
            Vertex uvOffset = new Vertex(0.0, 0.0, 0.0, this.minU, this.minV);
            Vertex v0 = this.verts[0].scaleUVs(this.maxU - this.minU, this.maxV - this.minV).add(uvOffset);
            Vertex v1 = this.verts[1].scaleUVs(this.maxU - this.minU, this.maxV - this.minV).add(uvOffset);
            Vertex v2 = this.verts[2].scaleUVs(this.maxU - this.minU, this.maxV - this.minV).add(uvOffset);
            Vertex v3 = this.verts[3].scaleUVs(this.maxU - this.minU, this.maxV - this.minV).add(uvOffset);
            Vertex d01 = v1.subtract(v0);
            Vertex d12 = v2.subtract(v1);
            Vertex d23 = v3.subtract(v2);
            Vertex d30 = v0.subtract(v3);
            float e01 = this.extrapolateClamp(v0.uv.field_189983_j, v1.uv.field_189983_j, (this.maxV + this.minV) / 2.0f);
            float e12 = this.extrapolateClamp(v1.uv.field_189982_i, v2.uv.field_189982_i, (this.maxU + this.minU) / 2.0f);
            float e23 = this.extrapolateClamp(v2.uv.field_189983_j, v3.uv.field_189983_j, (this.maxV + this.minV) / 2.0f);
            float e30 = this.extrapolateClamp(v3.uv.field_189982_i, v0.uv.field_189982_i, (this.maxU + this.minU) / 2.0f);
            Vertex p01 = v0.add(d01.scale(e01));
            Vertex p12 = v1.add(d12.scale(e12));
            Vertex p23 = v2.add(d23.scale(e23));
            Vertex p30 = v3.add(d30.scale(e30));
            Vertex d0123 = p23.subtract(p01);
            float ecp = this.extrapolateClamp(v0.uv.field_189982_i + (v1.uv.field_189982_i - v0.uv.field_189982_i) * e01, v2.uv.field_189982_i + (v3.uv.field_189982_i - v2.uv.field_189982_i) * e23, (this.maxU + this.minU) / 2.0f);
            Vertex cp = p01.add(d0123.scale(ecp));
            TextureAtlasSprite[] sprites = new TextureAtlasSprite[this.textures.length];
            for (int i = 0; i < sprites.length; ++i) {
                sprites[i] = bakedTextureGetter.apply(this.textures[i]);
            }
            this.quads[0] = this.bakeTextureVariants(format, transformation, sprites, new Vertex[]{v0, p01, cp, p30});
            this.quads[1] = this.bakeTextureVariants(format, transformation, sprites, new Vertex[]{p01, v1, p12, cp});
            this.quads[2] = this.bakeTextureVariants(format, transformation, sprites, new Vertex[]{cp, p12, v2, p23});
            this.quads[3] = this.bakeTextureVariants(format, transformation, sprites, new Vertex[]{p30, cp, p23, v3});
        }

        protected float extrapolateClamp(float v1, float v2, float v) {
            float extrapolant = (v - v1) / (v2 - v1);
            return MathHelper.func_76131_a((float)extrapolant, (float)0.0f, (float)1.0f);
        }

        protected BakedQuad[] bakeTextureVariants(VertexFormat format, Optional<TRSRTransformation> transformation, TextureAtlasSprite[] sprites, Vertex[] verts) {
            QuadBuilder builder = new QuadBuilder(4 * this.textures.length, format);
            if (transformation.isPresent()) {
                builder.setTransformation(transformation.get());
            }
            for (int i = 0; i < sprites.length; ++i) {
                builder.setSprite(sprites[i]);
                builder.addVertex(verts[0].pos, verts[0].uv.field_189982_i * 16.0f, verts[0].uv.field_189983_j * 16.0f);
                builder.addVertex(verts[1].pos, verts[1].uv.field_189982_i * 16.0f, verts[1].uv.field_189983_j * 16.0f);
                builder.addVertex(verts[2].pos, verts[2].uv.field_189982_i * 16.0f, verts[2].uv.field_189983_j * 16.0f);
                builder.addVertex(verts[3].pos, verts[3].uv.field_189982_i * 16.0f, verts[3].uv.field_189983_j * 16.0f);
            }
            return (BakedQuad[])builder.build((Consumer<UnpackedBakedQuad.Builder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$bakeTextureVariants$0(net.minecraftforge.client.model.pipeline.UnpackedBakedQuad$Builder ), (Lnet/minecraftforge/client/model/pipeline/UnpackedBakedQuad$Builder;)V)((ConnectedTextureQuad)this)).nonCulledQuads.toArray((Object[])new BakedQuad[0]);
        }

        private /* synthetic */ void lambda$bakeTextureVariants$0(UnpackedBakedQuad.Builder b) {
            b.setQuadTint(this.tintIndex);
        }
    }

    protected static class Vertex {
        protected final Vec3d pos;
        protected final Vec2f uv;

        protected Vertex(double x, double y, double z, float u, float v) {
            this.pos = new Vec3d(x, y, z);
            this.uv = new Vec2f(u, v);
        }

        protected Vertex add(Vertex vertex) {
            return new Vertex(this.pos.field_72450_a + vertex.pos.field_72450_a, this.pos.field_72448_b + vertex.pos.field_72448_b, this.pos.field_72449_c + vertex.pos.field_72449_c, this.uv.field_189982_i + vertex.uv.field_189982_i, this.uv.field_189983_j + vertex.uv.field_189983_j);
        }

        protected Vertex subtract(Vertex vertex) {
            return new Vertex(this.pos.field_72450_a - vertex.pos.field_72450_a, this.pos.field_72448_b - vertex.pos.field_72448_b, this.pos.field_72449_c - vertex.pos.field_72449_c, this.uv.field_189982_i - vertex.uv.field_189982_i, this.uv.field_189983_j - vertex.uv.field_189983_j);
        }

        protected Vertex scale(float scale) {
            return new Vertex(this.pos.field_72450_a * (double)scale, this.pos.field_72448_b * (double)scale, this.pos.field_72449_c * (double)scale, this.uv.field_189982_i * scale, this.uv.field_189983_j * scale);
        }

        protected Vertex scaleUVs(float u, float v) {
            return new Vertex(this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, this.uv.field_189982_i * u, this.uv.field_189983_j * v);
        }
    }
}

