/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleBeam
extends Particle {
    protected Vec3d end = new Vec3d(0.0, 0.0, 0.0);
    protected float prevTexUOffset = 0.0f;
    protected float texUOffset = 0.0f;
    protected float texUScale = 1.0f;

    public ParticleBeam(World worldIn, double x, double y, double z, double vx, double vy, double vz, Vec3d end) {
        super(worldIn, x, y, z, vx, vy, vz);
        this.end = end;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float rx = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float ry = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float rz = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        float renderScale = 0.1f * this.field_70544_f;
        int i = this.func_189214_a(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        float texUOffset = this.prevTexUOffset + (this.texUOffset - this.prevTexUOffset) * partialTicks;
        ParticleBeam.buildBeam(rx, ry, rz, this.end, renderScale, texUOffset, this.texUScale, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ, (vx, vy, vz, u, v) -> buffer.func_181662_b(vx, vy, vz).func_187315_a(u, v).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d());
    }

    public static void buildBeam(double rx, double ry, double rz, Vec3d end, float scale, float texUOffset, float texUScale, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ, BeamVertexConsumer consumer) {
        double len = end.func_72433_c();
        Vec3d v1 = new Vec3d((double)(-rotationX - rotationXY), (double)(-rotationZ), (double)(-rotationYZ - rotationXZ));
        Vec3d v2 = new Vec3d((double)(-rotationX + rotationXY), (double)rotationZ, (double)(-rotationYZ + rotationXZ));
        Vec3d facing = v1.func_72431_c(v2);
        Vec3d perpendicularDir = end.func_72431_c(facing).func_72432_b();
        if (perpendicularDir.func_72433_c() < 1.0E-4) {
            facing = v2.func_178788_d(v1).func_72432_b();
            perpendicularDir = end.func_72431_c(facing).func_72432_b();
        }
        Vec3d perpendicularDir2 = perpendicularDir.func_72431_c(end).func_72432_b();
        Vec3d[] offsets = new Vec3d[]{perpendicularDir.func_186678_a((double)scale), perpendicularDir.func_186678_a((double)(-scale))};
        Vec3d[] offsets2 = new Vec3d[]{perpendicularDir2.func_186678_a((double)scale), perpendicularDir2.func_186678_a((double)(-scale))};
        double x1 = rx;
        double y1 = ry;
        double z1 = rz;
        double x2 = rx + end.field_72450_a;
        double y2 = ry + end.field_72448_b;
        double z2 = rz + end.field_72449_c;
        consumer.emit(x2 + offsets[0].field_72450_a, y2 + offsets[0].field_72448_b, z2 + offsets[0].field_72449_c, (double)texUOffset + len / (0.2 * (double)texUScale), 0.0);
        consumer.emit(x2 + offsets[1].field_72450_a, y2 + offsets[1].field_72448_b, z2 + offsets[1].field_72449_c, (double)texUOffset + len / (0.2 * (double)texUScale), 1.0);
        consumer.emit(x1 + offsets[1].field_72450_a, y1 + offsets[1].field_72448_b, z1 + offsets[1].field_72449_c, texUOffset, 1.0);
        consumer.emit(x1 + offsets[0].field_72450_a, y1 + offsets[0].field_72448_b, z1 + offsets[0].field_72449_c, texUOffset, 0.0);
        consumer.emit(x2 + offsets2[0].field_72450_a, y2 + offsets2[0].field_72448_b, z2 + offsets2[0].field_72449_c, (double)texUOffset + len / (0.2 * (double)texUScale), 0.0);
        consumer.emit(x2 + offsets2[1].field_72450_a, y2 + offsets2[1].field_72448_b, z2 + offsets2[1].field_72449_c, (double)texUOffset + len / (0.2 * (double)texUScale), 1.0);
        consumer.emit(x1 + offsets2[1].field_72450_a, y1 + offsets2[1].field_72448_b, z1 + offsets2[1].field_72449_c, texUOffset, 1.0);
        consumer.emit(x1 + offsets2[0].field_72450_a, y1 + offsets2[0].field_72448_b, z1 + offsets2[0].field_72449_c, texUOffset, 0.0);
    }

    public void func_189213_a() {
        super.func_189213_a();
        this.prevTexUOffset = this.texUOffset;
    }

    @FunctionalInterface
    public static interface BeamVertexConsumer {
        public void emit(double var1, double var3, double var5, double var7, double var9);
    }
}

