/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.shader.postprocessing;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.vector.Matrix4f;

public abstract class PostProcessingEffect<T extends PostProcessingEffect<?>> {
    private float cr;
    private float cg;
    private float cb;
    private float ca;
    private PostProcessingEffect<?>[] stages;
    private static final FloatBuffer TEXEL_SIZE_BUFFER = GLAllocation.func_74529_h((int)2);
    private static final FloatBuffer CLEAR_COLOR_BUFFER = GLAllocation.func_74529_h((int)16);
    private static final FloatBuffer MATRIX4F_BUFFER = GLAllocation.func_74529_h((int)16);
    private static final FloatBuffer FLOAT_BUFFER_1 = GLAllocation.func_74529_h((int)1);
    private static final FloatBuffer FLOAT_BUFFER_2 = GLAllocation.func_74529_h((int)2);
    private static final FloatBuffer FLOAT_BUFFER_3 = GLAllocation.func_74529_h((int)3);
    private static final FloatBuffer FLOAT_BUFFER_4 = GLAllocation.func_74529_h((int)4);
    private static final IntBuffer INT_BUFFER_1 = GLAllocation.func_74527_f((int)1);
    private static final IntBuffer INT_BUFFER_2 = GLAllocation.func_74527_f((int)2);
    private static final IntBuffer INT_BUFFER_3 = GLAllocation.func_74527_f((int)3);
    private static final IntBuffer INT_BUFFER_4 = GLAllocation.func_74527_f((int)4);
    private int shaderProgramID = -1;
    private int diffuseSamplerUniformID = -1;
    private int texelSizeUniformID = -1;
    private boolean initialized = false;

    public final T init() {
        if (!this.initialized) {
            this.initShaders();
            this.stages = this.getStages();
            if (this.stages != null && this.stages.length > 0) {
                for (PostProcessingEffect<?> stage : this.stages) {
                    stage.init();
                }
            }
            if (!this.initEffect() || this.shaderProgramID < 0) {
                throw new RuntimeException("Couldn't initialize shaders for post processing effect: " + this.toString());
            }
            this.initialized = true;
        }
        return (T)this;
    }

    public final T setBackgroundColor(float r, float g, float b, float a) {
        this.cr = r;
        this.cg = g;
        this.cb = b;
        this.ca = a;
        return (T)this;
    }

    public final int getShaderProgram() {
        return this.shaderProgramID;
    }

    public final void delete() {
        if (this.shaderProgramID > 0) {
            OpenGlHelper.func_153187_e((int)this.shaderProgramID);
        }
        if (this.stages != null && this.stages.length > 0) {
            for (PostProcessingEffect<?> stage : this.stages) {
                stage.delete();
            }
        }
        this.deleteEffect();
    }

    public EffectBuilder<T> create(Framebuffer dst) {
        return new EffectBuilder(this, dst);
    }

    private final void render(float partialTicks, int src, Framebuffer dst, Framebuffer blitBuffer, Framebuffer prev, double renderWidth, double renderHeight, boolean restore, boolean mirrorX, boolean mirrorY, boolean clearDepth, boolean clearColor) {
        if (this.shaderProgramID == -1 || dst == null) {
            return;
        }
        Framebuffer intermediateDst = dst;
        if (src == dst.field_147617_g) {
            intermediateDst = blitBuffer;
        }
        intermediateDst.func_147610_a(true);
        int prevShaderProgram = 0;
        if (restore) {
            GL11.glPushAttrib((int)7072);
            prevShaderProgram = GL11.glGetInteger((int)35725);
            GL11.glGetFloat((int)3106, (FloatBuffer)CLEAR_COLOR_BUFFER);
            GlStateManager.func_179094_E();
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179094_E();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179094_E();
        }
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)intermediateDst.field_147621_c, (double)intermediateDst.field_147618_d, (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        if (clearDepth) {
            GlStateManager.func_179086_m((int)256);
        }
        if (clearColor) {
            GlStateManager.func_179082_a((float)this.cr, (float)this.cg, (float)this.cb, (float)this.ca);
            GlStateManager.func_179086_m((int)16384);
        }
        OpenGlHelper.func_153161_d((int)this.shaderProgramID);
        if (this.diffuseSamplerUniformID >= 0 && src >= 0) {
            this.uploadSampler(this.diffuseSamplerUniformID, src, 0);
        }
        if (this.texelSizeUniformID >= 0) {
            TEXEL_SIZE_BUFFER.position(0);
            TEXEL_SIZE_BUFFER.put(1.0f / (float)intermediateDst.field_147621_c);
            TEXEL_SIZE_BUFFER.put(1.0f / (float)intermediateDst.field_147618_d);
            TEXEL_SIZE_BUFFER.flip();
            OpenGlHelper.func_153168_a((int)this.texelSizeUniformID, (FloatBuffer)TEXEL_SIZE_BUFFER);
        }
        this.uploadUniforms(partialTicks);
        GlStateManager.func_179098_w();
        GlStateManager.func_187447_r((int)4);
        GlStateManager.func_187426_b((float)(mirrorX ? 1.0f : 0.0f), (float)(mirrorY ? 1.0f : 0.0f));
        GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187426_b((float)(mirrorX ? 1.0f : 0.0f), (float)(mirrorY ? 0.0f : 1.0f));
        GlStateManager.func_187435_e((float)0.0f, (float)((float)renderHeight), (float)0.0f);
        GlStateManager.func_187426_b((float)(mirrorX ? 0.0f : 1.0f), (float)(mirrorY ? 0.0f : 1.0f));
        GlStateManager.func_187435_e((float)((float)renderWidth), (float)((float)renderHeight), (float)0.0f);
        GlStateManager.func_187426_b((float)(mirrorX ? 0.0f : 1.0f), (float)(mirrorY ? 0.0f : 1.0f));
        GlStateManager.func_187435_e((float)((float)renderWidth), (float)((float)renderHeight), (float)0.0f);
        GlStateManager.func_187426_b((float)(mirrorX ? 0.0f : 1.0f), (float)(mirrorY ? 1.0f : 0.0f));
        GlStateManager.func_187435_e((float)((float)renderWidth), (float)0.0f, (float)0.0f);
        GlStateManager.func_187426_b((float)(mirrorX ? 1.0f : 0.0f), (float)(mirrorY ? 1.0f : 0.0f));
        GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187437_J();
        if (blitBuffer != null && this.stages != null && this.stages.length > 0) {
            for (PostProcessingEffect<?> stage : this.stages) {
                super.render(partialTicks, intermediateDst.field_147617_g, blitBuffer, intermediateDst, null, renderWidth, renderHeight, false, false, false, clearDepth, clearColor);
                intermediateDst.func_147610_a(true);
                GlStateManager.func_179098_w();
                GlStateManager.func_187447_r((int)4);
                GlStateManager.func_187426_b((float)(mirrorX ? 1.0f : 0.0f), (float)(mirrorY ? 1.0f : 0.0f));
                GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_187426_b((float)(mirrorX ? 1.0f : 0.0f), (float)(mirrorY ? 0.0f : 1.0f));
                GlStateManager.func_187435_e((float)0.0f, (float)((float)renderHeight), (float)0.0f);
                GlStateManager.func_187426_b((float)(mirrorX ? 0.0f : 1.0f), (float)(mirrorY ? 0.0f : 1.0f));
                GlStateManager.func_187435_e((float)((float)renderWidth), (float)((float)renderHeight), (float)0.0f);
                GlStateManager.func_187426_b((float)(mirrorX ? 0.0f : 1.0f), (float)(mirrorY ? 0.0f : 1.0f));
                GlStateManager.func_187435_e((float)((float)renderWidth), (float)((float)renderHeight), (float)0.0f);
                GlStateManager.func_187426_b((float)(mirrorX ? 0.0f : 1.0f), (float)(mirrorY ? 1.0f : 0.0f));
                GlStateManager.func_187435_e((float)((float)renderWidth), (float)0.0f, (float)0.0f);
                GlStateManager.func_187426_b((float)(mirrorX ? 1.0f : 0.0f), (float)(mirrorY ? 1.0f : 0.0f));
                GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_187437_J();
            }
        }
        OpenGlHelper.func_153161_d((int)0);
        if (src == dst.field_147617_g) {
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)dst.field_147621_c, (double)dst.field_147618_d, (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
            dst.func_147610_a(true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179144_i((int)intermediateDst.field_147617_g);
            GlStateManager.func_187447_r((int)4);
            GlStateManager.func_187426_b((float)0.0f, (float)0.0f);
            GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_187426_b((float)0.0f, (float)1.0f);
            GlStateManager.func_187435_e((float)0.0f, (float)((float)renderHeight), (float)0.0f);
            GlStateManager.func_187426_b((float)1.0f, (float)1.0f);
            GlStateManager.func_187435_e((float)((float)renderWidth), (float)((float)renderHeight), (float)0.0f);
            GlStateManager.func_187426_b((float)1.0f, (float)1.0f);
            GlStateManager.func_187435_e((float)((float)renderWidth), (float)((float)renderHeight), (float)0.0f);
            GlStateManager.func_187426_b((float)1.0f, (float)0.0f);
            GlStateManager.func_187435_e((float)((float)renderWidth), (float)0.0f, (float)0.0f);
            GlStateManager.func_187426_b((float)0.0f, (float)0.0f);
            GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_187437_J();
        }
        OpenGlHelper.func_153161_d((int)prevShaderProgram);
        this.postRender(partialTicks);
        if (restore) {
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179121_F();
            GlStateManager.func_179099_b();
            GlStateManager.func_179082_a((float)CLEAR_COLOR_BUFFER.get(0), (float)CLEAR_COLOR_BUFFER.get(1), (float)CLEAR_COLOR_BUFFER.get(2), (float)CLEAR_COLOR_BUFFER.get(3));
            GlStateManager.func_179121_F();
            if (prev != null) {
                prev.func_147610_a(true);
            }
        }
    }

    private void initShaders() {
        if (this.shaderProgramID == -1) {
            this.shaderProgramID = OpenGlHelper.func_153183_d();
            int vertexShaderID = -1;
            int fragmentShaderID = -1;
            ResourceLocation[] shaderLocations = this.getShaders();
            try {
                String[] shaders = new String[2];
                for (int i = 0; i < 2; ++i) {
                    StringWriter strBuf = new StringWriter();
                    IOUtils.copy((InputStream)Minecraft.func_71410_x().func_110442_L().func_110536_a(shaderLocations[i]).func_110527_b(), (Writer)strBuf, (String)"UTF-8");
                    shaders[i] = strBuf.toString();
                }
                vertexShaderID = PostProcessingEffect.createShader(shaders[0], 35633);
                fragmentShaderID = PostProcessingEffect.createShader(shaders[1], 35632);
            }
            catch (Exception ex) {
                this.shaderProgramID = -1;
                vertexShaderID = -1;
                fragmentShaderID = -1;
                throw new RuntimeException(String.format("Error creating shaders %s and %s", shaderLocations[0], shaderLocations[1]), ex);
            }
            if (this.shaderProgramID != -1 && vertexShaderID != -1 && fragmentShaderID != -1) {
                OpenGlHelper.func_153178_b((int)this.shaderProgramID, (int)vertexShaderID);
                OpenGlHelper.func_153178_b((int)this.shaderProgramID, (int)fragmentShaderID);
                OpenGlHelper.func_153179_f((int)this.shaderProgramID);
                if (OpenGlHelper.func_153175_a((int)this.shaderProgramID, (int)35714) == 0) {
                    throw new RuntimeException(String.format("Error creating shaders %s and %s: %s", shaderLocations[0], shaderLocations[1], PostProcessingEffect.getLogInfoProgram(this.shaderProgramID)));
                }
                GL20.glValidateProgram((int)this.shaderProgramID);
                if (OpenGlHelper.func_153175_a((int)this.shaderProgramID, (int)35715) == 0) {
                    throw new RuntimeException(String.format("Error creating shaders %s and %s: %s", shaderLocations[0], shaderLocations[1], PostProcessingEffect.getLogInfoProgram(this.shaderProgramID)));
                }
                OpenGlHelper.func_153180_a((int)vertexShaderID);
                OpenGlHelper.func_153180_a((int)fragmentShaderID);
                this.diffuseSamplerUniformID = OpenGlHelper.func_153194_a((int)this.shaderProgramID, (CharSequence)"s_diffuse");
                this.texelSizeUniformID = OpenGlHelper.func_153194_a((int)this.shaderProgramID, (CharSequence)"u_oneTexel");
                OpenGlHelper.func_153161_d((int)0);
            } else {
                if (vertexShaderID != -1) {
                    OpenGlHelper.func_153180_a((int)vertexShaderID);
                }
                if (fragmentShaderID != 1) {
                    OpenGlHelper.func_153180_a((int)fragmentShaderID);
                }
                if (this.shaderProgramID != -1) {
                    OpenGlHelper.func_153187_e((int)this.shaderProgramID);
                }
            }
        }
    }

    private static int createShader(String shaderCode, int shaderType) throws Exception {
        int shader = 0;
        try {
            shader = OpenGlHelper.func_153195_b((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            byte[] shaderCodeBytes = shaderCode.getBytes();
            ByteBuffer shaderCodeByteBuffer = BufferUtils.createByteBuffer((int)shaderCodeBytes.length);
            shaderCodeByteBuffer.put(shaderCodeBytes);
            shaderCodeByteBuffer.position(0);
            OpenGlHelper.func_153169_a((int)shader, (ByteBuffer)shaderCodeByteBuffer);
            OpenGlHelper.func_153170_c((int)shader);
            if (OpenGlHelper.func_153157_c((int)shader, (int)35713) == 0) {
                String shaderTypeName = shaderType == 35633 ? "vertex" : (shaderType == 35632 ? "fragment" : "");
                throw new RuntimeException("Error creating " + shaderTypeName + " shader: " + PostProcessingEffect.getLogInfoShader(shader));
            }
            return shader;
        }
        catch (Exception exc) {
            OpenGlHelper.func_153180_a((int)shader);
            throw exc;
        }
    }

    private static String getLogInfoShader(int obj) {
        return OpenGlHelper.func_153158_d((int)obj, (int)OpenGlHelper.func_153157_c((int)obj, (int)35716));
    }

    private static String getLogInfoProgram(int obj) {
        return OpenGlHelper.func_153166_e((int)obj, (int)OpenGlHelper.func_153175_a((int)obj, (int)35716));
    }

    protected abstract ResourceLocation[] getShaders();

    protected void uploadUniforms(float partialTicks) {
    }

    protected PostProcessingEffect<?>[] getStages() {
        return null;
    }

    protected void deleteEffect() {
    }

    protected boolean initEffect() {
        return true;
    }

    protected void postRender(float partialTicks) {
    }

    protected final void uploadFloat(int uniform, float ... values) {
        if (uniform >= 0) {
            switch (values.length) {
                default: {
                    this.setFloats(FLOAT_BUFFER_1, values);
                    OpenGlHelper.func_153168_a((int)uniform, (FloatBuffer)FLOAT_BUFFER_1);
                    break;
                }
                case 2: {
                    this.setFloats(FLOAT_BUFFER_2, values);
                    OpenGlHelper.func_153177_b((int)uniform, (FloatBuffer)FLOAT_BUFFER_2);
                    break;
                }
                case 3: {
                    this.setFloats(FLOAT_BUFFER_3, values);
                    OpenGlHelper.func_153191_c((int)uniform, (FloatBuffer)FLOAT_BUFFER_3);
                    break;
                }
                case 4: {
                    this.setFloats(FLOAT_BUFFER_4, values);
                    OpenGlHelper.func_153159_d((int)uniform, (FloatBuffer)FLOAT_BUFFER_4);
                }
            }
        }
    }

    private final void setFloats(FloatBuffer buffer, float[] values) {
        buffer.position(0);
        for (int i = 0; i < values.length; ++i) {
            buffer.put(values[i]);
        }
        buffer.flip();
    }

    protected final void uploadInt(int uniform, int ... values) {
        if (uniform >= 0) {
            switch (values.length) {
                default: {
                    this.setInts(INT_BUFFER_1, values);
                    OpenGlHelper.func_153181_a((int)uniform, (IntBuffer)INT_BUFFER_1);
                    break;
                }
                case 2: {
                    this.setInts(INT_BUFFER_2, values);
                    OpenGlHelper.func_153182_b((int)uniform, (IntBuffer)INT_BUFFER_2);
                    break;
                }
                case 3: {
                    this.setInts(INT_BUFFER_3, values);
                    OpenGlHelper.func_153192_c((int)uniform, (IntBuffer)INT_BUFFER_3);
                    break;
                }
                case 4: {
                    this.setInts(INT_BUFFER_4, values);
                    OpenGlHelper.func_153162_d((int)uniform, (IntBuffer)INT_BUFFER_4);
                }
            }
        }
    }

    private final void setInts(IntBuffer buffer, int[] values) {
        buffer.position(0);
        for (int i = 0; i < values.length; ++i) {
            buffer.put(values[i]);
        }
        buffer.flip();
    }

    protected final void uploadIntArray(int uniform, IntBuffer buffer) {
        if (uniform >= 0) {
            OpenGlHelper.func_153181_a((int)uniform, (IntBuffer)buffer);
        }
    }

    protected final void uploadFloatArray(int uniform, FloatBuffer buffer) {
        if (uniform >= 0) {
            OpenGlHelper.func_153168_a((int)uniform, (FloatBuffer)buffer);
        }
    }

    protected final void uploadSampler(int uniform, int texture, int textureUnit) {
        if (uniform >= 0 && textureUnit >= 0) {
            GlStateManager.func_179138_g((int)(OpenGlHelper.field_77478_a + textureUnit));
            GlStateManager.func_179098_w();
            GlStateManager.func_179144_i((int)texture);
            OpenGlHelper.func_153163_f((int)uniform, (int)textureUnit);
            GlStateManager.func_179090_x();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        }
    }

    protected final void uploadSampler(int uniform, ResourceLocation texture, int textureUnit) {
        if (uniform >= 0 && textureUnit >= 0) {
            GlStateManager.func_179138_g((int)(OpenGlHelper.field_77478_a + textureUnit));
            GlStateManager.func_179098_w();
            TextureManager manager = Minecraft.func_71410_x().func_110434_K();
            manager.func_110577_a(texture);
            OpenGlHelper.func_153163_f((int)uniform, (int)textureUnit);
            GlStateManager.func_179090_x();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        }
    }

    protected final void uploadMatrix4f(int uniform, Matrix4f matrix) {
        if (uniform >= 0) {
            MATRIX4F_BUFFER.position(0);
            MATRIX4F_BUFFER.put(0, matrix.m00);
            MATRIX4F_BUFFER.put(1, matrix.m01);
            MATRIX4F_BUFFER.put(2, matrix.m02);
            MATRIX4F_BUFFER.put(3, matrix.m03);
            MATRIX4F_BUFFER.put(4, matrix.m10);
            MATRIX4F_BUFFER.put(5, matrix.m11);
            MATRIX4F_BUFFER.put(6, matrix.m12);
            MATRIX4F_BUFFER.put(7, matrix.m13);
            MATRIX4F_BUFFER.put(8, matrix.m20);
            MATRIX4F_BUFFER.put(9, matrix.m21);
            MATRIX4F_BUFFER.put(10, matrix.m22);
            MATRIX4F_BUFFER.put(11, matrix.m23);
            MATRIX4F_BUFFER.put(12, matrix.m30);
            MATRIX4F_BUFFER.put(13, matrix.m31);
            MATRIX4F_BUFFER.put(14, matrix.m32);
            MATRIX4F_BUFFER.put(15, matrix.m33);
            OpenGlHelper.func_153160_c((int)uniform, (boolean)true, (FloatBuffer)MATRIX4F_BUFFER);
        }
    }

    protected final int getUniform(String name) {
        return OpenGlHelper.func_153194_a((int)this.getShaderProgram(), (CharSequence)name);
    }

    public static final class EffectBuilder<T extends PostProcessingEffect<?>> {
        private final PostProcessingEffect<T> effect;
        private final Framebuffer dst;
        private int src = -1;
        private Framebuffer blitFrfamebuffer = null;
        private Framebuffer prevFramebuffer = null;
        private double renderWidth = -1.0;
        private double renderHeight = -1.0;
        private boolean restore = true;
        private boolean mirrorX = false;
        private boolean mirrorY = false;
        private boolean clearDepth = true;
        private boolean clearColor = true;

        protected EffectBuilder(PostProcessingEffect<T> effect, Framebuffer dst) {
            this.effect = effect;
            this.dst = dst;
        }

        public EffectBuilder<T> setSource(int src) {
            this.src = src;
            return this;
        }

        public EffectBuilder<T> setBlitFramebuffer(Framebuffer blitFramebuffer) {
            this.blitFrfamebuffer = blitFramebuffer;
            return this;
        }

        public EffectBuilder<T> setPreviousFramebuffer(Framebuffer prevFramebuffer) {
            this.prevFramebuffer = prevFramebuffer;
            return this;
        }

        public EffectBuilder<T> setRenderDimensions(double renderWidth, double renderHeight) {
            this.renderWidth = renderWidth;
            this.renderHeight = renderHeight;
            return this;
        }

        public EffectBuilder<T> setRestoreGlState(boolean restore) {
            this.restore = restore;
            return this;
        }

        public EffectBuilder<T> setMirrorX(boolean mirror) {
            this.mirrorX = mirror;
            return this;
        }

        public EffectBuilder<T> setMirrorY(boolean mirror) {
            this.mirrorY = mirror;
            return this;
        }

        public EffectBuilder<T> setClearDepth(boolean clearDepth) {
            this.clearDepth = clearDepth;
            return this;
        }

        public EffectBuilder<T> setClearColor(boolean clearColor) {
            this.clearColor = clearColor;
            return this;
        }

        public void render(float partialTicks) {
            double renderWidth = this.renderWidth;
            double renderHeight = this.renderHeight;
            if (renderWidth < 0.0 || renderHeight < 0.0) {
                renderWidth = this.dst.field_147621_c;
                renderHeight = this.dst.field_147618_d;
            }
            ((PostProcessingEffect)this.effect).render(partialTicks, this.src, this.dst, this.blitFrfamebuffer, this.prevFramebuffer, renderWidth, renderHeight, this.restore, this.mirrorX, this.mirrorY, this.clearDepth, this.clearColor);
        }
    }
}

