/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.shader.postprocessing;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import thebetweenlands.client.handler.FogHandler;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.shader.DepthBuffer;
import thebetweenlands.client.render.shader.GeometryBuffer;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ResizableFramebuffer;
import thebetweenlands.client.render.shader.postprocessing.GodRay;
import thebetweenlands.client.render.shader.postprocessing.GroundFog;
import thebetweenlands.client.render.shader.postprocessing.OcclusionExtractor;
import thebetweenlands.client.render.shader.postprocessing.PostProcessingEffect;
import thebetweenlands.client.render.shader.postprocessing.Starfield;
import thebetweenlands.client.render.shader.postprocessing.Swirl;
import thebetweenlands.client.render.shader.postprocessing.Warp;
import thebetweenlands.client.render.sky.BLSkyRenderer;
import thebetweenlands.client.render.sprite.GLTextureObjectWrapper;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.entity.mobs.EntityGasCloud;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.util.GLUProjection;
import thebetweenlands.util.RenderUtils;

public class WorldShader
extends PostProcessingEffect<WorldShader> {
    public static final ResourceLocation WORLD_DEPTH_TEXTURE = new ResourceLocation("thebetweenlands", "world_depth");
    public static final ResourceLocation REPELLER_DIFFUSE_TEXTURE = new ResourceLocation("thebetweenlands", "repeller_diffuse");
    public static final ResourceLocation REPELLER_DEPTH_TEXTURE = new ResourceLocation("thebetweenlands", "repeller_depth");
    public static final ResourceLocation GAS_PARTICLES_DIFFUSE_TEXTURE = new ResourceLocation("thebetweenlands", "gas_particles_diffuse");
    public static final ResourceLocation GAS_PARTICLES_DEPTH_TEXTURE = new ResourceLocation("thebetweenlands", "gas_particles_depth");
    public static final ResourceLocation CLIP_PLANE_DIFFUSE_TEXTURE = new ResourceLocation("thebetweenlands", "clip_plane_diffuse");
    public static final ResourceLocation CLIP_PLANE_DEPTH_TEXTURE = new ResourceLocation("thebetweenlands", "clip_plane_depth");
    public static final ResourceLocation GAS_PARTICLE_TEXTURE = new ResourceLocation("thebetweenlands", "gas_particle");
    private DepthBuffer depthBuffer;
    private ResizableFramebuffer blitBuffer;
    private ResizableFramebuffer occlusionBuffer;
    private GeometryBuffer repellerShieldBuffer;
    private GeometryBuffer gasParticlesBuffer;
    private static final FloatBuffer MODELVIEW = GLAllocation.func_74529_h((int)16);
    private static final FloatBuffer PROJECTION = GLAllocation.func_74529_h((int)16);
    private Matrix4f invertedModelviewProjectionMatrix;
    private Matrix4f modelviewProjectionMatrix;
    private Matrix4f modelviewMatrix;
    private Matrix4f projectionMatrix;
    public static final int MAX_LIGHT_SOURCES_PER_PASS = 32;
    private List<LightSource> lightSources = new ArrayList<LightSource>();
    private List<GroundFog.GroundFogVolume> groundFogVolumes = new ArrayList<GroundFog.GroundFogVolume>();
    private int depthUniformID = -1;
    private int repellerDiffuseUniformID = -1;
    private int repellerDepthUniformID = -1;
    private int gasParticlesDiffuseUniformID = -1;
    private int gasParticlesDepthUniformID = -1;
    private int invMVPUniformID = -1;
    private int fogModeUniformID = -1;
    private int[] lightSourcePositionUniformIDs = new int[32];
    private int[] lightSourceColorUniformIDs = new int[32];
    private int[] lightSourceRadiusUniformIDs = new int[32];
    private int lightSourceAmountUniformID = -1;
    private int msTimeUniformID = -1;
    private int worldTimeUniformID = -1;
    private int renderPosUniformID = -1;
    private int viewPosUniformID = -1;
    private Framebuffer gasTextureBaseFramebuffer = null;
    private Framebuffer gasTextureFramebuffer = null;
    private Framebuffer starfieldTextureFramebuffer = null;
    private Warp gasWarpEffect = null;
    private Starfield starfieldEffect = null;
    private OcclusionExtractor occlusionExtractor = null;
    private GodRay godRayEffect = null;
    private Swirl swirlEffect = null;
    private GroundFog groundFogEffect = null;
    private float swirlAngle = 0.0f;
    private float lastSwirlAngle = 0.0f;
    private int currentRenderPass = 0;
    private static final Comparator<LightSource> LIGHT_SOURCE_SORTER = new Comparator<LightSource>(){

        @Override
        public int compare(LightSource o1, LightSource o2) {
            double d2;
            double dx1 = o1.x - Minecraft.func_71410_x().func_175598_ae().field_78730_l;
            double dy1 = o1.y - Minecraft.func_71410_x().func_175598_ae().field_78731_m;
            double dz1 = o1.z - Minecraft.func_71410_x().func_175598_ae().field_78728_n;
            double dx2 = o2.x - Minecraft.func_71410_x().func_175598_ae().field_78730_l;
            double dy2 = o2.y - Minecraft.func_71410_x().func_175598_ae().field_78731_m;
            double dz2 = o2.z - Minecraft.func_71410_x().func_175598_ae().field_78728_n;
            double d1 = Math.sqrt(dx1 * dx1 + dy1 * dy1 + dz1 * dz1);
            if (d1 > (d2 = Math.sqrt(dx2 * dx2 + dy2 * dy2 + dz2 * dz2))) {
                return 1;
            }
            if (d1 < d2) {
                return -1;
            }
            return 0;
        }
    };

    @Override
    protected ResourceLocation[] getShaders() {
        return new ResourceLocation[]{new ResourceLocation("thebetweenlands:shaders/postprocessing/world/world.vsh"), new ResourceLocation("thebetweenlands:shaders/postprocessing/world/world.fsh")};
    }

    @Override
    protected void deleteEffect() {
        if (this.depthBuffer != null) {
            this.depthBuffer.deleteBuffer();
        }
        if (this.blitBuffer != null) {
            this.blitBuffer.delete();
        }
        if (this.occlusionBuffer != null) {
            this.occlusionBuffer.delete();
        }
        if (this.repellerShieldBuffer != null) {
            this.repellerShieldBuffer.deleteBuffers();
        }
        if (this.gasParticlesBuffer != null) {
            this.gasParticlesBuffer.deleteBuffers();
        }
        if (this.gasTextureBaseFramebuffer != null) {
            this.gasTextureBaseFramebuffer.func_147608_a();
        }
        if (this.gasTextureFramebuffer != null) {
            this.gasTextureFramebuffer.func_147608_a();
        }
        if (this.starfieldTextureFramebuffer != null) {
            this.starfieldTextureFramebuffer.func_147608_a();
        }
        if (this.gasWarpEffect != null) {
            this.gasWarpEffect.delete();
        }
        if (this.starfieldEffect != null) {
            this.starfieldEffect.delete();
        }
        if (this.occlusionExtractor != null) {
            this.occlusionExtractor.delete();
        }
        if (this.godRayEffect != null) {
            this.godRayEffect.delete();
        }
        if (this.groundFogEffect != null) {
            this.groundFogEffect.delete();
        }
    }

    @Override
    protected boolean initEffect() {
        int i;
        this.depthUniformID = this.getUniform("s_diffuse_depth");
        this.repellerDiffuseUniformID = this.getUniform("s_repellerShield");
        this.repellerDepthUniformID = this.getUniform("s_repellerShield_depth");
        this.gasParticlesDiffuseUniformID = this.getUniform("s_gasParticles");
        this.gasParticlesDepthUniformID = this.getUniform("s_gasParticles_depth");
        this.invMVPUniformID = this.getUniform("u_INVMVP");
        this.fogModeUniformID = this.getUniform("u_fogMode");
        this.msTimeUniformID = this.getUniform("u_msTime");
        this.worldTimeUniformID = this.getUniform("u_worldTime");
        this.viewPosUniformID = this.getUniform("u_viewPos");
        this.renderPosUniformID = this.getUniform("u_renderPos");
        for (i = 0; i < 32; ++i) {
            this.lightSourcePositionUniformIDs[i] = this.getUniform("u_lightSources[" + i + "].position");
        }
        for (i = 0; i < 32; ++i) {
            this.lightSourceColorUniformIDs[i] = this.getUniform("u_lightSources[" + i + "].color");
        }
        for (i = 0; i < 32; ++i) {
            this.lightSourceRadiusUniformIDs[i] = this.getUniform("u_lightSources[" + i + "].radius");
        }
        this.lightSourceAmountUniformID = this.getUniform("u_lightSourcesAmount");
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        this.depthBuffer = new DepthBuffer(textureManager, WORLD_DEPTH_TEXTURE);
        this.blitBuffer = new ResizableFramebuffer(false);
        this.occlusionBuffer = new ResizableFramebuffer(false);
        this.repellerShieldBuffer = new GeometryBuffer(textureManager, REPELLER_DIFFUSE_TEXTURE, REPELLER_DEPTH_TEXTURE, true);
        this.gasParticlesBuffer = new GeometryBuffer(textureManager, GAS_PARTICLES_DIFFUSE_TEXTURE, GAS_PARTICLES_DEPTH_TEXTURE, true);
        this.gasTextureFramebuffer = new Framebuffer(64, 64, false);
        Minecraft.func_71410_x().func_110434_K().func_110579_a(GAS_PARTICLE_TEXTURE, (ITextureObject)new GLTextureObjectWrapper(this.gasTextureFramebuffer.field_147617_g));
        this.gasTextureBaseFramebuffer = new Framebuffer(64, 64, false);
        this.gasWarpEffect = (Warp)new Warp().setTimeScale(4.0E-5f).setScale(40.0f).setMultiplier(3.55f).init();
        this.starfieldTextureFramebuffer = new Framebuffer(BetweenlandsConfig.RENDERING.skyResolution, BetweenlandsConfig.RENDERING.skyResolution, false);
        this.starfieldEffect = (Starfield)new Starfield(true).init();
        this.occlusionExtractor = (OcclusionExtractor)new OcclusionExtractor().init();
        this.godRayEffect = (GodRay)new GodRay().init();
        this.swirlEffect = (Swirl)new Swirl().init();
        this.groundFogEffect = ((GroundFog)new GroundFog().init()).setFogVolumes(this.groundFogVolumes);
        return true;
    }

    @Override
    protected void uploadUniforms(float partialTicks) {
        this.uploadSampler(this.depthUniformID, this.depthBuffer.func_110552_b(), 1);
        this.uploadSampler(this.repellerDiffuseUniformID, this.repellerShieldBuffer.getDiffuseTexture(), 2);
        this.uploadSampler(this.repellerDepthUniformID, this.repellerShieldBuffer.getDepthTexture(), 3);
        this.uploadSampler(this.gasParticlesDiffuseUniformID, this.gasParticlesBuffer.getDiffuseTexture(), 4);
        this.uploadSampler(this.gasParticlesDepthUniformID, this.gasParticlesBuffer.getDepthTexture(), 5);
        this.uploadMatrix4f(this.invMVPUniformID, this.invertedModelviewProjectionMatrix);
        this.uploadInt(this.fogModeUniformID, FogHandler.getCurrentFogMode());
        Collections.sort(this.lightSources, LIGHT_SOURCE_SORTER);
        int renderedLightSources = Math.min(32, this.lightSources.size() - this.currentRenderPass * 32);
        double renderPosX = Minecraft.func_71410_x().func_175598_ae().field_78730_l;
        double renderPosY = Minecraft.func_71410_x().func_175598_ae().field_78731_m;
        double renderPosZ = Minecraft.func_71410_x().func_175598_ae().field_78728_n;
        for (int i = 0; i < renderedLightSources; ++i) {
            LightSource lightSource = this.lightSources.get(this.currentRenderPass * 32 + i);
            this.uploadFloat(this.lightSourcePositionUniformIDs[i], (float)(lightSource.x - renderPosX), (float)(lightSource.y - renderPosY), (float)(lightSource.z - renderPosZ));
            this.uploadFloat(this.lightSourceColorUniformIDs[i], lightSource.r, lightSource.g, lightSource.b);
            this.uploadFloat(this.lightSourceRadiusUniformIDs[i], lightSource.radius);
        }
        this.uploadInt(this.lightSourceAmountUniformID, renderedLightSources);
        this.uploadFloat(this.msTimeUniformID, (float)System.nanoTime() / 1000000.0f);
        this.uploadFloat(this.worldTimeUniformID, (float)RenderUtils.getRenderTickCounter() + partialTicks);
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        Vec3d camPos = renderView != null ? ActiveRenderInfo.func_178806_a((Entity)Minecraft.func_71410_x().func_175606_aa(), (double)partialTicks) : Vec3d.field_186680_a;
        this.uploadFloat(this.viewPosUniformID, (float)(camPos.field_72450_a - renderPosX), (float)(camPos.field_72448_b - renderPosY), (float)(camPos.field_72449_c - renderPosZ));
        this.uploadFloat(this.renderPosUniformID, (float)renderPosX, (float)renderPosY, (float)renderPosZ);
    }

    public void updateDepthBuffer() {
        this.depthBuffer.blitDepthBuffer(this.getMainFramebuffer());
        this.getMainFramebuffer().func_147610_a(false);
        GlStateManager.func_179144_i((int)0);
    }

    protected final Framebuffer getMainFramebuffer() {
        return Minecraft.func_71410_x().func_147110_a();
    }

    public DepthBuffer getDepthBuffer() {
        return this.depthBuffer;
    }

    public void updateMatrices() {
        Matrix4f projectionMatrix;
        Matrix4f modelviewMatrix;
        GL11.glGetFloat((int)2982, (FloatBuffer)MODELVIEW);
        GL11.glGetFloat((int)2983, (FloatBuffer)PROJECTION);
        this.modelviewMatrix = modelviewMatrix = (Matrix4f)new Matrix4f().load(MODELVIEW.asReadOnlyBuffer());
        this.projectionMatrix = projectionMatrix = (Matrix4f)new Matrix4f().load(PROJECTION.asReadOnlyBuffer());
        Matrix4f MVP = new Matrix4f();
        Matrix4f.mul((Matrix4f)projectionMatrix, (Matrix4f)modelviewMatrix, (Matrix4f)MVP);
        this.modelviewProjectionMatrix = MVP;
        this.invertedModelviewProjectionMatrix = Matrix4f.invert((Matrix4f)MVP, (Matrix4f)new Matrix4f());
    }

    public Matrix4f getInvertedModelviewProjectionMatrix() {
        return this.invertedModelviewProjectionMatrix;
    }

    public Matrix4f getModelviewProjectionMatrix() {
        return this.modelviewProjectionMatrix;
    }

    public Matrix4f getModelviewMatrix() {
        return this.modelviewMatrix;
    }

    public FloatBuffer getModelviewBuffer() {
        return MODELVIEW;
    }

    public Matrix4f getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public FloatBuffer getProjectionBuffer() {
        return PROJECTION;
    }

    public GeometryBuffer getGasParticleBuffer() {
        return this.gasParticlesBuffer;
    }

    public GeometryBuffer getRepellerShieldBuffer() {
        return this.repellerShieldBuffer;
    }

    public void addLight(LightSource light) {
        this.lightSources.add(light);
    }

    public void clearLights() {
        this.lightSources.clear();
    }

    public int getLightSourcesAmount() {
        return this.lightSources.size();
    }

    public void addGroundFogVolume(GroundFog.GroundFogVolume volume) {
        this.groundFogVolumes.add(volume);
    }

    public void clearGroundFogVolumes() {
        this.groundFogVolumes.clear();
    }

    public int getGroundFogVolumesAmount() {
        return this.groundFogVolumes.size();
    }

    public void setRenderPass(int pass) {
        this.currentRenderPass = pass;
    }

    public int getGasTexture() {
        return this.gasTextureFramebuffer != null ? this.gasTextureFramebuffer.field_147617_g : -1;
    }

    public int getStarfieldTexture() {
        return this.starfieldTextureFramebuffer != null ? this.starfieldTextureFramebuffer.field_147617_g : -1;
    }

    public void updateTextures(float partialTicks) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && !Minecraft.func_71410_x().func_147113_T()) {
            this.updateGasParticlesTexture((World)world, partialTicks);
            this.updateStarfieldTexture(partialTicks);
        }
    }

    public void renderPostEffects(float partialTicks) {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)scaledResolution.func_78326_a(), (double)scaledResolution.func_78328_b(), (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        this.applyGroundFog(partialTicks);
        this.applyBloodSky(partialTicks);
        this.applySwirl(partialTicks);
    }

    private void applyGroundFog(float partialTicks) {
        if (!this.groundFogVolumes.isEmpty()) {
            Framebuffer mainFramebuffer = Minecraft.func_71410_x().func_147110_a();
            Framebuffer blitFramebuffer = this.blitBuffer.getFramebuffer(mainFramebuffer.field_147621_c, mainFramebuffer.field_147618_d);
            this.groundFogEffect.setDepthBufferTexture(this.getDepthBuffer().func_110552_b());
            this.groundFogEffect.create(mainFramebuffer).setSource(mainFramebuffer.field_147617_g).setBlitFramebuffer(blitFramebuffer).setPreviousFramebuffer(mainFramebuffer).setMirrorY(true).render(partialTicks);
        }
    }

    private void applyBloodSky(float partialTicks) {
        float mult;
        float skyTransparency = 0.0f;
        boolean hasBeat = false;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            BLEnvironmentEventRegistry eeRegistry = BetweenlandsWorldStorage.forWorld((World)world).getEnvironmentEventRegistry();
            if ((skyTransparency += eeRegistry.bloodSky.getSkyTransparency(partialTicks)) > 0.01f) {
                hasBeat = true;
            }
            skyTransparency += eeRegistry.spoopy.getSkyTransparency(partialTicks);
        }
        if (skyTransparency <= 0.01f) {
            return;
        }
        if (skyTransparency > 1.0f) {
            skyTransparency = 1.0f;
        }
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        double renderWidth = scaledResolution.func_78326_a();
        double renderHeight = scaledResolution.func_78328_b();
        Vec3d lightPos = new Vec3d(45.0, 40.0, 30.0);
        GLUProjection.Projection projection = GLUProjection.getInstance().project(lightPos.field_72450_a, lightPos.field_72448_b, lightPos.field_72449_c, GLUProjection.ClampMode.ORTHOGONAL, false);
        GLUProjection.Projection projectionUnclamped = GLUProjection.getInstance().project(lightPos.field_72450_a, lightPos.field_72448_b, lightPos.field_72449_c, GLUProjection.ClampMode.NONE, false);
        float rayX = (float)(projection.getX() / renderWidth);
        float rayY = (float)(projection.getY() / renderHeight);
        float rayYUnclamped = (float)(projectionUnclamped.getY() / renderWidth);
        Vec3d lookVec = Minecraft.func_71410_x().field_71439_g.func_70676_i(partialTicks);
        lookVec = new Vec3d(lookVec.field_72450_a + 1.0E-4, 0.0, lookVec.field_72449_c + 1.0E-4);
        lookVec = lookVec.func_72432_b();
        Vec3d sLightPos = new Vec3d(lightPos.field_72450_a + 1.0E-4, 0.0, lightPos.field_72449_c + 1.0E-4).func_72432_b();
        float lightXZAngle = (float)Math.toDegrees(Math.acos(sLightPos.func_72430_b(lookVec)));
        float fovX = GLUProjection.getInstance().getFovX() / 2.0f;
        float angDiff = Math.abs(lightXZAngle);
        float decay = 0.96f;
        float illuminationDecay = 0.44f;
        float weight = 0.12f;
        if (rayYUnclamped <= 0.0f) {
            mult = 1.0f + MathHelper.func_76131_a((float)(rayYUnclamped / 5.0f * (1.0f - angDiff / fovX)), (float)-1.0f, (float)0.0f);
            decay *= mult;
            illuminationDecay *= mult;
            weight *= mult;
        }
        if (angDiff > fovX) {
            mult = 1.0f - (angDiff - fovX) / 400.0f;
            decay *= mult;
            illuminationDecay *= mult;
            weight *= mult;
        }
        int depthTexture = this.depthBuffer.func_110552_b();
        int clipPlaneBuffer = BLSkyRenderer.clipPlaneBuffer.getDepthTexture();
        if (depthTexture < 0 || clipPlaneBuffer < 0) {
            return;
        }
        Framebuffer mainFramebuffer = Minecraft.func_71410_x().func_147110_a();
        Framebuffer blitFramebuffer = this.blitBuffer.getFramebuffer(mainFramebuffer.field_147621_c, mainFramebuffer.field_147618_d);
        Framebuffer occlusionFramebuffer = this.occlusionBuffer.getFramebuffer(mainFramebuffer.field_147621_c, mainFramebuffer.field_147618_d);
        this.occlusionExtractor.setDepthTextures(depthTexture, clipPlaneBuffer);
        this.occlusionExtractor.create(occlusionFramebuffer).setSource(Minecraft.func_71410_x().func_147110_a().field_147617_g).setPreviousFramebuffer(mainFramebuffer).render(partialTicks);
        float beat = 0.0f;
        if (hasBeat) {
            beat = Math.abs((float)Math.sin((double)System.nanoTime() / 1.0E8) / 3.0f / (Math.abs((float)Math.sin((double)System.nanoTime() / 4.0E9) * (float)Math.sin((double)System.nanoTime() / 4.0E9) * (float)Math.sin((double)System.nanoTime() / 4.0E9 + (double)0.05f) * 120.0f) * 180.0f + 15.5f) * 30.0f) / 4.0f;
        }
        float density = 0.1f + beat;
        this.godRayEffect.setOcclusionMap(occlusionFramebuffer).setParams(0.8f, decay * 1.01f, density * 1.5f, weight * 0.8f, illuminationDecay * 1.25f).setRayPos(rayX, rayY).create(blitFramebuffer).setSource(mainFramebuffer.field_147617_g).setPreviousFramebuffer(mainFramebuffer).render(partialTicks);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)0.7f, (float)0.1f, (float)0.0f, (float)(skyTransparency / 2.5f));
        GlStateManager.func_179144_i((int)blitFramebuffer.field_147617_g);
        GlStateManager.func_187447_r((int)4);
        GlStateManager.func_187426_b((float)0.0f, (float)1.0f);
        GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187426_b((float)0.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)0.0f, (float)((float)renderHeight), (float)0.0f);
        GlStateManager.func_187426_b((float)1.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)((float)renderWidth), (float)((float)renderHeight), (float)0.0f);
        GlStateManager.func_187426_b((float)1.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)((float)renderWidth), (float)((float)renderHeight), (float)0.0f);
        GlStateManager.func_187426_b((float)1.0f, (float)1.0f);
        GlStateManager.func_187435_e((float)((float)renderWidth), (float)0.0f, (float)0.0f);
        GlStateManager.func_187426_b((float)0.0f, (float)1.0f);
        GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187437_J();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    public void setSwirlAngle(float swirlAngle) {
        this.lastSwirlAngle = this.swirlAngle;
        this.swirlAngle = swirlAngle;
    }

    public float getSwirlAngle(float partialTicks) {
        return this.lastSwirlAngle + (this.swirlAngle - this.lastSwirlAngle) * partialTicks;
    }

    private void applySwirl(float partialTicks) {
        float interpolatedSwirlAngle = this.getSwirlAngle(partialTicks);
        if (interpolatedSwirlAngle != 0.0f) {
            Framebuffer mainFramebuffer = Minecraft.func_71410_x().func_147110_a();
            Framebuffer blitFramebuffer = this.blitBuffer.getFramebuffer(mainFramebuffer.field_147621_c, mainFramebuffer.field_147618_d);
            this.swirlEffect.setAngle(interpolatedSwirlAngle);
            this.swirlEffect.create(mainFramebuffer).setSource(mainFramebuffer.field_147617_g).setBlitFramebuffer(blitFramebuffer).setPreviousFramebuffer(mainFramebuffer).render(partialTicks);
        }
    }

    private void updateGasParticlesTexture(World world, float partialTicks) {
        boolean hasCloud;
        boolean bl = hasCloud = DefaultParticleBatches.GAS_CLOUDS_TEXTURED.getParticles().size() > 0 || DefaultParticleBatches.GAS_CLOUDS_HEAT_HAZE.getParticles().size() > 0;
        if (!hasCloud) {
            for (Entity entity : Minecraft.func_71410_x().field_71441_e.field_72996_f) {
                if (!(entity instanceof EntityGasCloud)) continue;
                hasCloud = true;
                break;
            }
        }
        if (hasCloud) {
            float worldTimeInterp = (float)RenderUtils.getRenderTickCounter() + partialTicks;
            float offsetX = ((float)Math.sin((double)(worldTimeInterp / 20.0f) % (Math.PI * 2)) + 1.0f) / 600.0f;
            float offsetY = ((float)Math.cos((double)(worldTimeInterp / 20.0f) % (Math.PI * 2)) + 1.0f) / 600.0f;
            this.gasWarpEffect.setOffset(offsetX, offsetY).setWarpDir(0.75f, 0.75f).setScale(1.8f);
            this.gasTextureFramebuffer.func_147610_a(false);
            GlStateManager.func_179082_a((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179086_m((int)16384);
            this.gasTextureBaseFramebuffer.func_147610_a(false);
            GlStateManager.func_179082_a((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179086_m((int)16384);
            this.gasWarpEffect.create(this.gasTextureFramebuffer).setSource(this.gasTextureBaseFramebuffer.field_147617_g).setPreviousFramebuffer(Minecraft.func_71410_x().func_147110_a()).render(partialTicks);
        }
    }

    private void updateStarfieldTexture(float partialTicks) {
        float offX = (float)(Minecraft.func_71410_x().func_175598_ae().field_78730_l / 8000.0);
        float offY = (float)(Minecraft.func_71410_x().func_175598_ae().field_78728_n / 8000.0);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        this.starfieldEffect.setTimeScale(2.5E-7f).setZoom(0.8f).setOffset(offX, offY, 0.0f);
        this.starfieldEffect.create(this.starfieldTextureFramebuffer).setPreviousFramebuffer(Minecraft.func_71410_x().func_147110_a()).setRenderDimensions(BetweenlandsConfig.RENDERING.skyResolution, BetweenlandsConfig.RENDERING.skyResolution).render(partialTicks);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }
}

