/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.sky;

import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GLContext;
import thebetweenlands.api.sky.IRiftSkyRenderer;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.world.WorldProviderBetweenlands;

@SideOnly(value=Side.CLIENT)
public class OverworldRiftSkyRenderer
implements IRiftSkyRenderer {
    private static final ResourceLocation MOON_PHASES_TEXTURES = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_TEXTURES = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation CLOUDS_TEXTURES = new ResourceLocation("textures/environment/clouds.png");
    private final FloatBuffer fogColorBuffer = GLAllocation.func_74529_h((int)16);
    private final VertexFormat vertexBufferFormat;
    private int starGLCallList = -1;
    private int glSkyList = -1;
    private int glSkyList2 = -1;
    private VertexBuffer starVBO;
    private VertexBuffer skyVBO;
    private VertexBuffer sky2VBO;
    private boolean vboEnabled;
    private float fogColorRed;
    private float fogColorGreen;
    private float fogColorBlue;
    private boolean cloudFog;
    private final float[] colorsSunriseSunset = new float[4];
    private Object entityIn;

    public OverworldRiftSkyRenderer() {
        this.vboEnabled = OpenGlHelper.func_176075_f();
        this.vertexBufferFormat = new VertexFormat();
        this.vertexBufferFormat.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.POSITION, 3));
        this.generateStars();
        this.generateSky();
        this.generateSky2();
    }

    @Override
    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        this.setupFog(-1, partialTicks, mc);
        TextureManager textureManager = mc.field_71446_o;
        long worldTime = world.func_72820_D();
        GlStateManager.func_179090_x();
        Vec3d vec3d = this.getSkyColor((World)world, mc.func_175606_aa(), partialTicks);
        float f = (float)vec3d.field_72450_a;
        float f1 = (float)vec3d.field_72448_b;
        float f2 = (float)vec3d.field_72449_c;
        if (mc.field_71474_y.field_74337_g) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179127_m();
        GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
        if (this.vboEnabled) {
            this.skyVBO.func_177359_a();
            GlStateManager.func_187410_q((int)32884);
            GlStateManager.func_187420_d((int)3, (int)5126, (int)12, (int)0);
            this.skyVBO.func_177358_a(7);
            this.skyVBO.func_177361_b();
            GlStateManager.func_187429_p((int)32884);
        } else {
            GlStateManager.func_179148_o((int)this.glSkyList);
        }
        GlStateManager.func_179106_n();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74518_a();
        float[] afloat = this.calcSunriseSunsetColors((World)world, this.getCelestialAngle(worldTime, partialTicks), partialTicks);
        if (afloat != null) {
            GlStateManager.func_179090_x();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)this.getCelestialAngleRadians(worldTime, partialTicks)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float f6 = afloat[0];
            float f7 = afloat[1];
            float f8 = afloat[2];
            if (mc.field_71474_y.field_74337_g) {
                float f9 = (f6 * 30.0f + f7 * 59.0f + f8 * 11.0f) / 100.0f;
                float f10 = (f6 * 30.0f + f7 * 70.0f) / 100.0f;
                float f11 = (f6 * 30.0f + f8 * 70.0f) / 100.0f;
                f6 = f9;
                f7 = f10;
                f8 = f11;
            }
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b(0.0, 100.0, 0.0).func_181666_a(f6, f7, f8, afloat[3]).func_181675_d();
            for (int j2 = 0; j2 <= 16; ++j2) {
                float f21 = (float)j2 * ((float)Math.PI * 2) / 16.0f;
                float f12 = MathHelper.func_76126_a((float)f21);
                float f13 = MathHelper.func_76134_b((float)f21);
                bufferbuilder.func_181662_b((double)(f12 * 120.0f), (double)(f13 * 120.0f), (double)(-f13 * 40.0f * afloat[3])).func_181666_a(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        float f16 = 1.0f - this.getRainStrength((World)world, partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f16);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(this.getCelestialAngle(worldTime, partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float f17 = 30.0f;
        textureManager.func_110577_a(SUN_TEXTURES);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(-f17), 100.0, (double)(-f17)).func_187315_a(0.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)f17, 100.0, (double)(-f17)).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)f17, 100.0, (double)f17).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(-f17), 100.0, (double)f17).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        f17 = 20.0f;
        textureManager.func_110577_a(MOON_PHASES_TEXTURES);
        int k1 = this.getMoonPhase(worldTime);
        int i2 = k1 % 4;
        int k2 = k1 / 4 % 2;
        float f22 = (float)(i2 + 0) / 4.0f;
        float f23 = (float)(k2 + 0) / 2.0f;
        float f24 = (float)(i2 + 1) / 4.0f;
        float f14 = (float)(k2 + 1) / 2.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(-f17), -100.0, (double)f17).func_187315_a((double)f24, (double)f14).func_181675_d();
        bufferbuilder.func_181662_b((double)f17, -100.0, (double)f17).func_187315_a((double)f22, (double)f14).func_181675_d();
        bufferbuilder.func_181662_b((double)f17, -100.0, (double)(-f17)).func_187315_a((double)f22, (double)f23).func_181675_d();
        bufferbuilder.func_181662_b((double)(-f17), -100.0, (double)(-f17)).func_187315_a((double)f24, (double)f23).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179090_x();
        float f15 = this.getStarBrightness((World)world, partialTicks) * f16;
        if (f15 > 0.0f) {
            GlStateManager.func_179131_c((float)f15, (float)f15, (float)f15, (float)f15);
            if (this.vboEnabled) {
                this.starVBO.func_177359_a();
                GlStateManager.func_187410_q((int)32884);
                GlStateManager.func_187420_d((int)3, (int)5126, (int)12, (int)0);
                this.starVBO.func_177358_a(7);
                this.starVBO.func_177361_b();
                GlStateManager.func_187429_p((int)32884);
            } else {
                GlStateManager.func_179148_o((int)this.starGLCallList);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179127_m();
        GlStateManager.func_179121_F();
        GlStateManager.func_179090_x();
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
        double d3 = mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b - this.getHorizon();
        if (d3 < 0.0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)12.0f, (float)0.0f);
            if (this.vboEnabled) {
                this.sky2VBO.func_177359_a();
                GlStateManager.func_187410_q((int)32884);
                GlStateManager.func_187420_d((int)3, (int)5126, (int)12, (int)0);
                this.sky2VBO.func_177358_a(7);
                this.sky2VBO.func_177361_b();
                GlStateManager.func_187429_p((int)32884);
            } else {
                GlStateManager.func_179148_o((int)this.glSkyList2);
            }
            GlStateManager.func_179121_F();
            float f19 = -((float)(d3 + 65.0));
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b(-1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        if (this.isSkyColored()) {
            GlStateManager.func_179124_c((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
        } else {
            GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(-((float)(d3 - 16.0))), (float)0.0f);
        GlStateManager.func_179148_o((int)this.glSkyList2);
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        if (BetweenlandsConfig.RENDERING.skyRiftClouds) {
            WorldProviderBetweenlands providerBl;
            Entity entity = mc.func_175606_aa();
            WorldProviderBetweenlands worldProviderBetweenlands = providerBl = world.field_73011_w instanceof WorldProviderBetweenlands ? (WorldProviderBetweenlands)world.field_73011_w : null;
            if (providerBl != null) {
                providerBl.setShowClouds(true);
            }
            double rx = entity.field_70165_t;
            double prx = entity.field_70169_q;
            double lrx = entity.field_70142_S;
            double ry = entity.field_70163_u;
            double pry = entity.field_70167_r;
            double lry = entity.field_70137_T;
            double rz = entity.field_70161_v;
            double prz = entity.field_70166_s;
            double lrz = entity.field_70136_U;
            entity.field_70142_S = 0.0;
            entity.field_70169_q = 0.0;
            entity.field_70165_t = 0.0;
            entity.field_70137_T = 50.0;
            entity.field_70167_r = 50.0;
            entity.field_70163_u = 50.0;
            entity.field_70136_U = 0.0;
            entity.field_70166_s = 0.0;
            entity.field_70161_v = 0.0;
            this.setupFog(0, partialTicks, mc);
            GlStateManager.func_179094_E();
            mc.field_71438_f.func_180447_b(partialTicks, 2, 0.0, 50.0, 0.0);
            GlStateManager.func_179121_F();
            entity.field_70165_t = rx;
            entity.field_70169_q = prx;
            entity.field_70142_S = lrx;
            entity.field_70163_u = ry;
            entity.field_70167_r = pry;
            entity.field_70137_T = lry;
            entity.field_70161_v = rz;
            entity.field_70166_s = prz;
            entity.field_70136_U = lrz;
            if (providerBl != null) {
                providerBl.setShowClouds(false);
            }
        }
    }

    @Override
    public void setClearColor(float partialTicks, WorldClient world, Minecraft mc) {
        this.updateFogColor(world, partialTicks, mc);
    }

    private void generateSky2() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.sky2VBO != null) {
            this.sky2VBO.func_177362_c();
        }
        if (this.glSkyList2 >= 0) {
            GLAllocation.func_74523_b((int)this.glSkyList2);
            this.glSkyList2 = -1;
        }
        if (this.vboEnabled) {
            this.sky2VBO = new VertexBuffer(this.vertexBufferFormat);
            this.renderSky(bufferbuilder, -16.0f, true);
            bufferbuilder.func_178977_d();
            bufferbuilder.func_178965_a();
            this.sky2VBO.func_181722_a(bufferbuilder.func_178966_f());
        } else {
            this.glSkyList2 = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.glSkyList2, (int)4864);
            this.renderSky(bufferbuilder, -16.0f, true);
            tessellator.func_78381_a();
            GlStateManager.func_187415_K();
        }
    }

    private void generateSky() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.skyVBO != null) {
            this.skyVBO.func_177362_c();
        }
        if (this.glSkyList >= 0) {
            GLAllocation.func_74523_b((int)this.glSkyList);
            this.glSkyList = -1;
        }
        if (this.vboEnabled) {
            this.skyVBO = new VertexBuffer(this.vertexBufferFormat);
            this.renderSky(bufferbuilder, 16.0f, false);
            bufferbuilder.func_178977_d();
            bufferbuilder.func_178965_a();
            this.skyVBO.func_181722_a(bufferbuilder.func_178966_f());
        } else {
            this.glSkyList = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.glSkyList, (int)4864);
            this.renderSky(bufferbuilder, 16.0f, false);
            tessellator.func_78381_a();
            GlStateManager.func_187415_K();
        }
    }

    private void renderSky(BufferBuilder bufferBuilderIn, float posY, boolean reverseX) {
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                float f = k;
                float f1 = k + 64;
                if (reverseX) {
                    f1 = k;
                    f = k + 64;
                }
                bufferBuilderIn.func_181662_b((double)f, (double)posY, (double)l).func_181675_d();
                bufferBuilderIn.func_181662_b((double)f1, (double)posY, (double)l).func_181675_d();
                bufferBuilderIn.func_181662_b((double)f1, (double)posY, (double)(l + 64)).func_181675_d();
                bufferBuilderIn.func_181662_b((double)f, (double)posY, (double)(l + 64)).func_181675_d();
            }
        }
    }

    private void renderStars(BufferBuilder bufferBuilderIn) {
        Random random = new Random(10842L);
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                bufferBuilderIn.func_181662_b(d5 + d25, d6 + d23, d7 + d26).func_181675_d();
            }
        }
    }

    private void generateStars() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.starVBO != null) {
            this.starVBO.func_177362_c();
        }
        if (this.starGLCallList >= 0) {
            GLAllocation.func_74523_b((int)this.starGLCallList);
            this.starGLCallList = -1;
        }
        if (this.vboEnabled) {
            this.starVBO = new VertexBuffer(this.vertexBufferFormat);
            this.renderStars(bufferbuilder);
            bufferbuilder.func_178977_d();
            bufferbuilder.func_178965_a();
            this.starVBO.func_181722_a(bufferbuilder.func_178966_f());
        } else {
            this.starGLCallList = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_179094_E();
            GlStateManager.func_187423_f((int)this.starGLCallList, (int)4864);
            this.renderStars(bufferbuilder);
            tessellator.func_78381_a();
            GlStateManager.func_187415_K();
            GlStateManager.func_179121_F();
        }
    }

    public void updateFogColor(WorldClient world, float partialTicks, Minecraft mc) {
        long worldTime = world.func_72820_D();
        Entity entity = mc.func_175606_aa();
        float f = 0.25f + 0.75f * (float)mc.field_71474_y.field_151451_c / 32.0f;
        f = 1.0f - (float)Math.pow(f, 0.25);
        Vec3d vec3d = this.getSkyColor((World)world, mc.func_175606_aa(), partialTicks);
        float f1 = (float)vec3d.field_72450_a;
        float f2 = (float)vec3d.field_72448_b;
        float f3 = (float)vec3d.field_72449_c;
        Vec3d vec3d1 = this.getFogColor(this.getCelestialAngle(worldTime, partialTicks), partialTicks);
        this.fogColorRed = (float)vec3d1.field_72450_a;
        this.fogColorGreen = (float)vec3d1.field_72448_b;
        this.fogColorBlue = (float)vec3d1.field_72449_c;
        if (mc.field_71474_y.field_151451_c >= 4) {
            float[] afloat;
            double d0 = MathHelper.func_76126_a((float)this.getCelestialAngleRadians(worldTime, partialTicks)) > 0.0f ? -1.0 : 1.0;
            Vec3d vec3d2 = new Vec3d(d0, 0.0, 0.0);
            float f5 = (float)entity.func_70676_i(partialTicks).func_72430_b(vec3d2);
            if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            if (f5 > 0.0f && (afloat = this.calcSunriseSunsetColors((World)world, this.getCelestialAngle(worldTime, partialTicks), partialTicks)) != null) {
                this.fogColorRed = this.fogColorRed * (1.0f - (f5 *= afloat[3])) + afloat[0] * f5;
                this.fogColorGreen = this.fogColorGreen * (1.0f - f5) + afloat[1] * f5;
                this.fogColorBlue = this.fogColorBlue * (1.0f - f5) + afloat[2] * f5;
            }
        }
        this.fogColorRed += (f1 - this.fogColorRed) * f;
        this.fogColorGreen += (f2 - this.fogColorGreen) * f;
        this.fogColorBlue += (f3 - this.fogColorBlue) * f;
        float f8 = this.getRainStrength((World)world, partialTicks);
        if (f8 > 0.0f) {
            float f4 = 1.0f - f8 * 0.5f;
            float f10 = 1.0f - f8 * 0.4f;
            this.fogColorRed *= f4;
            this.fogColorGreen *= f4;
            this.fogColorBlue *= f10;
        }
        if (mc.field_71474_y.field_74337_g) {
            float f16 = (this.fogColorRed * 30.0f + this.fogColorGreen * 59.0f + this.fogColorBlue * 11.0f) / 100.0f;
            float f17 = (this.fogColorRed * 30.0f + this.fogColorGreen * 70.0f) / 100.0f;
            float f7 = (this.fogColorRed * 30.0f + this.fogColorBlue * 70.0f) / 100.0f;
            this.fogColorRed = f16;
            this.fogColorGreen = f17;
            this.fogColorBlue = f7;
        }
        GlStateManager.func_179082_a((float)this.fogColorRed, (float)this.fogColorGreen, (float)this.fogColorBlue, (float)0.0f);
    }

    private void setupFog(int startCoords, float partialTicks, Minecraft mc) {
        float farPlaneDistance = mc.field_71474_y.field_151451_c * 16;
        this.setupFogColor(false);
        GlStateManager.func_187432_a((float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.cloudFog) {
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            GlStateManager.func_179095_a((float)0.1f);
        } else {
            float f = farPlaneDistance;
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            if (startCoords == -1) {
                GlStateManager.func_179102_b((float)0.0f);
                GlStateManager.func_179153_c((float)f);
            } else {
                GlStateManager.func_179102_b((float)(f * 0.75f));
                GlStateManager.func_179153_c((float)f);
            }
            if (GLContext.getCapabilities().GL_NV_fog_distance) {
                GlStateManager.func_187412_c((int)34138, (int)34139);
            }
        }
        GlStateManager.func_179142_g();
        GlStateManager.func_179127_m();
        GlStateManager.func_179104_a((int)1028, (int)4608);
    }

    private void setupFogColor(boolean black) {
        if (black) {
            GlStateManager.func_187402_b((int)2918, (FloatBuffer)this.setFogColorBuffer(0.0f, 0.0f, 0.0f, 1.0f));
        } else {
            GlStateManager.func_187402_b((int)2918, (FloatBuffer)this.setFogColorBuffer(this.fogColorRed, this.fogColorGreen, this.fogColorBlue, 1.0f));
        }
    }

    private FloatBuffer setFogColorBuffer(float red, float green, float blue, float alpha) {
        this.fogColorBuffer.clear();
        this.fogColorBuffer.put(red).put(green).put(blue).put(alpha);
        this.fogColorBuffer.flip();
        return this.fogColorBuffer;
    }

    protected boolean isSkyColored() {
        return true;
    }

    protected double getHorizon() {
        return 63.0;
    }

    protected float getStarBrightness(World world, float partialTicks) {
        float f = this.getCelestialAngle(world.func_72820_D(), partialTicks);
        float f1 = 1.0f - (MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        return f1 * f1 * 0.5f;
    }

    protected int getMoonPhase(long worldTime) {
        return (int)(worldTime / 24000L % 8L + 8L) % 8;
    }

    protected float getCelestialAngle(long worldTime, float partialTicks) {
        int i = (int)(worldTime % 24000L);
        float f = ((float)i + partialTicks) / 24000.0f - 0.25f;
        if (f < 0.0f) {
            f += 1.0f;
        }
        if (f > 1.0f) {
            f -= 1.0f;
        }
        float f1 = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
        f += (f1 - f) / 3.0f;
        return f;
    }

    protected float getCelestialAngleRadians(long worldTime, float partialTicks) {
        return this.getCelestialAngle(worldTime, partialTicks) * ((float)Math.PI * 2);
    }

    protected float getRainStrength(World world, float partialTicks) {
        return 0.0f;
    }

    protected float[] calcSunriseSunsetColors(World world, float celestialAngle, float partialTicks) {
        float f1 = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) - 0.0f;
        if (f1 >= -0.4f && f1 <= 0.4f) {
            float f3 = (f1 - -0.0f) / 0.4f * 0.5f + 0.5f;
            float f4 = 1.0f - (1.0f - MathHelper.func_76126_a((float)(f3 * (float)Math.PI))) * 0.99f;
            f4 *= f4;
            this.colorsSunriseSunset[0] = f3 * 0.3f + 0.7f;
            this.colorsSunriseSunset[1] = f3 * f3 * 0.7f + 0.2f;
            this.colorsSunriseSunset[2] = f3 * f3 * 0.0f + 0.2f;
            this.colorsSunriseSunset[3] = f4;
            return this.colorsSunriseSunset;
        }
        return null;
    }

    protected Vec3d getSkyColor(World world, Entity renderViewEntity, float partialTicks) {
        float f = this.getCelestialAngle(world.func_72820_D(), partialTicks);
        float f1 = MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        int i = MathHelper.func_76128_c((double)renderViewEntity.field_70165_t);
        int j = MathHelper.func_76128_c((double)renderViewEntity.field_70163_u);
        int k = MathHelper.func_76128_c((double)renderViewEntity.field_70161_v);
        BlockPos blockpos = new BlockPos(i, j, k);
        int l = ForgeHooksClient.getSkyBlendColour((World)world, (BlockPos)blockpos);
        float f3 = (float)(l >> 16 & 0xFF) / 255.0f;
        float f4 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f5 = (float)(l & 0xFF) / 255.0f;
        return new Vec3d((double)(f3 *= f1), (double)(f4 *= f1), (double)(f5 *= f1));
    }

    protected Vec3d getFogColor(float celestialAngle, float partialTicks) {
        float f = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float f1 = 0.7529412f;
        float f2 = 0.84705883f;
        float f3 = 1.0f;
        return new Vec3d((double)(f1 *= f * 0.94f + 0.06f), (double)(f2 *= f * 0.94f + 0.06f), (double)(f3 *= f * 0.91f + 0.09f));
    }

    @Override
    public float getSkyBrightness(float partialTicks, WorldClient world, Minecraft mc) {
        float f = this.getCelestialAngle(world.func_72820_D(), partialTicks);
        float f1 = MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        return f1;
    }
}

