/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import java.util.Random;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.client.handler.WorldRenderHandler;
import thebetweenlands.client.render.model.tile.ModelRepeller;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.block.container.BlockRepeller;
import thebetweenlands.common.tile.TileEntityRepeller;
import thebetweenlands.util.StatePropertyHelper;

public class RenderRepeller
extends TileEntitySpecialRenderer<TileEntityRepeller> {
    protected static final ModelRepeller MODEL = new ModelRepeller();
    protected static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/tiles/repeller.png");

    public boolean isGlobalRenderer(TileEntityRepeller te) {
        return true;
    }

    public void render(TileEntityRepeller tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        EnumFacing facing = StatePropertyHelper.getStatePropertySafely(tile, BlockRepeller.class, BlockRepeller.FACING, EnumFacing.NORTH);
        double xOff = (float)(-facing.func_82601_c()) * 0.12f;
        double zOff = (float)facing.func_82599_e() * 0.12f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)(facing.func_185119_l() + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(TEXTURE);
        MODEL.render(tile != null ? (float)tile.getFuel() / (float)tile.getMaxFuel() : 0.0f);
        GlStateManager.func_179121_F();
        if (tile != null && tile.hasShimmerstone()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)(x + 0.5 + xOff)), (float)((float)(y + (double)1.15f)), (float)((float)(z + 0.5 - zOff)));
            GlStateManager.func_179152_a((float)0.008f, (float)0.008f, (float)0.008f);
            this.renderShine((float)tile.renderTicks + partialTicks, 20, 1.0f, 0.8f, 0.0f, 0.0f, 1.0f, 0.8f, 0.0f, 1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179121_F();
        }
        if (tile != null && tile.isRunning()) {
            if (ShaderHelper.INSTANCE.isWorldShaderActive()) {
                ShaderHelper.INSTANCE.require();
            }
            WorldRenderHandler.REPELLER_SHIELDS.add((Pair<Vec3d, Float>)Pair.of((Object)new Vec3d(x + 0.5 + xOff, y + (double)1.15f, z + 0.5 - zOff), (Object)Float.valueOf(tile.getRadius(partialTicks))));
        }
    }

    protected void renderShine(float ticks, int iterations, float or, float og, float ob, float oa, float ir, float ig, float ib, float ia) {
        Random random = new Random(432L);
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179118_c();
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179094_E();
        float rotation = ticks / 360.0f;
        float size = ((float)Math.sin(ticks / 40.0f) + 1.0f) * 1.8f + 1.1f;
        float brightness = MathHelper.func_76131_a((float)(size / 2.0f + 0.45f), (float)0.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int i = 0;
        while ((float)i < (float)iterations) {
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f + rotation * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f + rotation * 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            float pos1 = random.nextFloat() * 20.0f + 5.0f + size * 10.0f;
            float pos2 = random.nextFloat() * 2.0f + 1.0f + size * 2.0f;
            buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a(ir, ig, ib, ia * brightness).func_181675_d();
            buffer.func_181662_b(-0.866 * (double)pos2, (double)pos1, (double)(-0.5f * pos2)).func_181666_a(or, og, ob, oa * brightness).func_181675_d();
            buffer.func_181662_b(0.866 * (double)pos2, (double)pos1, (double)(-0.5f * pos2)).func_181666_a(or, og, ob, oa * brightness).func_181675_d();
            buffer.func_181662_b(0.0, (double)pos1, (double)(1.0f * pos2)).func_181666_a(or, og, ob, oa * brightness).func_181675_d();
            buffer.func_181662_b(-0.866 * (double)pos2, (double)pos1, (double)(-0.5f * pos2)).func_181666_a(or, og, ob, oa * brightness).func_181675_d();
            tessellator.func_78381_a();
            ++i;
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        RenderHelper.func_74519_b();
    }
}

