/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.plant;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.registries.ItemRegistry;

public class BlockBulbCappedMushroomStalk
extends BasicBlock {
    public static final PropertyBool GROUND = PropertyBool.func_177716_a((String)"ground");

    public BlockBulbCappedMushroomStalk() {
        super(Material.field_151575_d);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(0.2f);
        this.func_149715_a(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)GROUND, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemRegistry.BULB_CAPPED_MUSHROOM_ITEM;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.field_72995_K) {
            int dropChance = 6;
            if (fortune > 0 && (dropChance -= 2 * fortune) < 1) {
                dropChance = 1;
            }
            if (dropChance <= 1 || worldIn.field_73012_v.nextInt(dropChance) == 0) {
                BlockBulbCappedMushroomStalk.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ItemRegistry.BULB_CAPPED_MUSHROOM_ITEM));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (meta % 2 == 0) {
            state = state.func_177226_a((IProperty)GROUND, (Comparable)Boolean.valueOf(true));
        }
        switch (meta) {
            case 0: 
            case 1: {
                state = state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
                break;
            }
            case 8: 
            case 9: {
                state = state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
                break;
            }
            case 4: 
            case 5: {
                state = state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
                break;
            }
            default: {
                state = state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
            }
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int meta = (Boolean)state.func_177229_b((IProperty)GROUND) != false ? 1 : 0;
        switch ((BlockLog.EnumAxis)state.func_177229_b((IProperty)BlockLog.field_176299_a)) {
            case X: {
                return meta + 4;
            }
            case Z: {
                return meta + 8;
            }
            case NONE: {
                return meta + 12;
            }
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockLog.field_176299_a, GROUND});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(meta).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k())).func_177226_a((IProperty)GROUND, (Comparable)Boolean.valueOf(false));
    }
}

