/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntityBeamRelay;
import thebetweenlands.util.AdvancedStateMap;

public class BlockBeamRelay
extends BlockDirectional
implements ITileEntityProvider,
BlockRegistry.IStateMappedBlock {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockBeamRelay() {
        super(Material.field_151576_e);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(10.0f);
        this.func_149752_b(2000.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBeamRelay();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_82600_a((int)meta)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)BlockBeamRelay.getFacingFromEntity(pos, placer)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(world.func_175640_z(pos)));
    }

    public static EnumFacing getFacingFromEntity(BlockPos pos, EntityLivingBase entity) {
        if (MathHelper.func_76135_e((float)((float)entity.field_70165_t - (float)pos.func_177958_n())) < 2.0f && MathHelper.func_76135_e((float)((float)entity.field_70161_v - (float)pos.func_177952_p())) < 2.0f) {
            double eyeHeight = entity.field_70163_u + (double)entity.func_70047_e();
            if (eyeHeight - (double)pos.func_177956_o() > 2.0) {
                return EnumFacing.UP;
            }
            if ((double)pos.func_177956_o() - eyeHeight > 0.0) {
                return EnumFacing.DOWN;
            }
        }
        return entity.func_174811_aO().func_176734_d();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N, POWERED});
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_175625_s(pos) instanceof TileEntityBeamRelay) {
            TileEntityBeamRelay tile = (TileEntityBeamRelay)world.func_175625_s(pos);
            tile.deactivateBlock();
        }
        state = state.func_177231_a((IProperty)field_176387_N);
        world.func_180501_a(pos, state, 3);
        world.func_184133_a((EntityPlayer)null, pos, (SoundEvent)SoundRegistry.BEAM_SWITCH, SoundCategory.BLOCKS, 0.5f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.9f);
        return true;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (world.func_175625_s(pos) instanceof TileEntityBeamRelay) {
            TileEntityBeamRelay tile = (TileEntityBeamRelay)world.func_175625_s(pos);
            tile.deactivateBlock();
        }
    }

    @Override
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        builder.ignore(new IProperty[]{POWERED}).build();
    }
}

