/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.structure;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.registries.BlockRegistry;

public class BlockMudTilesWater
extends BasicBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockMudTilesWater() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(facing.func_176740_k().func_176722_c() ? facing : EnumFacing.NORTH));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        return meta |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.375;
        double d1 = pos.func_177956_o();
        double d2 = (double)pos.func_177952_p() + 0.375;
        int distance = 0;
        for (distance = 1; distance < 10; ++distance) {
            Material material = world.func_180495_p(pos.func_177981_b(distance)).func_185904_a();
            if (state.func_177230_c() != null && material.func_76230_c() && !material.func_76224_d()) break;
        }
        if (distance > 1 && distance < 10) {
            double d3 = d0 + (double)rand.nextFloat() * 0.25;
            double d5 = d1 + (double)distance - 0.05;
            double d7 = d2 + (double)rand.nextFloat() * 0.25;
            BLParticles.CAVE_WATER_DRIP.spawn(world, d3, d5, d7).func_70538_b(0.4118f, 0.2745f, 0.1568f);
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityPlayer && !entity.func_70093_af()) {
            world.func_184133_a(null, pos, this.field_149762_H.func_185845_c(), SoundCategory.BLOCKS, 0.5f, 1.0f);
            world.func_180498_a(null, 2001, pos, Block.func_149682_b((Block)BlockRegistry.MUD_TILES));
            world.func_175656_a(pos, BlockRegistry.STAGNANT_WATER.func_176223_P());
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        return world.func_180501_a(pos, BlockRegistry.STAGNANT_WATER.func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }
}

