/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.recruitment;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import thebetweenlands.api.capability.IPuppetCapability;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.registries.CapabilityRegistry;

public class EntityPuppetCapability
extends EntityCapability<EntityPuppetCapability, IPuppetCapability, EntityLiving>
implements IPuppetCapability,
ISerializableCapability {
    private Entity puppeteer;
    private UUID puppeteerUUID;
    private int remainingTicks;
    private boolean stay;
    private boolean guard;
    private BlockPos guardHome;
    @Nullable
    private UUID ringUUID;
    private int recruitmentCost;

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "puppet");
    }

    @Override
    protected Capability<IPuppetCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_PUPPET;
    }

    @Override
    protected Class<IPuppetCapability> getCapabilityClass() {
        return IPuppetCapability.class;
    }

    @Override
    protected EntityPuppetCapability getDefaultCapabilityImplementation() {
        return new EntityPuppetCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityLiving;
    }

    @Override
    public void setPuppeteer(Entity puppeteer) {
        this.puppeteerUUID = puppeteer == null ? null : puppeteer.func_110124_au();
        this.puppeteer = puppeteer;
        this.markDirty();
    }

    @Override
    public boolean hasPuppeteer() {
        return this.puppeteerUUID != null;
    }

    @Override
    public Entity getPuppeteer() {
        if (this.puppeteerUUID == null) {
            this.puppeteer = null;
        } else if (this.puppeteer == null || !this.puppeteer.func_70089_S() || !this.puppeteer.func_110124_au().equals(this.puppeteerUUID)) {
            this.puppeteer = null;
            for (Entity entity : ((EntityLiving)this.getEntity()).func_130014_f_().func_72872_a(Entity.class, ((EntityLiving)this.getEntity()).func_174813_aQ().func_72314_b(24.0, 24.0, 24.0))) {
                if (!entity.func_110124_au().equals(this.puppeteerUUID)) continue;
                this.puppeteer = entity;
                break;
            }
        }
        return this.puppeteer;
    }

    @Override
    public void setRemainingTicks(int ticks) {
        this.remainingTicks = ticks;
    }

    @Override
    public int getRemainingTicks() {
        return this.remainingTicks;
    }

    @Override
    public void setStay(boolean stay) {
        this.stay = stay;
        this.markDirty();
    }

    @Override
    public boolean getStay() {
        return this.stay;
    }

    @Override
    public void setGuard(boolean guard, @Nullable BlockPos pos) {
        this.guard = guard;
        this.guardHome = pos;
        this.markDirty();
    }

    @Override
    public boolean getGuard() {
        return this.guard;
    }

    @Override
    public BlockPos getGuardHome() {
        return this.guardHome;
    }

    @Override
    public void setRingUuid(@Nullable UUID uuid) {
        this.ringUUID = uuid;
    }

    @Override
    @Nullable
    public UUID getRingUuid() {
        return this.ringUUID;
    }

    @Override
    public void setRecruitmentCost(int cost) {
        this.recruitmentCost = cost;
    }

    @Override
    public int getRecruitmentCost() {
        return this.recruitmentCost;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("ticks", this.remainingTicks);
        if (this.puppeteerUUID != null) {
            nbt.func_186854_a("puppeteer", this.puppeteerUUID);
        }
        nbt.func_74757_a("stay", this.stay);
        if (this.ringUUID != null) {
            nbt.func_186854_a("ring", this.ringUUID);
        }
        nbt.func_74768_a("recruitmentCost", this.recruitmentCost);
        nbt.func_74757_a("guard", this.guard);
        if (this.guardHome != null) {
            nbt.func_74772_a("guardHome", this.guardHome.func_177986_g());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.remainingTicks = nbt.func_74762_e("ticks");
        this.puppeteerUUID = nbt.func_186855_b("puppeteer") ? nbt.func_186857_a("puppeteer") : null;
        this.stay = nbt.func_74767_n("stay");
        this.ringUUID = nbt.func_186855_b("ring") ? nbt.func_186857_a("ring") : null;
        this.recruitmentCost = nbt.func_74762_e("recruitmentCost");
        this.guard = nbt.func_74767_n("guard");
        this.guardHome = nbt.func_150297_b("guardHome", 4) ? BlockPos.func_177969_a((long)nbt.func_74763_f("guardHome")) : null;
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        if (this.puppeteerUUID != null) {
            nbt.func_186854_a("puppeteer", this.puppeteerUUID);
        }
        nbt.func_74757_a("stay", this.stay);
        nbt.func_74757_a("guard", this.guard);
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        if (nbt.func_186855_b("puppeteer")) {
            this.puppeteerUUID = nbt.func_186857_a("puppeteer");
        } else {
            this.puppeteerUUID = null;
            this.puppeteer = null;
        }
        this.stay = nbt.func_74767_n("stay");
        this.guard = nbt.func_74767_n("guard");
    }

    @Override
    public int getTrackingTime() {
        return 0;
    }
}

