/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.config.properties;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.config.ConfigProperty;

public class ItemDecayFoodProperty
extends ConfigProperty {
    private final Supplier<String[]> unparsed;
    private Map<String, IntOpenHashSet> itemList;
    private Map<String, DecayFoodStats> stats;

    public ItemDecayFoodProperty(Supplier<String[]> unparsed) {
        this.unparsed = unparsed;
    }

    @Override
    protected void init() {
        String[] unparsed;
        this.itemList = new HashMap<String, IntOpenHashSet>();
        this.stats = new HashMap<String, DecayFoodStats>();
        for (String listed : unparsed = this.unparsed.get()) {
            try {
                String[] data = listed.split("/");
                if (data.length == 3) {
                    float saturation;
                    int decay;
                    int meta;
                    String item;
                    String[] itemData;
                    block12: {
                        itemData = data[0].split(":");
                        item = itemData[0] + ":" + itemData[1];
                        if (this.itemList.get(item) != null && this.itemList.get(item).contains(Short.MAX_VALUE)) continue;
                        meta = 0;
                        if (itemData.length > 2) {
                            if (!"*".equals(itemData[2])) {
                                try {
                                    meta = Integer.parseInt(itemData[2]);
                                    break block12;
                                }
                                catch (NumberFormatException ex) {
                                    TheBetweenlands.logger.error("Failed to parse item: " + listed + ". Invalid metadata: " + itemData[2]);
                                    continue;
                                }
                            }
                            meta = Short.MAX_VALUE;
                        }
                    }
                    try {
                        decay = Integer.parseInt(data[1]);
                        saturation = Float.parseFloat(data[2]);
                    }
                    catch (NumberFormatException ex) {
                        TheBetweenlands.logger.error("Failed to parse item: " + listed + ". Invalid decay or saturation value: " + itemData[2]);
                        continue;
                    }
                    IntOpenHashSet metaSet = this.itemList.get(item);
                    if (metaSet == null) {
                        metaSet = new IntOpenHashSet();
                        this.itemList.put(item, metaSet);
                    }
                    if (meta == Short.MAX_VALUE) {
                        metaSet.clear();
                    }
                    metaSet.add(meta);
                    this.stats.put(item + "#" + meta, new DecayFoodStats(decay, saturation));
                    continue;
                }
                TheBetweenlands.logger.error("Failed to parse item: " + listed, (Object)". Invalid syntax");
            }
            catch (Exception e) {
                TheBetweenlands.logger.error("Failed to parse item: " + listed);
            }
        }
        this.setAlwaysEdible();
    }

    @Override
    public void postInitGame() {
        this.setAlwaysEdible();
    }

    private void setAlwaysEdible() {
        for (String itemRegName : this.itemList.keySet()) {
            Item item = Item.func_111206_d((String)itemRegName);
            if (!(item instanceof ItemFood)) continue;
            ((ItemFood)item).func_77848_i();
        }
    }

    @Nullable
    public DecayFoodStats getStats(ItemStack stack) {
        DecayFoodStats stats;
        if (stack.func_190926_b()) {
            return null;
        }
        ResourceLocation name = stack.func_77973_b().getRegistryName();
        IntOpenHashSet metas = this.itemList.get(name.toString());
        if (metas == null) {
            return null;
        }
        if (metas.contains(Short.MAX_VALUE) && (stats = this.stats.get(name.toString() + "#" + Short.MAX_VALUE)) != null) {
            return stats;
        }
        if (metas.contains(stack.func_77960_j())) {
            return this.stats.get(name.toString() + "#" + stack.func_77960_j());
        }
        return null;
    }

    public static class DecayFoodStats {
        public final int decay;
        public final float saturation;

        public DecayFoodStats(int decay, float saturation) {
            this.decay = decay;
            this.saturation = saturation;
        }
    }
}

