/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.common.registries.ItemRegistry;

public class EntityLurkerSkinRaft
extends EntityBoat {
    private ItemStack shield = ItemStack.field_190927_a;
    private boolean updating = false;

    public EntityLurkerSkinRaft(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.25f, 0.25f);
    }

    public EntityLurkerSkinRaft(World worldIn, double x, double y, double z, ItemStack shield) {
        super(worldIn, x, y, z);
        this.func_70105_a(1.25f, 0.25f);
        this.shield = shield.func_77946_l();
    }

    public Item func_184455_j() {
        return ItemRegistry.LURKER_SKIN_SHIELD;
    }

    protected ItemStack getBoatDrop() {
        if (!this.shield.func_190926_b()) {
            return this.shield.func_77946_l();
        }
        return new ItemStack(this.func_184455_j());
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_77973_b() == this.func_184455_j()) {
            return super.func_70099_a(this.getBoatDrop(), offsetY);
        }
        return null;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        this.field_70143_R = 0.0f;
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    protected void func_184225_p(Entity passenger) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_184188_bt().indexOf(passenger) == 0) {
            ItemStack drop = this.getBoatDrop();
            boolean itemReturned = false;
            if (passenger instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)passenger;
                if (player.func_184586_b(EnumHand.OFF_HAND).func_190926_b()) {
                    player.func_184611_a(EnumHand.OFF_HAND, drop);
                    itemReturned = true;
                } else if (player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
                    player.func_184611_a(EnumHand.MAIN_HAND, drop);
                    itemReturned = true;
                } else {
                    itemReturned = player.field_71071_by.func_70441_a(drop);
                }
            }
            if (itemReturned) {
                this.func_70106_y();
            }
        }
        super.func_184225_p(passenger);
    }

    public void func_70071_h_() {
        this.updating = true;
        super.func_70071_h_();
        this.updating = false;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.updating) {
            x *= 0.4;
            z *= 0.4;
        }
        super.func_70091_d(type, x, y, z);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            float offset = -0.2f;
            float yOffset = (float)((this.field_70128_L ? 0.01 : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                offset = i == 0 ? 0.3f : -0.4f;
                if (passenger instanceof EntityAnimal) {
                    offset = (float)((double)offset + 0.2);
                }
            }
            Vec3d offsetPos = new Vec3d((double)offset, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + offsetPos.field_72450_a, this.field_70163_u + (double)yOffset, this.field_70161_v + offsetPos.field_72449_c);
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (!this.shield.func_190926_b()) {
            NBTTagCompound shieldNbt = new NBTTagCompound();
            this.shield.func_77955_b(shieldNbt);
            nbt.func_74782_a("shield", (NBTBase)shieldNbt);
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.shield = ItemStack.field_190927_a;
        if (nbt.func_150297_b("shield", 10)) {
            NBTTagCompound shieldNbt = nbt.func_74775_l("shield");
            this.shield = new ItemStack(shieldNbt);
        }
    }
}

