/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.registries.ItemRegistry;

public class EntitySpiritTreeFaceMask
extends EntityHanging
implements IEntityAdditionalSpawnData {
    private Type type;

    public EntitySpiritTreeFaceMask(World world) {
        super(world);
    }

    public EntitySpiritTreeFaceMask(World world, BlockPos pos, EnumFacing facing, Type type) {
        super(world, pos);
        this.type = type;
        this.func_174859_a(facing);
    }

    public Type getType() {
        return this.type;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("type", this.type.ordinal());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.type = Type.values()[nbt.func_74762_e("type")];
    }

    public int func_82329_d() {
        return this.type == Type.LARGE ? 32 : 16;
    }

    public int func_82330_g() {
        return this.type == Type.LARGE ? 32 : 16;
    }

    public void func_110128_b(@Nullable Entity brokenEntity) {
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_184185_a(SoundEvents.field_187881_gQ, 1.0f, 1.0f);
            if (brokenEntity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)brokenEntity;
                if (entityplayer.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            this.func_70099_a(new ItemStack(this.type == Type.LARGE ? ItemRegistry.SPIRIT_TREE_FACE_LARGE_MASK : ItemRegistry.SPIRIT_TREE_FACE_SMALL_MASK), 0.0f);
        }
    }

    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_187891_gV, 1.0f, 1.0f);
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        this.func_70107_b(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(this.field_174861_a.func_177958_n(), this.field_174861_a.func_177956_o(), this.field_174861_a.func_177952_p());
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeLong(this.field_174861_a.func_177986_g());
        buf.writeBoolean(this.field_174860_b != null);
        if (this.field_174860_b != null) {
            buf.writeInt(this.field_174860_b.func_176745_a());
        }
    }

    public void readSpawnData(ByteBuf buf) {
        this.type = Type.values()[buf.readInt()];
        this.field_174861_a = BlockPos.func_177969_a((long)buf.readLong());
        if (buf.readBoolean()) {
            this.field_174860_b = EnumFacing.func_82600_a((int)buf.readInt());
            this.func_174859_a(this.field_174860_b);
        }
    }

    public static enum Type {
        LARGE,
        SMALL;

    }
}

