/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.api.entity.IPullerEntityProvider;
import thebetweenlands.common.entity.draeton.DraetonPhysicsPart;
import thebetweenlands.common.entity.draeton.EntityDraeton;
import thebetweenlands.common.entity.draeton.EntityPullerDragonfly;
import thebetweenlands.common.entity.mobs.EntityLurker;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityDragonFly
extends EntityAmbientCreature
implements IEntityBL,
IPullerEntityProvider<EntityPullerDragonfly> {
    private BlockPos currentFlightTarget;
    private boolean entityFlying;
    protected BlockPos spawnPos;

    public EntityDragonFly(World world) {
        super(world);
        this.func_70105_a(0.9f, 0.5f);
        this.field_70728_aV = 3;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.9);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public int func_70641_bl() {
        return 2;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.DRAGONFLY;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.SQUISH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.DRAGONFLY;
    }

    public boolean isFlying() {
        return !this.field_70122_E;
    }

    public void setEntityFlying(boolean state) {
        this.entityFlying = state;
    }

    public void func_70071_h_() {
        if (this.spawnPos == null) {
            this.spawnPos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(200) == 0) {
                if (!this.entityFlying) {
                    this.setEntityFlying(true);
                } else {
                    this.setEntityFlying(false);
                }
            }
            if (this.entityFlying) {
                this.flyAbout();
            } else {
                this.land();
            }
            if (!this.entityFlying) {
                if (this.func_70090_H()) {
                    this.field_70181_x += (double)0.2f;
                }
                if (this.field_70170_p.func_72953_d(this.func_174813_aQ().func_72314_b(0.0, 1.0, 0.0))) {
                    this.flyAbout();
                }
                if (this.field_70170_p.func_72890_a((Entity)this, 4.0) != null) {
                    this.flyAbout();
                }
            }
        }
        super.func_70071_h_();
    }

    public void flyAbout() {
        if (!(this.currentFlightTarget == null || this.field_70170_p.func_175707_a(this.currentFlightTarget.func_177982_a(-6, -6, -6), this.currentFlightTarget.func_177982_a(6, 6, 6)) && this.field_70170_p.func_175623_d(this.currentFlightTarget) && this.currentFlightTarget.func_177956_o() >= 1 && this.field_70170_p.func_180495_p(this.currentFlightTarget.func_177984_a()).func_177230_c() != Blocks.field_150355_j)) {
            this.currentFlightTarget = null;
        }
        if (this.currentFlightTarget == null || this.field_70146_Z.nextInt(30) == 0 || this.currentFlightTarget.func_185332_f((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) < 8.0) {
            BlockPos newTarget = new BlockPos((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 1, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
            if (this.spawnPos != null && this.spawnPos.func_177951_i((Vec3i)newTarget) > 1024.0) {
                newTarget = this.spawnPos.func_177982_a(this.field_70146_Z.nextInt(16) - this.field_70146_Z.nextInt(16), this.field_70146_Z.nextInt(10) - 5, this.field_70146_Z.nextInt(16) - this.field_70146_Z.nextInt(16));
            }
            if (this.field_70170_p.func_175707_a(newTarget.func_177982_a(-6, -6, -6), newTarget.func_177982_a(6, 6, 6))) {
                this.currentFlightTarget = newTarget;
            }
        }
        this.flyToTarget();
    }

    public void flyToTarget() {
        if (this.currentFlightTarget != null) {
            double targetX = (double)this.currentFlightTarget.func_177958_n() + 0.5 - this.field_70165_t;
            double targetY = (double)this.currentFlightTarget.func_177956_o() + 1.0 - this.field_70163_u;
            double targetZ = (double)this.currentFlightTarget.func_177952_p() + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(targetX) * 0.5 - this.field_70159_w) * 0.1;
            this.field_70181_x += (Math.signum(targetY) * 0.7 - this.field_70181_x) * 0.1;
            this.field_70179_y += (Math.signum(targetZ) * 0.5 - this.field_70179_y) * 0.1;
            float angle = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
            float rotation = MathHelper.func_76142_g((float)(angle - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70177_z += rotation;
        }
    }

    private void land() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return !this.isInLurkersMouth() && super.func_145770_h(x, y, z);
    }

    public boolean func_70067_L() {
        return !this.isInLurkersMouth();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70685_l(Entity entity) {
        return !this.isInLurkersMouth() && super.func_70685_l(entity);
    }

    private boolean isInLurkersMouth() {
        return this.func_184187_bx() instanceof EntityLurker;
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            if (!this.field_70170_p.field_72995_K && (this.field_70718_bc > 0 || this.func_70684_aJ()) && !this.func_70631_g_() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                int amount;
                for (int experiencePoints = this.func_70693_a(this.field_70717_bb); experiencePoints > 0; experiencePoints -= amount) {
                    amount = EntityXPOrb.func_70527_a((int)experiencePoints);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, amount));
                }
            }
            this.func_70106_y();
            if (!this.isInLurkersMouth()) {
                for (int particle = 0; particle < 20; ++particle) {
                    double motionX = this.field_70146_Z.nextGaussian() * 0.02;
                    double motionY = this.field_70146_Z.nextGaussian() * 0.02;
                    double motionZ = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, motionX, motionY, motionZ, new int[0]);
                }
            }
        }
    }

    protected boolean func_184228_n(Entity entityIn) {
        return super.func_184228_n(entityIn);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.spawnPos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        return super.func_180482_a(difficulty, livingdata);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound nbt) {
        if (this.spawnPos != null) {
            nbt.func_74772_a("spawnPos", this.spawnPos.func_177986_g());
        }
        return super.func_189511_e(nbt);
    }

    public void func_70020_e(NBTTagCompound nbt) {
        if (nbt.func_150297_b("spawnPos", 4)) {
            this.spawnPos = BlockPos.func_177969_a((long)nbt.func_74763_f("spawnPos"));
        }
        super.func_70020_e(nbt);
    }

    @Override
    public EntityPullerDragonfly createPuller(EntityDraeton draeton, DraetonPhysicsPart puller) {
        return new EntityPullerDragonfly(draeton.field_70170_p, draeton, puller);
    }
}

