/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.common.entity.EntityTinyWormEggSac;
import thebetweenlands.common.entity.mobs.EntitySludgeWorm;
import thebetweenlands.common.entity.mobs.EntitySmollSludge;
import thebetweenlands.common.entity.mobs.EntityTinySludgeWorm;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.util.CatmullRomSpline;
import thebetweenlands.util.ReparameterizedSpline;

public class EntityLargeSludgeWorm
extends EntitySludgeWorm {
    private static final DataParameter<Float> EGG_SAC_PERCENTAGE = EntityDataManager.func_187226_a(EntityLargeSludgeWorm.class, (DataSerializer)DataSerializers.field_187193_c);
    public boolean segmentsAvailable = false;
    public ReparameterizedSpline spineySpliney;
    public final HullSegment[] segments;
    public final List<SpineBone> bones = new ArrayList<SpineBone>();
    public Vec3d prevEggSacPosition = null;
    public Vec3d eggSacPosition = null;
    protected int eggSacMovementCooldown = 0;
    protected static final float HULL_OUTER_WIDTH = 0.58f;
    protected static final float HULL_INNER_WIDTH = 0.44f;
    protected static final float[][] HULL_CROSS_SECTION = new float[][]{{-0.58f, 0.44f}, {-0.58f, -0.44f}, {-0.44f, -0.44f}, {-0.44f, -0.58f}, {0.44f, -0.58f}, {0.44f, -0.44f}, {0.58f, -0.44f}, {0.58f, 0.44f}, {0.44f, 0.44f}, {0.44f, 0.58f}, {-0.44f, 0.58f}, {-0.44f, 0.44f}};

    public EntityLargeSludgeWorm(World world) {
        super(world, false);
        this.func_70105_a(0.8f, 0.8f);
        this.field_70178_ae = true;
        this.parts = new MultiPartEntityPart[]{new MultiPartEntityPart((IEntityMultiPart)this, "part1", 0.8f, 0.8f), new MultiPartEntityPart((IEntityMultiPart)this, "part2", 0.8f, 0.8f), new MultiPartEntityPart((IEntityMultiPart)this, "part3", 0.8f, 0.8f), new MultiPartEntityPart((IEntityMultiPart)this, "part4", 0.8f, 0.8f), new MultiPartEntityPart((IEntityMultiPart)this, "part5", 0.8f, 0.8f)};
        int numSegments = 3 * this.parts.length;
        this.segments = new HullSegment[numSegments];
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(EGG_SAC_PERCENTAGE, (Object)Float.valueOf(-1.0f));
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8, 1));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AILayEggSac(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, entity -> !(entity instanceof IMob)));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.19);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.LARGE_SLUDGE_WORM;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.5f;
    }

    @Override
    protected double getMaxPieceDistance() {
        return 0.95;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("eggSacPercentage", this.getEggSacPercentage());
        nbt.func_74768_a("eggSacCooldown", this.eggSacMovementCooldown);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("eggSacPercentage", 5)) {
            this.setEggSacPercentage(nbt.func_74760_g("eggSacPercentage"));
        }
        if (nbt.func_150297_b("eggSacCooldown", 3)) {
            this.eggSacMovementCooldown = nbt.func_74762_e("eggSacCooldown");
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70089_S()) {
                if (this.eggSacMovementCooldown > 0) {
                    --this.eggSacMovementCooldown;
                } else if (this.getEggSacPercentage() >= 0.0f) {
                    float percentage = Math.max(this.getEggSacPercentage(), 0.0f) + 0.005f;
                    if (percentage >= 1.0f) {
                        MultiPartEntityPart tailPart = this.parts[this.parts.length - 1];
                        EntityTinyWormEggSac eggSac = new EntityTinyWormEggSac(this.field_70170_p);
                        eggSac.func_70012_b(tailPart.field_70165_t, tailPart.field_70163_u, tailPart.field_70161_v, 0.0f, 0.0f);
                        this.field_70170_p.func_72838_d((Entity)eggSac);
                        this.setEggSacPercentage(-1.0f);
                    } else {
                        this.setEggSacPercentage(percentage);
                    }
                }
            }
        } else {
            this.updateSegmentPositions();
            float eggSackPercentage = this.getEggSacPercentage();
            if (eggSackPercentage >= 0.0f) {
                this.prevEggSacPosition = this.eggSacPosition;
                this.eggSacPosition = this.spineySpliney.interpolate(eggSackPercentage);
            } else {
                this.eggSacPosition = null;
                this.prevEggSacPosition = null;
            }
        }
    }

    @Override
    protected boolean damageWorm(DamageSource source, float amount) {
        this.eggSacMovementCooldown = 50;
        if (!this.field_70170_p.field_72995_K && source instanceof EntityDamageSource && this.field_70170_p.field_73012_v.nextInt(6) == 0 && amount > 0.5f) {
            MultiPartEntityPart spawnPart = this.parts[this.field_70146_Z.nextInt(this.parts.length)];
            EntitySmollSludge entity = new EntitySmollSludge(this.field_70170_p);
            entity.func_70012_b(spawnPart.field_70165_t, spawnPart.field_70163_u, spawnPart.field_70161_v, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entity);
        }
        return super.damageWorm(source, amount);
    }

    protected void updateSegmentPositions() {
        int i;
        this.segmentsAvailable = true;
        Vec3d origin = this.func_174791_d();
        Vec3d[] points = new Vec3d[this.parts.length + 2];
        Vec3d partDir = null;
        MultiPartEntityPart prevPart = null;
        Vec3d look = this.func_70040_Z();
        points[0] = this.parts[0].func_174791_d().func_72441_c(-origin.field_72450_a + look.field_72450_a, -origin.field_72448_b + look.field_72448_b, -origin.field_72449_c + look.field_72449_c);
        for (int i2 = 0; i2 < this.parts.length; ++i2) {
            MultiPartEntityPart part = this.parts[i2];
            boolean isSamePos = false;
            if (prevPart != null) {
                Vec3d prevPos;
                Vec3d currPos = part.func_174791_d();
                Vec3d diff = currPos.func_178788_d(prevPos = prevPart.func_174791_d());
                if (diff.func_189985_c() > 0.01) {
                    partDir = diff.func_72432_b();
                } else {
                    isSamePos = true;
                }
            }
            prevPart = part;
            Vec3d splineNode = part.func_174791_d().func_178788_d(origin);
            if (isSamePos && partDir != null) {
                splineNode = splineNode.func_178787_e(partDir.func_186678_a(0.1 / (double)this.parts.length * (double)i2));
            }
            points[i2 + 1] = splineNode;
        }
        Vec3d endPoint = partDir != null ? this.parts[this.parts.length - 1].func_174791_d().func_72441_c(-origin.field_72450_a + partDir.field_72450_a, -origin.field_72448_b + partDir.field_72448_b, -origin.field_72449_c + partDir.field_72449_c) : this.parts[this.parts.length - 1].func_174791_d().func_72441_c(-origin.field_72450_a, -origin.field_72448_b - 1.0E-4, -origin.field_72449_c);
        points[this.parts.length + 1] = endPoint;
        this.spineySpliney = new ReparameterizedSpline(new CatmullRomSpline(points));
        this.spineySpliney.init(this.segments.length * 2, 3);
        for (int i3 = 0; i3 < this.segments.length; ++i3) {
            HullSegment segment = this.segments[i3];
            if (segment == null) {
                this.segments[i3] = segment = new HullSegment();
            }
            Vec3d pos = this.spineySpliney.interpolate((float)i3 / (float)(this.segments.length - 1));
            Vec3d dir = this.spineySpliney.derivative((float)i3 / (float)(this.segments.length - 1));
            segment.update(pos, dir);
        }
        int spineBones = MathHelper.func_76143_f((double)(this.spineySpliney.getArcLength() * 12.0));
        for (i = spineBones - this.bones.size(); i > 0; --i) {
            this.bones.add(new SpineBone());
        }
        for (i = this.bones.size() - spineBones; i > 0; --i) {
            this.bones.remove(this.bones.size() - 1);
        }
        for (i = 0; i < this.bones.size(); ++i) {
            SpineBone bone = this.bones.get(i);
            Vec3d pos = this.spineySpliney.interpolate((float)i / (float)(this.bones.size() - 1));
            Vec3d dir = this.spineySpliney.derivative((float)i / (float)(this.bones.size() - 1));
            bone.update(pos, dir);
        }
    }

    public void setEggSacPercentage(float percentage) {
        this.func_184212_Q().func_187227_b(EGG_SAC_PERCENTAGE, (Object)Float.valueOf(percentage));
    }

    public float getEggSacPercentage() {
        return ((Float)this.func_184212_Q().func_187225_a(EGG_SAC_PERCENTAGE)).floatValue();
    }

    public void startLayingEggSac() {
        if (this.getEggSacPercentage() < 0.0f) {
            this.setEggSacPercentage(1.0E-5f);
        }
    }

    public static class AILayEggSac
    extends EntityAIBase {
        protected final EntityLargeSludgeWorm entity;
        protected int cooldown = 30;

        public AILayEggSac(EntityLargeSludgeWorm entity) {
            this.entity = entity;
            this.func_75248_a(0);
        }

        public boolean func_75250_a() {
            boolean canLay;
            boolean bl = canLay = this.entity.func_70089_S() && this.entity.func_70638_az() != null && this.entity.getEggSacPercentage() < 0.0f;
            if (canLay && this.cooldown-- <= 0) {
                List nearbyEggSacs = this.entity.field_70170_p.func_72872_a(EntityTinyWormEggSac.class, this.entity.func_174813_aQ().func_186662_g(16.0));
                List nearbyTinyWorms = this.entity.field_70170_p.func_72872_a(EntityTinySludgeWorm.class, this.entity.func_174813_aQ().func_186662_g(16.0));
                if (nearbyEggSacs.size() < 5 && nearbyTinyWorms.size() < 8) {
                    this.cooldown = 30 + this.entity.field_70146_Z.nextInt(30);
                    return true;
                }
                this.cooldown = 10 + this.entity.field_70146_Z.nextInt(20);
            }
            return false;
        }

        public void func_75249_e() {
            this.entity.startLayingEggSac();
        }

        public boolean func_75253_b() {
            return false;
        }
    }

    public static class SpineBone {
        public Vec3d prevPos;
        public Vec3d pos;
        public float prevYaw;
        public float yaw;

        public void update(Vec3d newPos, Vec3d splineDir) {
            this.prevPos = this.pos;
            this.pos = newPos;
            this.prevYaw = this.yaw;
            this.yaw = -((float)Math.toDegrees(Math.atan2(splineDir.field_72449_c, splineDir.field_72450_a))) + 90.0f;
            if (this.prevPos == null) {
                this.prevPos = this.pos;
                this.prevYaw = this.yaw;
            }
            while (this.yaw - this.prevYaw < -180.0f) {
                this.prevYaw -= 360.0f;
            }
            while (this.yaw - this.prevYaw >= 180.0f) {
                this.prevYaw += 360.0f;
            }
        }
    }

    public static class HullSegment {
        private static final Vec3d WORLD_UP = new Vec3d(0.0, 1.0, 0.0);
        public Vec3d prevPos;
        public Vec3d pos;
        public float prevYaw;
        public float yaw;
        public final float[] offsetX = new float[HULL_CROSS_SECTION.length];
        public final float[] offsetY = new float[HULL_CROSS_SECTION.length];
        public final float[] offsetZ = new float[HULL_CROSS_SECTION.length];

        public void update(Vec3d newPos, Vec3d splineDir) {
            this.prevPos = this.pos;
            this.pos = newPos;
            this.prevYaw = this.yaw;
            this.yaw = (float)Math.toDegrees(Math.atan2(splineDir.field_72449_c, splineDir.field_72450_a)) - 90.0f;
            if (this.prevPos == null) {
                this.prevPos = this.pos;
                this.prevYaw = this.yaw;
            }
            while (this.yaw - this.prevYaw < -180.0f) {
                this.prevYaw -= 360.0f;
            }
            while (this.yaw - this.prevYaw >= 180.0f) {
                this.prevYaw += 360.0f;
            }
            Vec3d right = splineDir.func_72431_c(WORLD_UP).func_72432_b();
            Vec3d up = right.func_72431_c(splineDir).func_72432_b();
            int i = 0;
            for (float[] hullCrossSection : HULL_CROSS_SECTION) {
                float hullX = hullCrossSection[0];
                float hullY = hullCrossSection[1];
                this.offsetX[i] = (float)(right.field_72450_a * (double)hullX + up.field_72450_a * (double)hullY);
                this.offsetY[i] = (float)(right.field_72448_b * (double)hullX + up.field_72448_b * (double)hullY);
                this.offsetZ[i] = (float)(right.field_72449_c * (double)hullX + up.field_72449_c * (double)hullY);
                ++i;
            }
        }
    }
}

