/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.common.capability.collision.RingOfDispersionEntityCapability;
import thebetweenlands.common.entity.mobs.EntityWallFace;

public abstract class EntityMovingWallFace
extends EntityWallFace {
    public static final IAttribute BLOCK_TRACKING_SEARCH_RANGE = new RangedAttribute((IAttribute)null, "bl.blockTrackingSearchRange", 8.0, 0.0, 32.0).func_111117_a("Block Tracking Search Range");
    public static final IAttribute BLOCK_FIX_SEARCH_RANGE = new RangedAttribute((IAttribute)null, "bl.blockFixSearchRange", 8.0, 0.0, 32.0).func_111117_a("Block Fix Search Range");

    public EntityMovingWallFace(World world) {
        super(world);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(BLOCK_TRACKING_SEARCH_RANGE);
        this.func_110140_aT().func_111150_b(BLOCK_FIX_SEARCH_RANGE);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isMoving() && this.field_70170_p.field_72995_K && this.field_70173_aa % 3 == 0) {
            EnumFacing facing = this.getFacing();
            double px = this.field_70165_t + (double)((float)facing.func_82601_c() * this.field_70130_N / 2.0f);
            double py = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + (double)((float)facing.func_96559_d() * this.field_70131_O / 2.0f);
            double pz = this.field_70161_v + (double)((float)facing.func_82599_e() * this.field_70130_N / 2.0f);
            for (int i = 0; i < 24; ++i) {
                double rz;
                double ry;
                double rx = (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)this.field_70130_N;
                BlockPos pos = new BlockPos(px + rx, py + (ry = (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)this.field_70131_O), pz + (rz = (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)this.field_70130_N));
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                if (state.func_177230_c().isAir(state, (IBlockAccess)this.field_70170_p, pos)) continue;
                double mx = (double)((float)facing.func_82601_c() * 0.15f) + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.25;
                double my = (double)((float)facing.func_96559_d() * 0.15f) + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.25;
                double mz = (double)((float)facing.func_82599_e() * 0.15f) + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.25;
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, px + rx, py + ry, pz + rz, mx, my, mz, new int[]{Block.func_176210_f((IBlockState)state)});
            }
        }
    }

    @Override
    public boolean canMoveFaceInto(BlockPos pos, EnumFacing facing, EnumFacing facingUp) {
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        if (state.func_185904_a().func_76224_d() || state.func_177230_c().isAir(state, (IBlockAccess)this.field_70170_p, pos)) {
            return true;
        }
        if (state.func_177230_c().isLeaves(state, (IBlockAccess)this.field_70170_p, pos)) {
            return false;
        }
        ArrayList collisionBoxes = new ArrayList();
        state.func_185908_a(this.field_70170_p, pos, new AxisAlignedBB(pos), collisionBoxes, (Entity)this, false);
        return collisionBoxes.isEmpty();
    }

    @Override
    protected void fixUnsuitablePosition(int violatedChecks) {
        if (this.field_70173_aa % 3 == 0) {
            int searchRange = MathHelper.func_76143_f((double)this.func_110148_a(BLOCK_FIX_SEARCH_RANGE).func_111126_e());
            for (int i = 0; i < 50; ++i) {
                Vec3d pos;
                float rx = this.field_70170_p.field_73012_v.nextFloat() * 2.0f - 1.0f;
                float ry = this.field_70170_p.field_73012_v.nextFloat() * 2.0f - 1.0f;
                float rz = this.field_70170_p.field_73012_v.nextFloat() * 2.0f - 1.0f;
                BlockPos rndPos = new BlockPos(this.field_70165_t + (double)this.field_70170_p.field_73012_v.nextInt(searchRange * 2) - (double)searchRange, this.field_70163_u + (double)(this.field_70131_O / 2.0f) + (double)this.field_70170_p.field_73012_v.nextInt(searchRange * 2) - (double)searchRange, this.field_70161_v + (double)this.field_70170_p.field_73012_v.nextInt(searchRange * 2) - (double)searchRange);
                if (!this.field_70170_p.func_175667_e(rndPos) || this.checkAnchorAt(pos = new Vec3d((double)rndPos.func_177958_n() + 0.5, (double)rndPos.func_177956_o() + 0.5, (double)rndPos.func_177952_p() + 0.5), new Vec3d((double)rx, (double)ry, (double)rz), 7) != 0) continue;
                this.field_70749_g.setLookDirection(rx, ry, rz);
                this.field_70765_h.func_75642_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 1.0);
                break;
            }
        }
    }

    protected abstract boolean isValidBlockForMovement(BlockPos var1, IBlockState var2);

    public List<BlockPos> findNearbyBlocksForMovement() {
        int radius = MathHelper.func_76143_f((double)this.func_110148_a(BLOCK_TRACKING_SEARCH_RANGE).func_111126_e());
        BlockPos center = new BlockPos((Entity)this);
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    pos.func_181079_c(center.func_177958_n() + dx, center.func_177956_o() + dy, center.func_177952_p() + dz);
                    IBlockState state = this.field_70170_p.func_180495_p((BlockPos)pos);
                    if (!this.isValidBlockForMovement((BlockPos)pos, state)) continue;
                    blocks.add(pos.func_185334_h());
                }
            }
        }
        return blocks;
    }

    protected static class AIAttackMelee
    extends EntityAIAttackMelee {
        public AIAttackMelee(EntityCreature creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        protected boolean isInReach(EntityLivingBase enemy, double reach) {
            double dist = Math.max(0.0, RingOfDispersionEntityCapability.calculateAABBDistance(this.field_75441_b.func_174813_aQ(), enemy.func_174813_aQ()));
            return dist <= reach;
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            float r1 = Math.max(attackTarget.field_70130_N, attackTarget.field_70131_O);
            float r2 = Math.max(this.field_75441_b.field_70130_N, this.field_75441_b.field_70131_O);
            double reach = this.getTrueAttackReach(attackTarget);
            return this.isInReach(attackTarget, reach) ? ((double)(r1 * r1 + r2 * r2) + reach * reach) * 2.0 : 0.0;
        }

        protected double getTrueAttackReach(EntityLivingBase attackTarget) {
            return 0.25;
        }
    }

    protected static abstract class AIWander<T extends EntityMovingWallFace>
    extends EntityAIBase {
        protected final T entity;
        protected int findBlocksCooldown = 0;
        protected List<BlockPos> trackingBlocks;
        protected int checkCooldown = 0;
        protected double speed;
        protected int chance;
        protected double range;
        protected double rangeSq;
        protected boolean wandered = false;

        public AIWander(T entity, double range, double speed) {
            this(entity, range, speed, 120);
        }

        public AIWander(T entity, double range, double speed, int chance) {
            this.entity = entity;
            this.range = range;
            this.rangeSq = range * range;
            this.speed = speed;
            this.chance = chance;
            this.func_75248_a(1);
        }

        protected abstract boolean canMove();

        public boolean func_75250_a() {
            return this.canMove() && !((EntityWallFace)this.entity).isMoving() && this.entity.func_70654_ax() < 100 && this.entity.func_70681_au().nextInt(this.chance) == 0;
        }

        public void func_75249_e() {
            this.checkCooldown = 0;
            this.findBlocksCooldown = 20 + this.entity.func_70681_au().nextInt(30);
            this.trackingBlocks = null;
            this.wandered = false;
        }

        public void func_75246_d() {
            if (this.findBlocksCooldown <= 0 && (this.trackingBlocks == null || this.trackingBlocks.isEmpty())) {
                this.findBlocksCooldown = 40 + this.entity.func_70681_au().nextInt(60);
                this.trackingBlocks = ((EntityMovingWallFace)this.entity).findNearbyBlocksForMovement();
            }
            if (this.trackingBlocks != null && !this.trackingBlocks.isEmpty() && this.checkCooldown <= 0) {
                this.checkCooldown = 5 + this.entity.func_70681_au().nextInt(15);
                for (int i = 0; i < 16 && !this.trackingBlocks.isEmpty(); ++i) {
                    double dz;
                    double dy;
                    double dx;
                    Vec3d center;
                    BlockPos pos = this.trackingBlocks.remove(this.entity.func_70681_au().nextInt(this.trackingBlocks.size()));
                    if (!(this.entity.func_174831_c(pos) <= this.rangeSq) || !this.entity.func_180485_d(pos) || ((EntityWallFace)this.entity).checkAnchorAt(center = new Vec3d((double)pos.func_177958_n() + (double)((EntityWallFace)this.entity).getBlockWidth() / 2.0, (double)pos.func_177956_o() + (double)((EntityWallFace)this.entity).getBlockHeight() / 2.0, (double)pos.func_177952_p() + (double)((EntityWallFace)this.entity).getBlockWidth() / 2.0), new Vec3d(dx = this.entity.func_70681_au().nextDouble() - 0.5, dy = this.entity.func_70681_au().nextDouble() - 0.5, dz = this.entity.func_70681_au().nextDouble() - 0.5), 7) != 0) continue;
                    ((EntityWallFace)this.entity).getMoveHelper().func_75642_a(center.field_72450_a, center.field_72448_b, center.field_72449_c, this.speed);
                    ((EntityWallFace)this.entity).getLookHelper().setLookDirection(dx, dy, dz);
                    this.wandered = true;
                    return;
                }
            }
            --this.checkCooldown;
            --this.findBlocksCooldown;
        }

        public boolean func_75253_b() {
            return !this.wandered && this.canMove() && !((EntityWallFace)this.entity).isMoving();
        }
    }

    protected static abstract class AITrackTarget<T extends EntityMovingWallFace>
    extends EntityAIBase {
        protected final T entity;
        protected int findBlocksCooldown = 0;
        protected List<BlockPos> trackingBlocks;
        protected int checkCooldown = 0;
        protected boolean stayInRange;
        protected double maxRangeSq;

        public AITrackTarget(T entity) {
            this(entity, false, 0.0);
        }

        public AITrackTarget(T entity, boolean stayInRange, double maxRange) {
            this.entity = entity;
            this.stayInRange = stayInRange;
            this.maxRangeSq = maxRange * maxRange;
            this.func_75248_a(3);
        }

        protected abstract boolean canMove();

        protected boolean isTargetVisibleAndInRange() {
            return this.entity.func_70635_at().func_75522_a((Entity)this.entity.func_70638_az()) && (!this.stayInRange || this.entity.func_70638_az().func_70068_e(this.entity) <= this.maxRangeSq);
        }

        public boolean func_75250_a() {
            return this.entity.func_70089_S() && this.canMove() && !((EntityWallFace)this.entity).isMoving() && this.entity.func_70638_az() != null && this.entity.func_70638_az().func_70089_S() && !this.isTargetVisibleAndInRange();
        }

        public void func_75249_e() {
            this.checkCooldown = 0;
            this.findBlocksCooldown = 20 + ((EntityMovingWallFace)this.entity).field_70146_Z.nextInt(30);
            this.trackingBlocks = null;
        }

        public void func_75246_d() {
            EntityLivingBase target = this.entity.func_70638_az();
            if (target != null && this.canMove()) {
                if (this.findBlocksCooldown <= 0 && (this.trackingBlocks == null || this.trackingBlocks.isEmpty())) {
                    this.findBlocksCooldown = 20 + ((EntityMovingWallFace)this.entity).field_70146_Z.nextInt(40);
                    this.trackingBlocks = ((EntityMovingWallFace)this.entity).findNearbyBlocksForMovement();
                }
                if (this.trackingBlocks != null && !this.trackingBlocks.isEmpty() && this.checkCooldown <= 0) {
                    this.checkCooldown = 5 + ((EntityMovingWallFace)this.entity).field_70146_Z.nextInt(15);
                    block0: for (int i = 0; i < 16 && !this.trackingBlocks.isEmpty(); ++i) {
                        BlockPos pos = this.trackingBlocks.remove(((EntityMovingWallFace)this.entity).field_70146_Z.nextInt(this.trackingBlocks.size()));
                        if (this.stayInRange && !(target.func_174831_c(pos) <= this.maxRangeSq)) continue;
                        Vec3d center = new Vec3d((double)pos.func_177958_n() + (double)((EntityWallFace)this.entity).getBlockWidth() / 2.0, (double)pos.func_177956_o() + (double)((EntityWallFace)this.entity).getBlockHeight() / 2.0, (double)pos.func_177952_p() + (double)((EntityWallFace)this.entity).getBlockWidth() / 2.0);
                        Vec3d lookDir = target.func_174791_d().func_72441_c(0.0, (double)target.func_70047_e(), 0.0).func_178788_d(center);
                        EnumFacing facing = EnumFacing.func_176737_a((float)((float)lookDir.field_72450_a), (float)((float)lookDir.field_72448_b), (float)((float)lookDir.field_72449_c));
                        if (this.canSeeFrom(pos, facing, (Entity)target) && ((EntityWallFace)this.entity).checkAnchorAt(center, lookDir, 7) == 0) {
                            ((EntityMovingWallFace)this.entity).field_70765_h.func_75642_a(center.field_72450_a, center.field_72448_b, center.field_72449_c, 1.0);
                            ((EntityMovingWallFace)this.entity).field_70749_g.setLookDirection(facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e());
                            break;
                        }
                        for (EnumFacing otherFacing : EnumFacing.field_176754_o) {
                            if (otherFacing == facing) continue;
                            lookDir = new Vec3d((double)otherFacing.func_82601_c(), 0.0, (double)otherFacing.func_82599_e());
                            if (!this.canSeeFrom(pos, otherFacing, (Entity)target) || ((EntityWallFace)this.entity).checkAnchorAt(center, lookDir, 7) != 0) continue;
                            ((EntityMovingWallFace)this.entity).field_70765_h.func_75642_a(center.field_72450_a, center.field_72448_b, center.field_72449_c, 1.0);
                            ((EntityMovingWallFace)this.entity).field_70749_g.setLookDirection(otherFacing.func_82601_c(), otherFacing.func_96559_d(), otherFacing.func_82599_e());
                            continue block0;
                        }
                    }
                }
                --this.checkCooldown;
                --this.findBlocksCooldown;
            }
        }

        protected boolean canSeeFrom(BlockPos pos, EnumFacing facing, Entity entity) {
            return ((EntityMovingWallFace)this.entity).field_70170_p.func_147447_a(new Vec3d((double)pos.func_177958_n() + (double)((EntityWallFace)this.entity).getBlockWidth() / 2.0 + (double)((float)facing.func_82601_c() * (((EntityMovingWallFace)this.entity).field_70130_N / 2.0f + ((EntityWallFace)this.entity).getPeek())), (double)pos.func_177956_o() + (double)((EntityWallFace)this.entity).getBlockHeight() / 2.0 + (double)((float)facing.func_96559_d() * (((EntityMovingWallFace)this.entity).field_70131_O / 2.0f + ((EntityWallFace)this.entity).getPeek())), (double)pos.func_177952_p() + (double)((EntityWallFace)this.entity).getBlockWidth() / 2.0 + (double)((float)facing.func_82599_e() * (((EntityMovingWallFace)this.entity).field_70130_N / 2.0f + ((EntityWallFace)this.entity).getPeek()))), new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), false, true, false) == null;
        }

        public boolean func_75253_b() {
            return !((EntityWallFace)this.entity).isMoving() && this.entity.func_70638_az() != null && this.entity.func_70638_az().func_70089_S() && !this.isTargetVisibleAndInRange();
        }
    }
}

