/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.entity.ai.EntityAIHurtByTargetImproved;
import thebetweenlands.common.entity.mobs.EntityBloodSnail;
import thebetweenlands.common.entity.mobs.EntityChiromaw;
import thebetweenlands.common.entity.mobs.EntityDragonFly;
import thebetweenlands.common.entity.mobs.EntityFrog;
import thebetweenlands.common.entity.mobs.EntityMireSnail;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.PlayerUtil;

public class EntityShambler
extends EntityMob
implements IEntityMultiPart,
IEntityBL {
    private static final DataParameter<Boolean> JAWS_OPEN = EntityDataManager.func_187226_a(EntityShambler.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TONGUE_EXTEND = EntityDataManager.func_187226_a(EntityShambler.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> JAW_ANGLE = EntityDataManager.func_187226_a(EntityShambler.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TONGUE_LENGTH = EntityDataManager.func_187226_a(EntityShambler.class, (DataSerializer)DataSerializers.field_187192_b);
    private int prevJawAngle;
    private int prevTongueLength;
    public MultiPartEntityPart[] tongue_array;
    public MultiPartEntityPart tongue_end = new MultiPartEntityPart((IEntityMultiPart)this, "tongue_end", 0.5f, 0.5f);

    public EntityShambler(World world) {
        super(world);
        this.func_70105_a(0.95f, 1.25f);
        this.tongue_array = new MultiPartEntityPart[16];
        for (int i = 0; i < this.tongue_array.length - 1; ++i) {
            this.tongue_array[i] = new MultiPartEntityPart((IEntityMultiPart)this, "tongue_" + i, 0.125f, 0.125f);
        }
        this.tongue_array[this.tongue_array.length - 1] = this.tongue_end;
    }

    public World func_82194_d() {
        return this.func_130014_f_();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.8, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTargetImproved((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 3, true, true, null).func_190882_b(120));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityFrog.class, 3, true, true, null).func_190882_b(120));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityChiromaw.class, 3, true, true, null).func_190882_b(120));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMireSnail.class, 3, true, true, null).func_190882_b(120));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityBloodSnail.class, 3, true, true, null).func_190882_b(120));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityDragonFly.class, 3, true, true, null).func_190882_b(120));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(JAWS_OPEN, (Object)false);
        this.field_70180_af.func_187214_a(TONGUE_EXTEND, (Object)false);
        this.field_70180_af.func_187214_a(JAW_ANGLE, (Object)0);
        this.field_70180_af.func_187214_a(TONGUE_LENGTH, (Object)0);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.SHAMBLER;
    }

    public boolean jawsAreOpen() {
        return (Boolean)this.field_70180_af.func_187225_a(JAWS_OPEN);
    }

    public void setOpenJaws(boolean jawState) {
        this.field_70180_af.func_187227_b(JAWS_OPEN, (Object)jawState);
    }

    public boolean isExtendingTongue() {
        return (Boolean)this.field_70180_af.func_187225_a(TONGUE_EXTEND);
    }

    public void setExtendingTongue(boolean tongueState) {
        this.field_70180_af.func_187227_b(TONGUE_EXTEND, (Object)tongueState);
    }

    public void setJawAngle(int count) {
        this.field_70180_af.func_187227_b(JAW_ANGLE, (Object)count);
    }

    public void setJawAnglePrev(int count) {
        this.prevJawAngle = count;
    }

    public void setTongueLength(int count) {
        this.field_70180_af.func_187227_b(TONGUE_LENGTH, (Object)count);
    }

    public void setTongueLengthPrev(int count) {
        this.prevTongueLength = count;
    }

    public int getJawAngle() {
        return (Integer)this.field_70180_af.func_187225_a(JAW_ANGLE);
    }

    public int getJawAnglePrev() {
        return this.prevJawAngle;
    }

    public int getTongueLength() {
        return (Integer)this.field_70180_af.func_187225_a(TONGUE_LENGTH);
    }

    public int getTongueLengthPrev() {
        return this.prevTongueLength;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 3;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 1.5f;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.SHAMBLER_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundRegistry.SHAMBLER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.SHAMBLER_DEATH;
    }

    public void func_70636_d() {
        this.setJawAnglePrev(this.getJawAngle());
        this.setTongueLengthPrev(this.getTongueLength());
        if (!this.func_130014_f_().field_72995_K) {
            if (this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az())) {
                this.func_70625_a((Entity)this.func_70638_az(), 10.0f, 20.0f);
                double distance = this.func_70011_f(this.func_70638_az().field_70165_t, this.func_70638_az().func_174813_aQ().field_72338_b, this.func_70638_az().field_70161_v);
                if (distance > 5.0 && this.jawsAreOpen()) {
                    this.setOpenJaws(false);
                    if (this.isExtendingTongue()) {
                        this.setExtendingTongue(false);
                    }
                }
                if (distance <= 5.0 && distance >= 1.0 && !this.jawsAreOpen()) {
                    this.setOpenJaws(true);
                    if (!this.isExtendingTongue()) {
                        this.setExtendingTongue(true);
                        this.func_184185_a(SoundRegistry.SHAMBLER_LICK, 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.3f);
                    }
                }
            }
            if (this.func_70638_az() == null) {
                if (this.jawsAreOpen()) {
                    this.setOpenJaws(false);
                }
                if (this.isExtendingTongue()) {
                    this.setExtendingTongue(false);
                }
            }
            if (this.getJawAngle() > 0 && !this.jawsAreOpen()) {
                this.setJawAngle(this.getJawAngle() - 1);
            }
            if (this.jawsAreOpen() && this.getJawAngle() <= 10) {
                this.setJawAngle(this.getJawAngle() + 1);
            }
            if (this.getJawAngle() < 0 && !this.jawsAreOpen()) {
                this.setJawAngle(0);
            }
            if (this.jawsAreOpen() && this.getJawAngle() > 10) {
                this.setJawAngle(10);
            }
            if (this.getTongueLength() > 0 && !this.isExtendingTongue()) {
                this.setTongueLength(this.getTongueLength() - 1);
            }
            if (this.isExtendingTongue() && this.getTongueLength() <= 9) {
                this.setTongueLength(this.getTongueLength() + 1);
            }
            if (this.getTongueLength() < 0 && !this.isExtendingTongue()) {
                this.setTongueLength(0);
            }
            if (this.isExtendingTongue() && this.getTongueLength() > 9) {
                this.setTongueLength(9);
                this.setExtendingTongue(false);
            }
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        double lengthIncrement;
        super.func_70071_h_();
        Vec3d vector = this.func_70676_i(1.0f);
        double offSetX = vector.field_72450_a * -0.25;
        double offsetY = vector.field_72448_b * -0.25;
        double offSetZ = vector.field_72449_c * -0.25;
        double tongueLength = lengthIncrement = 0.5 / (double)this.tongue_array.length;
        for (MultiPartEntityPart part : this.tongue_array) {
            part.field_70126_B = part.field_70177_z;
            part.field_70127_C = part.field_70125_A;
            part.field_70142_S = part.field_70169_q = part.field_70165_t;
            part.field_70137_T = part.field_70167_r = part.field_70163_u;
            part.field_70136_U = part.field_70166_s = part.field_70161_v;
            part.func_70107_b(this.field_70165_t + offSetX + vector.field_72450_a * (double)this.getTongueLength() * tongueLength, this.field_70163_u + (double)this.func_70047_e() - 0.32 + offsetY + vector.field_72448_b * (double)this.getTongueLength() * tongueLength, this.field_70161_v + offSetZ + vector.field_72449_c * (double)this.getTongueLength() * tongueLength);
            part.field_70177_z = this.field_70177_z;
            part.field_70125_A = this.field_70125_A;
            tongueLength += lengthIncrement;
        }
        this.checkCollision();
    }

    public void func_184232_k(Entity entity) {
        PlayerUtil.resetFloating(entity);
        if (entity instanceof EntityLivingBase) {
            double a = Math.toRadians(this.field_70177_z);
            double offSetX = Math.sin(a) * (double)this.getTongueLength() > 0.0 ? -0.125 : -0.35;
            double offSetZ = -Math.cos(a) * (double)this.getTongueLength() > 0.0 ? -0.125 : -0.35;
            entity.func_70107_b(this.tongue_end.field_70165_t + offSetX, this.tongue_end.field_70163_u - (double)entity.field_70131_O * 0.3, this.tongue_end.field_70161_v + offSetZ);
            if (entity.func_70093_af()) {
                entity.func_70095_a(false);
            }
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    protected Entity checkCollision() {
        List list = this.func_130014_f_().func_72872_a(EntityLivingBase.class, this.tongue_end.func_174813_aQ());
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || entity != this.func_70638_az() || entity instanceof IEntityMultiPart || entity instanceof MultiPartEntityPart || !(entity instanceof EntityLivingBase) || this.func_184207_aI()) continue;
            entity.func_184205_a((Entity)this, true);
            if (this.func_130014_f_().field_72995_K || !this.isExtendingTongue()) continue;
            this.setExtendingTongue(false);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public float smoothedAngle(float partialTicks) {
        return (float)this.getJawAnglePrev() + (float)(this.getJawAngle() - this.getJawAnglePrev()) * partialTicks;
    }

    public boolean func_70652_k(Entity entity) {
        return this.func_70685_l(entity) ? super.func_70652_k(entity) : false;
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float dmg) {
        this.damageShambler(source, dmg);
        return true;
    }

    protected boolean damageShambler(DamageSource source, float ammount) {
        return super.func_70097_a(source, ammount);
    }
}

