/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.entity.mobs.EntitySwampHag;
import thebetweenlands.common.entity.mobs.EntityWight;

public class EntityVolatileSoul
extends Entity
implements IProjectile,
IEntityBL {
    private Entity target = null;
    private int strikes = 0;
    private int ticksInAir;
    protected static final DataParameter<Optional<UUID>> OWNER_UUID_DW = EntityDataManager.func_187226_a(EntityVolatileSoul.class, (DataSerializer)DataSerializers.field_187203_m);
    protected Deque<Vec3d> trail = new LinkedList<Vec3d>();

    public EntityVolatileSoul(World world) {
        super(world);
        this.func_70105_a(0.3f, 0.3f);
        this.field_70145_X = true;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(OWNER_UUID_DW, (Object)Optional.absent());
    }

    public void setOwner(UUID uuid) {
        this.func_184212_Q().func_187227_b(OWNER_UUID_DW, (Object)Optional.of((Object)uuid));
    }

    public UUID getOwnerUUID() {
        Optional optional = (Optional)this.func_184212_Q().func_187225_a(OWNER_UUID_DW);
        return optional.isPresent() ? (UUID)optional.get() : null;
    }

    public Entity getOwner() {
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : this.getEntityByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    private Entity getEntityByUUID(UUID p_152378_1_) {
        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
            if (!p_152378_1_.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }

    protected void onImpact(RayTraceResult target) {
        if (target.field_72308_g != null && target.field_72308_g instanceof EntityLivingBase && !(target.field_72308_g instanceof EntityWight) && !(target.field_72308_g instanceof EntitySwampHag) && !this.field_70170_p.field_72995_K) {
            if (target.field_72308_g instanceof EntityPlayer && ((EntityPlayer)target.field_72308_g).func_184585_cz() && ((EntityPlayer)target.field_72308_g).func_184605_cv() <= 15) {
                this.field_70159_w *= -6.0;
                this.field_70181_x *= -6.0;
                this.field_70179_y *= -6.0;
                ++this.strikes;
                return;
            }
            target.field_72308_g.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.getOwner()), 3.0f);
            if (!this.field_70128_L && target.field_72308_g instanceof EntityPlayer && (target.field_72308_g.field_70128_L || ((EntityLivingBase)target.field_72308_g).func_110143_aJ() <= 0.0f)) {
                target.field_72308_g.func_70106_y();
            }
            this.func_70106_y();
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_180431_b(source)) {
            return false;
        }
        ++this.strikes;
        if (this.strikes >= 3) {
            this.func_70106_y();
            return true;
        }
        this.func_70018_K();
        if (source.func_76346_g() != null) {
            Vec3d vec3;
            if (!this.field_70170_p.field_72995_K && (vec3 = source.func_76346_g().func_70040_Z()) != null) {
                this.field_70159_w = vec3.field_72450_a * 1.5;
                this.field_70181_x = vec3.field_72448_b * 1.5;
                this.field_70179_y = vec3.field_72449_c * 1.5;
            }
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL || this.getOwner() == null || this.getOwner().field_70128_L)) {
            this.func_70106_y();
            return;
        }
        if (!(this.field_70170_p.field_72995_K || this.getOwner() != null && this.getOwner().func_70089_S() && this.getOwner() instanceof EntityWight && ((EntityWight)this.getOwner()).isVolatile())) {
            this.func_70106_y();
        }
        if (!this.field_70128_L) {
            ++this.ticksInAir;
            if (this.field_70170_p.field_72995_K) {
                this.trail.push(this.func_174791_d());
                while (this.trail.size() > 4) {
                    this.trail.removeLast();
                }
            }
            if (this.target == null || this.target.field_70128_L) {
                List targetList = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0));
                ArrayList<Object> eligibleTargets = new ArrayList<Object>();
                if (this.field_70170_p.field_73012_v.nextInt(4) > 0) {
                    for (Entity e : targetList) {
                        if (!(e instanceof EntityPlayer)) continue;
                        eligibleTargets.add((EntityPlayer)e);
                    }
                }
                if (eligibleTargets.isEmpty()) {
                    for (Entity e : targetList) {
                        if (e instanceof EntityWight) continue;
                        eligibleTargets.add(e);
                    }
                }
                if (!eligibleTargets.isEmpty()) {
                    this.target = (Entity)eligibleTargets.get(this.field_70170_p.field_73012_v.nextInt(eligibleTargets.size()));
                }
            }
            if (this.target != null && this.ticksInAir >= 10) {
                double dx = this.target.func_174813_aQ().field_72340_a + (this.target.func_174813_aQ().field_72336_d - this.target.func_174813_aQ().field_72340_a) / 2.0 - this.field_70165_t;
                double dy = this.target.func_174813_aQ().field_72338_b + (this.target.func_174813_aQ().field_72337_e - this.target.func_174813_aQ().field_72338_b) / 2.0 - this.field_70163_u;
                double dz = this.target.func_174813_aQ().field_72339_c + (this.target.func_174813_aQ().field_72334_f - this.target.func_174813_aQ().field_72339_c) / 2.0 - this.field_70161_v;
                double dist = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
                double speed = 0.075;
                double maxSpeed = 0.8;
                this.field_70159_w += dx / dist * speed;
                this.field_70181_x += dy / dist * speed;
                this.field_70179_y += dz / dist * speed;
                Vec3d motion = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                if (motion.func_72433_c() > maxSpeed) {
                    motion = motion.func_72432_b();
                    this.field_70159_w = motion.field_72450_a * maxSpeed;
                    this.field_70181_x = motion.field_72448_b * maxSpeed;
                    this.field_70179_y = motion.field_72449_c * maxSpeed;
                }
            }
            Vec3d currentPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d nextPos = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult hitObject = this.field_70170_p.func_72933_a(currentPos, nextPos);
            currentPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            nextPos = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (hitObject != null) {
                nextPos = new Vec3d(hitObject.field_72307_f.field_72450_a, hitObject.field_72307_f.field_72448_b, hitObject.field_72307_f.field_72449_c);
            }
            Entity hitEntity = null;
            List hitEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(2.0, 2.0, 2.0));
            double minDist = 0.0;
            for (int i = 0; i < hitEntities.size(); ++i) {
                double d1;
                Entity entity1 = (Entity)hitEntities.get(i);
                if (!entity1.func_70067_L() || this.ticksInAir < 10) continue;
                float f = 0.3f;
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f);
                RayTraceResult movingobjectposition1 = axisalignedbb.func_72327_a(currentPos, nextPos);
                if (movingobjectposition1 == null || !((d1 = currentPos.func_72438_d(movingobjectposition1.field_72307_f)) < minDist) && minDist != 0.0) continue;
                hitEntity = entity1;
                minDist = d1;
            }
            if (hitEntity != null) {
                hitObject = new RayTraceResult(hitEntity);
            }
            if (hitObject != null) {
                this.onImpact(hitObject);
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        super.func_70071_h_();
    }

    public void func_70186_c(double x, double y, double z, float speed, float randMotion) {
        float f2 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)randMotion;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)randMotion;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)randMotion;
        this.field_70159_w = x *= (double)speed;
        this.field_70181_x = y *= (double)speed;
        this.field_70179_y = z *= (double)speed;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("ownerUUID")) {
            this.setOwner(nbt.func_186857_a("ownerUUID"));
        }
        if (nbt.func_74764_b("strikes")) {
            this.strikes = nbt.func_74762_e("strikes");
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        UUID ownerUuid = this.getOwnerUUID();
        if (ownerUuid != null) {
            nbt.func_186854_a("ownerUUID", ownerUuid);
        }
        nbt.func_74768_a("strikes", this.strikes);
    }

    @SideOnly(value=Side.CLIENT)
    public Collection<Vec3d> getTrail() {
        return this.trail;
    }
}

