/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IDecayCapability;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.capability.decay.DecayStats;
import thebetweenlands.common.entity.ai.EntityAIAttackOnCollide;
import thebetweenlands.common.entity.ai.EntityAIHurtByTargetImproved;
import thebetweenlands.common.entity.mobs.EntityMovingWallFace;
import thebetweenlands.common.entity.mobs.EntityWallFace;
import thebetweenlands.common.entity.projectiles.EntitySludgeWallJet;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityWallLamprey
extends EntityMovingWallFace
implements IMob {
    public static final byte EVENT_START_THE_SUCC = 80;
    private static final DataParameter<Boolean> HIDDEN = EntityDataManager.func_187226_a(EntityWallLamprey.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> LOOK_X = EntityDataManager.func_187226_a(EntityWallLamprey.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> LOOK_Y = EntityDataManager.func_187226_a(EntityWallLamprey.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> LOOK_Z = EntityDataManager.func_187226_a(EntityWallLamprey.class, (DataSerializer)DataSerializers.field_187193_c);
    private float prevHiddenPercent = 1.0f;
    private float hiddenPercent = 1.0f;
    private Vec3d prevHeadLook = Vec3d.field_186680_a;
    private Vec3d headLook = Vec3d.field_186680_a;
    private boolean clientHeadLookChanged = false;
    private int suckTimer = 0;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite wallSprite;

    public EntityWallLamprey(World world) {
        super(world);
        this.lookMoveSpeedMultiplier = 15.0f;
        this.field_70728_aV = 5;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HIDDEN, (Object)true);
        this.field_70180_af.func_187214_a(LOOK_X, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LOOK_Y, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LOOK_Z, (Object)Float.valueOf(0.0f));
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTargetImproved(this, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null).func_190882_b(120));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AITrackTargetLamprey(this, true, 28.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityMovingWallFace.AIAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISuck(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISpit(this, 3.0f));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.08);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (LOOK_X.equals(key) || LOOK_Y.equals(key) || LOOK_Z.equals(key)) {
            this.clientHeadLookChanged = true;
        }
    }

    @Override
    protected boolean isTravelBlocked() {
        return super.isTravelBlocked() || this.isSucking();
    }

    @Override
    public void func_70071_h_() {
        block16: {
            this.prevHeadLook = this.headLook;
            super.func_70071_h_();
            if (this.clientHeadLookChanged) {
                this.headLook = new Vec3d((double)((Float)this.field_70180_af.func_187225_a(LOOK_X)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(LOOK_Y)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(LOOK_Z)).floatValue());
                this.clientHeadLookChanged = false;
            }
            if (!this.field_70170_p.field_72995_K) {
                EntityLivingBase attackTarget = this.func_70638_az();
                this.field_70180_af.func_187227_b(HIDDEN, (Object)(attackTarget == null ? 1 : 0));
                if (attackTarget != null) {
                    this.setHeadLook(attackTarget.func_174824_e(1.0f).func_178788_d(this.func_174824_e(1.0f)));
                } else {
                    this.setHeadLook(new Vec3d(this.getFacing().func_176730_m()));
                }
            } else {
                this.prevHiddenPercent = this.hiddenPercent;
                if (((Boolean)this.field_70180_af.func_187225_a(HIDDEN)).booleanValue()) {
                    if (this.hiddenPercent < 1.0f) {
                        this.hiddenPercent += 0.01f;
                        if (this.hiddenPercent > 1.0f) {
                            this.hiddenPercent = 1.0f;
                        }
                    }
                } else if (this.hiddenPercent > 0.0f) {
                    this.hiddenPercent -= 0.04f;
                    if (this.hiddenPercent < 0.0f) {
                        this.hiddenPercent = 0.0f;
                    }
                }
                this.updateWallSprite();
            }
            if (!this.isSucking()) break block16;
            --this.suckTimer;
            if (!this.field_70170_p.field_72995_K) {
                List affectedEntities = this.field_70170_p.func_72872_a(Entity.class, this.func_174813_aQ().func_72314_b(6.0, 6.0, 6.0));
                for (Entity e : affectedEntities) {
                    float dst = e.func_70032_d((Entity)this);
                    if (e == this || dst > 6.0f || !this.func_70685_l(e) || e instanceof IEntityBL) continue;
                    Vec3d vec = new Vec3d(this.field_70165_t - e.field_70165_t, this.field_70163_u - e.field_70163_u, this.field_70161_v - e.field_70161_v);
                    vec = vec.func_72432_b();
                    float mod = (float)Math.pow(1.0f - dst / 6.0f, 1.3);
                    if (e instanceof EntityPlayer && ((EntityPlayer)e).func_184585_cz()) {
                        mod *= 0.18f;
                    }
                    e.field_70159_w += vec.field_72450_a * (double)0.1f * (double)mod;
                    e.field_70181_x += vec.field_72448_b * (double)0.215f * (double)mod;
                    e.field_70179_y += vec.field_72449_c * (double)0.1f * (double)mod;
                    e.field_70133_I = true;
                }
            } else {
                Vec3d fwd = this.getHeadLook(1.0f);
                Vec3d up = new Vec3d(this.getFacingUp().func_176730_m());
                Vec3d right = fwd.func_72431_c(up);
                Vec3d front = this.getFrontCenter().func_178787_e(fwd.func_186678_a(0.3)).func_178787_e(up.func_186678_a(-0.3));
                for (int i = 0; i < 3; ++i) {
                    Random rnd = this.field_70170_p.field_73012_v;
                    Vec3d vec = fwd.func_186678_a((double)(rnd.nextFloat() * 5.0f)).func_178787_e(up.func_186678_a((double)((rnd.nextFloat() - 0.5f) * 1.2f))).func_178787_e(right.func_186678_a((double)((rnd.nextFloat() - 0.5f) * 1.2f)));
                    float rx = (float)vec.field_72450_a;
                    float ry = (float)vec.field_72448_b;
                    float rz = (float)vec.field_72449_c;
                    vec = vec.func_72432_b();
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, front.field_72450_a + (double)rx, front.field_72448_b + (double)ry, front.field_72449_c + (double)rz, -vec.field_72450_a * 0.5, -vec.field_72448_b * 0.5, -vec.field_72449_c * 0.5, new int[0]);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateWallSprite() {
        this.wallSprite = null;
        BlockPos pos = this.func_180425_c();
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        if ((state = state.func_185899_b((IBlockAccess)this.field_70170_p, pos)).func_185917_h()) {
            this.wallSprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        }
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getWallSprite() {
        return this.wallSprite;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean hasAttacked = false;
        IDecayCapability cap = (IDecayCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null);
        if (cap != null && cap.isDecayEnabled()) {
            float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            if (EntityAIAttackOnCollide.useStandardAttack((EntityLiving)this, entity, attackDamage / 3.0f, !this.isSucking())) {
                hasAttacked = true;
                DecayStats stats = cap.getDecayStats();
                stats.addDecayAcceleration(attackDamage * 2.0f);
            }
        } else {
            hasAttacked = super.func_70652_k(entity);
        }
        if (hasAttacked) {
            this.func_184185_a(SoundRegistry.WALL_LAMPREY_ATTACK, 1.0f, 1.0f);
        }
        return hasAttacked;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.WALL_LAMPREY;
    }

    @Override
    public boolean canResideInBlock(BlockPos pos, EnumFacing facing, EnumFacing facingUp) {
        return this.isValidBlockForMovement(pos, this.field_70170_p.func_180495_p(pos)) && this.isValidBlockForMovement(pos.func_177972_a(facingUp.func_176734_d()), this.field_70170_p.func_180495_p(pos.func_177972_a(facingUp.func_176734_d())));
    }

    @Override
    public int checkAnchorAt(BlockPos anchor, EnumFacing facing, EnumFacing facingUp, int checks) {
        int violations = super.checkAnchorAt(anchor, facing, facingUp, checks);
        if ((checks & 4) != 0 && !this.field_70170_p.func_175647_a(EntityWallFace.class, this.func_174813_aQ().func_186670_a(anchor.func_177973_b((Vec3i)this.getAnchor()).func_177972_a(facingUp.func_176734_d())).func_72321_a((double)((float)facing.func_82601_c() * this.getPeek()), (double)((float)facing.func_96559_d() * this.getPeek()), (double)((float)facing.func_82599_e() * this.getPeek())), e -> e != this).isEmpty()) {
            violations |= 4;
        }
        return violations;
    }

    @Override
    protected boolean isValidBlockForMovement(BlockPos pos, IBlockState state) {
        return state.func_185914_p() && state.func_185915_l() && state.func_185917_h() && state.func_185887_b(this.field_70170_p, pos) > 0.0f && (state.func_185904_a() == Material.field_151576_e || state.func_185904_a() == Material.field_151575_d);
    }

    @Override
    public Vec3d getOffset(float movementProgress) {
        return super.getOffset(1.0f);
    }

    public float getHoleDepthPercent(float partialTicks) {
        return this.getHalfMovementProgress(partialTicks);
    }

    public float getLampreyHiddenPercent(float partialTicks) {
        return 1.0f - (1.0f - this.easeInOut(this.prevHiddenPercent + (this.hiddenPercent - this.prevHiddenPercent) * partialTicks)) * this.getHoleDepthPercent(partialTicks);
    }

    private float easeInOut(float percent) {
        float sq = percent * percent;
        return sq / (2.0f * (sq - percent) + 1.0f);
    }

    public void setHeadLook(Vec3d look) {
        look = look.func_72432_b();
        Vec3d curr = this.headLook;
        if (Math.abs(curr.field_72450_a - look.field_72450_a) >= (double)0.01f || Math.abs(curr.field_72448_b - look.field_72448_b) >= (double)0.01f || Math.abs(curr.field_72449_c - look.field_72449_c) >= (double)0.01f) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_187227_b(LOOK_X, (Object)Float.valueOf((float)look.field_72450_a));
                this.field_70180_af.func_187227_b(LOOK_Y, (Object)Float.valueOf((float)look.field_72448_b));
                this.field_70180_af.func_187227_b(LOOK_Z, (Object)Float.valueOf((float)look.field_72449_c));
            }
            this.headLook = look;
        }
    }

    public Vec3d getHeadLook(float partialTicks) {
        return new Vec3d(this.prevHeadLook.field_72450_a + (this.headLook.field_72450_a - this.prevHeadLook.field_72450_a) * (double)partialTicks, this.prevHeadLook.field_72448_b + (this.headLook.field_72448_b - this.prevHeadLook.field_72448_b) * (double)partialTicks, this.prevHeadLook.field_72449_c + (this.headLook.field_72449_c - this.prevHeadLook.field_72449_c) * (double)partialTicks);
    }

    public float[] getRelativeHeadLookAngles(float partialTicks) {
        Vec3d headLook = this.getHeadLook(partialTicks);
        Vec3d fwdAxis = new Vec3d(this.getFacing().func_176730_m());
        Vec3d upAxis = new Vec3d(this.getFacingUp().func_176730_m());
        Vec3d rightAxis = fwdAxis.func_72431_c(upAxis);
        double fwd = fwdAxis.func_72430_b(headLook);
        double up = upAxis.func_72430_b(headLook);
        double right = rightAxis.func_72430_b(headLook);
        return new float[]{(float)Math.toDegrees(Math.atan2(right, fwd)), (float)Math.toDegrees(Math.atan2(fwd, up)) * (float)Math.signum(fwd) - 90.0f};
    }

    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 80) {
            this.startSucking();
        }
    }

    public void startSucking() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)80);
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.WALL_LAMPREY_SUCK, SoundCategory.HOSTILE, 0.8f, this.field_70170_p.field_73012_v.nextFloat() * 0.3f + 0.8f);
        }
        this.suckTimer = 30 + this.field_70170_p.field_73012_v.nextInt(20);
    }

    public boolean isSucking() {
        return this.suckTimer > 0;
    }

    public void startSpit(float spitDamage) {
        EntityLivingBase target = this.func_70638_az();
        if (target != null) {
            EnumFacing facing = this.getFacing();
            EntitySludgeWallJet jet = new EntitySludgeWallJet(this.field_70170_p, (EntityLiving)this);
            jet.func_70107_b(this.field_70165_t + (double)((float)facing.func_82601_c() * (this.field_70130_N / 2.0f + 0.1f)), this.field_70163_u + (double)(this.field_70131_O / 2.0f) + (double)((float)facing.func_96559_d() * (this.field_70131_O / 2.0f + 0.1f)), this.field_70161_v + (double)((float)facing.func_82599_e() * (this.field_70130_N / 2.0f + 0.1f)));
            double dx = target.field_70165_t - jet.field_70165_t;
            double dy = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - jet.field_70163_u;
            double dz = target.field_70161_v - jet.field_70161_v;
            double dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
            jet.func_70186_c(dx, dy + dist * 0.2, dz, 1.0f, 1.0f);
            this.field_70170_p.func_72838_d((Entity)jet);
        }
    }

    protected static class AISpit
    extends EntityAIBase {
        protected final EntityWallLamprey entity;
        protected int minCooldown;
        protected int maxCooldown;
        protected int cooldown = 0;
        protected float spitDamage;

        public AISpit(EntityWallLamprey entity, float spitDamage) {
            this(entity, spitDamage, 50, 170);
        }

        public AISpit(EntityWallLamprey entity, float spitDamage, int minCooldown, int maxCooldown) {
            this.entity = entity;
            this.minCooldown = minCooldown;
            this.maxCooldown = maxCooldown;
            this.spitDamage = spitDamage;
            this.func_75248_a(0);
        }

        protected boolean isInRange(EntityLivingBase target) {
            Vec3d down = new Vec3d(0.0, -1.0, 0.0);
            Vec3d dir = target.func_174791_d().func_178788_d(this.entity.func_174791_d()).func_72432_b();
            return Math.acos(down.func_72430_b(dir)) < 0.733;
        }

        public boolean func_75250_a() {
            return this.entity.getFacing() == EnumFacing.DOWN && !this.entity.isSucking() && !this.entity.isMoving() && this.entity.func_70638_az() != null && this.entity.func_70638_az().func_70089_S() && this.entity.func_70635_at().func_75522_a((Entity)this.entity.func_70638_az()) && this.isInRange(this.entity.func_70638_az());
        }

        public void func_75249_e() {
            this.cooldown = 20 + this.entity.field_70146_Z.nextInt(40);
        }

        public void func_75246_d() {
            if (!this.entity.isSucking()) {
                if (this.cooldown <= 0) {
                    this.cooldown = this.minCooldown + this.entity.field_70146_Z.nextInt(this.maxCooldown - this.minCooldown + 1);
                    this.entity.startSpit(this.getSpitDamage());
                }
                --this.cooldown;
            }
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        protected float getSpitDamage() {
            return this.spitDamage;
        }
    }

    protected static class AISuck
    extends EntityAIBase {
        protected final EntityWallLamprey entity;
        protected int minCooldown;
        protected int maxCooldown;
        protected int cooldown = 0;

        public AISuck(EntityWallLamprey entity) {
            this(entity, 50, 140);
        }

        public AISuck(EntityWallLamprey entity, int minCooldown, int maxCooldown) {
            this.entity = entity;
            this.minCooldown = minCooldown;
            this.maxCooldown = maxCooldown;
            this.func_75248_a(0);
        }

        public boolean func_75250_a() {
            return this.entity.getFacing() != EnumFacing.DOWN && !this.entity.isSucking() && !this.entity.isMoving() && this.entity.func_70638_az() != null && this.entity.func_70638_az().func_70089_S() && this.entity.func_70635_at().func_75522_a((Entity)this.entity.func_70638_az()) && this.entity.func_70032_d((Entity)this.entity.func_70638_az()) < 6.0f;
        }

        public void func_75249_e() {
            this.cooldown = 20 + this.entity.field_70146_Z.nextInt(40);
        }

        public void func_75246_d() {
            if (!this.entity.isSucking()) {
                if (this.cooldown <= 0) {
                    this.cooldown = this.minCooldown + this.entity.field_70146_Z.nextInt(this.maxCooldown - this.minCooldown + 1);
                    this.entity.startSucking();
                }
                --this.cooldown;
            }
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }
    }

    public static class AITrackTargetLamprey
    extends EntityMovingWallFace.AITrackTarget<EntityWallLamprey> {
        public AITrackTargetLamprey(EntityWallLamprey entity, boolean stayInRange, double maxRange) {
            super(entity, stayInRange, maxRange);
        }

        public AITrackTargetLamprey(EntityWallLamprey entity) {
            super(entity);
        }

        @Override
        protected boolean canMove() {
            return !((EntityWallLamprey)this.entity).isSucking();
        }
    }
}

