/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.projectiles;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPredatorArrowGuide
extends Entity {
    private static final DataParameter<Integer> TARGET = EntityDataManager.func_187226_a(EntityPredatorArrowGuide.class, (DataSerializer)DataSerializers.field_187192_b);
    private int cachedTargetId = -1;
    private Entity cachedTarget;

    public EntityPredatorArrowGuide(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TARGET, (Object)-1);
    }

    public boolean func_70067_L() {
        return false;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Entity mountedEntity = this.func_184187_bx();
        if (mountedEntity == null) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        } else {
            this.updateHomingTrajectory(mountedEntity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        Entity ridingEntity = this.func_184187_bx();
        return ridingEntity != null ? ridingEntity.func_184177_bl() : super.func_184177_bl();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        Entity ridingEntity = this.func_184187_bx();
        return ridingEntity != null ? ridingEntity.func_145770_h(x, y, z) : super.func_145770_h(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        Entity ridingEntity = this.func_184187_bx();
        return ridingEntity != null ? ridingEntity.func_70112_a(distance) : super.func_70112_a(distance);
    }

    public void setTarget(@Nullable Entity target) {
        this.field_70180_af.func_187227_b(TARGET, (Object)(target == null ? -1 : target.func_145782_y()));
    }

    public Entity getTarget() {
        int targetId = (Integer)this.field_70180_af.func_187225_a(TARGET);
        if (targetId >= 0) {
            if (targetId == this.cachedTargetId) {
                return this.cachedTarget;
            }
            this.cachedTargetId = targetId;
            this.cachedTarget = this.field_70170_p.func_73045_a(this.cachedTargetId);
            return this.cachedTarget;
        }
        this.cachedTarget = null;
        this.cachedTargetId = -1;
        return null;
    }

    protected void updateHomingTrajectory(Entity mountedEntity) {
        if (!this.field_70170_p.field_72995_K) {
            Vec3d motion = new Vec3d(mountedEntity.field_70159_w, mountedEntity.field_70181_x, mountedEntity.field_70179_y);
            double speed = motion.func_72433_c();
            EntityLivingBase bestTarget = null;
            float maxFollowReach = 24.0f;
            float maxFollowAngle = 20.0f;
            float correctionMultiplier = 0.15f;
            double distanceMovedSq = (mountedEntity.field_70169_q - mountedEntity.field_70165_t) * (mountedEntity.field_70169_q - mountedEntity.field_70165_t) + (mountedEntity.field_70167_r - mountedEntity.field_70163_u) * (mountedEntity.field_70167_r - mountedEntity.field_70163_u) + (mountedEntity.field_70166_s - mountedEntity.field_70161_v) * (mountedEntity.field_70166_s - mountedEntity.field_70161_v);
            if (speed > 0.1 && distanceMovedSq > 0.01 && !mountedEntity.field_70122_E) {
                Vec3d heading = motion.func_72432_b();
                List nearbyEntities = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g((double)maxFollowReach), entity -> entity.func_70089_S() && entity instanceof IMob);
                double bestTargetScore = Double.MAX_VALUE;
                for (EntityLivingBase entity2 : nearbyEntities) {
                    Vec3d dir;
                    double angle;
                    double dist = entity2.func_70032_d(mountedEntity);
                    if (!(dist < (double)maxFollowReach) || !((angle = Math.toDegrees(Math.acos(heading.func_72430_b(dir = entity2.func_174824_e(1.0f).func_178788_d(mountedEntity.func_174824_e(1.0f)).func_72432_b())))) < (double)maxFollowAngle)) continue;
                    double score = dist * Math.max(angle, 0.01);
                    if (bestTarget != null && !(score < bestTargetScore) || !entity2.func_70685_l(mountedEntity)) continue;
                    bestTarget = entity2;
                    bestTargetScore = score;
                }
            }
            this.setTarget((Entity)bestTarget);
            if (bestTarget != null) {
                Vec3d newMotion = bestTarget.func_174824_e(1.0f).func_178788_d(mountedEntity.func_174824_e(1.0f)).func_72432_b().func_186678_a(speed * (double)correctionMultiplier).func_178787_e(motion.func_186678_a((double)(1.0f - correctionMultiplier)));
                mountedEntity.field_70159_w = newMotion.field_72450_a;
                mountedEntity.field_70181_x = newMotion.field_72448_b;
                mountedEntity.field_70179_y = newMotion.field_72449_c;
                mountedEntity.field_70133_I = true;
            }
        }
    }
}

