/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.herblore;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import net.minecraftforge.items.ItemHandlerHelper;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.herblore.ItemAspectVial;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.world.storage.location.LocationSludgeWormDungeon;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class ItemDentrothystVial
extends Item
implements ItemRegistry.IBlockStateItemModelDefinition {
    public ItemDentrothystVial() {
        this.func_77637_a(BLCreativeTabs.HERBLORE);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this, 1, 0));
            list.add((Object)new ItemStack((Item)this, 1, 1));
            list.add((Object)new ItemStack((Item)this, 1, 2));
        }
    }

    public String func_77667_c(ItemStack stack) {
        String s = "item.thebetweenlands.elixir.dentrothyst_vial.";
        try {
            switch (stack.func_77952_i()) {
                case 0: {
                    return s + "green";
                }
                case 1: {
                    return s + "dirty";
                }
                case 2: {
                    return s + "orange";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "item.thebetweenlands.unknown";
    }

    public ItemStack createStack(int vialType) {
        return new ItemStack((Item)this, 1, vialType);
    }

    public ItemStack createStack(int vialType, int size) {
        return new ItemStack((Item)this, size, vialType);
    }

    @Override
    public Map<Integer, String> getVariants() {
        HashMap<Integer, String> variants = new HashMap<Integer, String>();
        variants.put(0, "green");
        variants.put(1, "dirty");
        variants.put(2, "orange");
        return variants;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return world.func_180495_p(pos).func_177230_c() == BlockRegistry.ASPECT_VIAL_BLOCK;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && facing == EnumFacing.UP && stack.func_77952_i() != 1) {
            if (world.func_175623_d(pos.func_177984_a()) && BlockRegistry.ASPECT_VIAL_BLOCK.func_176196_c(world, pos.func_177984_a())) {
                if (!world.field_72995_K) {
                    ItemAspectVial.placeAspectVial(world, pos.func_177984_a(), stack.func_77952_i() == 2 ? 1 : 0, null);
                    stack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
        } else if (!player.func_70093_af() && stack.func_77952_i() != 1) {
            List<LocationStorage> locations = LocationStorage.getLocations(world, new AxisAlignedBB(pos));
            for (LocationStorage location : locations) {
                LocationSludgeWormDungeon dungeon;
                if (!(location instanceof LocationSludgeWormDungeon) || !(dungeon = (LocationSludgeWormDungeon)location).hasGroundFog(pos)) continue;
                int floor = dungeon.getFloor(pos);
                if (floor == 5 || floor == 6) {
                    if (!world.field_72995_K) {
                        stack.func_190918_g(1);
                        world.func_184133_a(null, pos, FluidRegistry.FOG.getFillSound(new FluidStack(FluidRegistry.FOG, 1000)), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)ItemRegistry.DENTROTHYST_FLUID_VIAL.withFluid(stack.func_77952_i() == 2 ? 1 : 0, FluidRegistry.FOG));
                    }
                    return EnumActionResult.SUCCESS;
                }
                if (world.field_72995_K) continue;
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.not_enough_fog_for_vial", new Object[0]), true);
            }
        }
        return EnumActionResult.FAIL;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new DentrothystVialFluidHandler(stack, ItemRegistry.DENTROTHYST_FLUID_VIAL.getCapacity());
    }

    private static final class DentrothystVialFluidHandler
    extends FluidHandlerItemStackSimple {
        public DentrothystVialFluidHandler(ItemStack container, int capacity) {
            super(container, capacity);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return ItemRegistry.DENTROTHYST_FLUID_VIAL.canFillWith(this.container, fluid);
        }

        @Nullable
        public FluidStack getFluid() {
            return null;
        }

        protected void setContainerToEmpty() {
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.container.func_77952_i() == 1) {
                return 0;
            }
            ItemStack fluidVial = new ItemStack((Item)ItemRegistry.DENTROTHYST_FLUID_VIAL, 1, this.container.func_77952_i() == 2 ? 1 : 0);
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)fluidVial);
            int filled = handler.fill(resource, doFill);
            if (filled > 0 && doFill) {
                this.container = fluidVial;
            }
            return filled;
        }
    }
}

