/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.herblore;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.terrain.BlockDentrothyst;
import thebetweenlands.common.entity.projectiles.EntityElixir;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.herblore.elixir.ElixirRecipe;
import thebetweenlands.common.herblore.elixir.ElixirRecipes;
import thebetweenlands.common.herblore.elixir.effects.ElixirEffect;
import thebetweenlands.common.item.ITintedItem;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.util.TranslationHelper;

public class ItemElixir
extends Item
implements ITintedItem,
ItemRegistry.IBlockStateItemModelDefinition {
    private final List<ElixirEffect> effects = new ArrayList<ElixirEffect>();

    public ItemElixir() {
        this.effects.addAll(ElixirEffectRegistry.getEffects());
        this.func_77637_a(BLCreativeTabs.HERBLORE);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    private ElixirEffect getElixirByID(int id) {
        for (ElixirEffect effect : this.effects) {
            if (id != effect.getID()) continue;
            return effect;
        }
        return null;
    }

    public ElixirEffect getElixirFromItem(ItemStack stack) {
        return this.getElixirByID(stack.func_77952_i() / 2);
    }

    @Override
    public int getColorMultiplier(ItemStack stack, int tintIndex) {
        ElixirRecipe recipe;
        ElixirEffect effect;
        if (tintIndex <= 0 && (effect = this.getElixirFromItem(stack)) != null && (recipe = ElixirRecipes.getFromEffect(effect)) != null) {
            return recipe.infusionFinishedColor;
        }
        return -1;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (ElixirEffect effect : this.effects) {
                ElixirRecipe recipe = ElixirRecipes.getFromEffect(effect);
                if (recipe == null) continue;
                int baseDuration = effect.isAntiInfusion() ? recipe.negativeBaseDuration : recipe.baseDuration;
                int durationModifier = effect.isAntiInfusion() ? recipe.negativeDurationModifier : recipe.durationModifier;
                items.add((Object)this.getElixirItem(effect, baseDuration, 4, 0));
                items.add((Object)this.getElixirItem(effect, baseDuration + MathHelper.func_76141_d((float)((float)durationModifier / 6.0f * 5.0f)), 0, 0));
                items.add((Object)this.getElixirItem(effect, baseDuration, 4, 1));
                items.add((Object)this.getElixirItem(effect, baseDuration + MathHelper.func_76141_d((float)((float)durationModifier / 6.0f * 5.0f)), 0, 1));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        try {
            return "item.thebetweenlands." + this.getElixirFromItem(stack).getEffectName();
        }
        catch (Exception e) {
            return "item.thebetweenlands.unknown";
        }
    }

    public String func_77653_i(ItemStack stack) {
        if (I18n.func_94522_b((String)(stack.func_77977_a() + ".name"))) {
            return I18n.func_74837_a((String)(stack.func_77977_a() + ".name"), (Object[])new Object[]{TranslationHelper.translateToLocal(this.getElixirFromItem(stack).getEffectName(), new Object[0])});
        }
        return I18n.func_74837_a((String)"item.thebetweenlands.bl.elixir.name", (Object[])new Object[]{TranslationHelper.translateToLocal(this.getElixirFromItem(stack).getEffectName(), new Object[0])});
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("throwing") && stack.func_77978_p().func_74767_n("throwing")) {
            return EnumAction.BOW;
        }
        return EnumAction.DRINK;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("throwing") && stack.func_77978_p().func_74767_n("throwing")) {
            world.func_184133_a((EntityPlayer)entityLiving, entityLiving.func_180425_c(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!world.field_72995_K) {
                int useCount = this.func_77626_a(stack) - timeLeft;
                EntityElixir elixir = new EntityElixir(world, entityLiving, stack);
                float strength = Math.min(0.2f + (float)useCount / 20.0f, 1.0f);
                elixir.func_184538_a((Entity)entityLiving, ((EntityPlayer)entityLiving).field_70125_A, ((EntityPlayer)entityLiving).field_70177_z, -20.0f, strength, 1.0f);
                world.func_72838_d((Entity)elixir);
                if (!((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        ((EntityPlayer)entityLiving).field_71071_by.func_184437_d(stack);
                    }
                }
            }
        }
    }

    public ItemStack getElixirItem(ElixirEffect effect, int duration, int strength, int vialType) {
        ItemStack elixirStack = new ItemStack((Item)this, 1, effect.getID() * 2 + vialType);
        NBTTagCompound elixirData = new NBTTagCompound();
        elixirData.func_74768_a("duration", duration);
        elixirData.func_74768_a("strength", strength);
        if (elixirStack.func_77978_p() == null) {
            elixirStack.func_77982_d(new NBTTagCompound());
        }
        elixirStack.func_77978_p().func_74782_a("elixirData", (NBTBase)elixirData);
        return elixirStack;
    }

    public BlockDentrothyst.EnumDentrothyst getDentrothystType(ItemStack stack) {
        return stack.func_77960_j() % 2 == 0 ? BlockDentrothyst.EnumDentrothyst.GREEN : BlockDentrothyst.EnumDentrothyst.ORANGE;
    }

    public int func_77626_a(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("throwing") && stack.func_77978_p().func_74767_n("throwing")) {
            return 100000;
        }
        return 32;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a("throwing", playerIn.func_70093_af());
        playerIn.func_184598_c(handIn);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        EntityPlayer entityplayer;
        EntityPlayer entityPlayer = entityplayer = entityLiving instanceof EntityPlayer ? (EntityPlayer)entityLiving : null;
        if (entityplayer == null || !entityplayer.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        if (entityplayer instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)entityplayer, stack);
        }
        if (!world.field_72995_K) {
            ElixirEffect effect = this.getElixirFromItem(stack);
            int duration = this.getElixirDuration(stack);
            int strength = this.getElixirStrength(stack);
            entityplayer.func_70690_d(effect.createEffect(duration == -1 ? 1200 : duration, strength == -1 ? 0 : strength));
        }
        if (entityplayer != null) {
            entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
        }
        if (entityplayer == null || !entityplayer.field_71075_bZ.field_75098_d) {
            if (stack.func_190926_b()) {
                return ItemRegistry.DENTROTHYST_VIAL.createStack(stack.func_77952_i() % 2 == 0 ? 1 : 2);
            }
            if (entityplayer != null) {
                entityplayer.field_71071_by.func_70441_a(ItemRegistry.DENTROTHYST_VIAL.createStack(stack.func_77952_i() % 2 == 0 ? 1 : 2));
            }
        }
        return stack;
    }

    public void applyEffect(ItemStack stack, EntityLivingBase entity, double modifier) {
        ElixirEffect effect = this.getElixirFromItem(stack);
        int strength = this.getElixirStrength(stack);
        int duration = this.getElixirDuration(stack);
        entity.func_70690_d(effect.createEffect((int)((double)duration * modifier), strength));
    }

    public PotionEffect createPotionEffect(ItemStack stack, double modifier) {
        ElixirEffect effect = this.getElixirFromItem(stack);
        int strength = this.getElixirStrength(stack);
        int duration = this.getElixirDuration(stack);
        return effect.createEffect((int)((double)duration * modifier), strength);
    }

    public int getElixirDuration(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("elixirData")) {
            NBTTagCompound elixirData = stack.func_77978_p().func_74775_l("elixirData");
            return elixirData.func_74762_e("duration");
        }
        return 1200;
    }

    public int getElixirStrength(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("elixirData")) {
            NBTTagCompound elixirData = stack.func_77978_p().func_74775_l("elixirData");
            return elixirData.func_74762_e("strength");
        }
        return 0;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int durationLevel;
        ElixirEffect elixirEffect = this.getElixirFromItem(stack);
        PotionEffect effect = this.createPotionEffect(stack, 1.0);
        String potencyStr = I18n.func_94522_b((String)("bl.elixir.potency." + (effect.func_76458_c() + 1))) ? I18n.func_74837_a((String)("bl.elixir.potency." + (effect.func_76458_c() + 1)), (Object[])new Object[0]) : I18n.func_74837_a((String)"bl.elixir.potency.n", (Object[])new Object[]{effect.func_76458_c() + 1});
        tooltip.add(I18n.func_74837_a((String)"tooltip.bl.elixir.potency", (Object[])new Object[]{potencyStr}));
        ElixirRecipe recipe = ElixirRecipes.getFromEffect(elixirEffect);
        if (recipe != null) {
            int baseDuration = elixirEffect.isAntiInfusion() ? recipe.negativeBaseDuration : recipe.baseDuration;
            int durationModifier = elixirEffect.isAntiInfusion() ? recipe.negativeDurationModifier : recipe.durationModifier;
            durationLevel = Math.max(0, MathHelper.func_76141_d((float)((float)(effect.func_76459_b() - baseDuration) / (float)durationModifier * 5.0f)));
        } else {
            durationLevel = MathHelper.func_76141_d((float)((float)effect.func_76459_b() / 3600.0f));
        }
        String durationLevelStr = I18n.func_94522_b((String)("bl.elixir.duration." + (durationLevel + 1))) ? I18n.func_74837_a((String)("bl.elixir.duration." + (durationLevel + 1)), (Object[])new Object[0]) : I18n.func_74837_a((String)"bl.elixir.duration.n", (Object[])new Object[]{durationLevel + 1});
        tooltip.add(I18n.func_74837_a((String)"tooltip.bl.elixir.duration", (Object[])new Object[]{durationLevelStr, StringUtils.func_76337_a((int)effect.func_76459_b()), effect.func_76459_b()}));
        Potion potion = effect.func_188419_a();
        ArrayList modifiers = Lists.newArrayList();
        Map modifersMap = potion.func_111186_k();
        if (!modifersMap.isEmpty()) {
            for (Map.Entry entry : modifersMap.entrySet()) {
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                modifier = new AttributeModifier(modifier.func_111166_b(), potion.func_111183_a(effect.func_76458_c(), modifier), modifier.func_111169_c());
                modifiers.add(new Tuple((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)modifier));
            }
        }
        boolean hasEffectDescription = I18n.func_94522_b((String)("tooltip.bl." + elixirEffect.getEffectName() + ".effect"));
        if (!modifiers.isEmpty() || hasEffectDescription) {
            tooltip.add("");
            tooltip.add(TextFormatting.DARK_PURPLE + I18n.func_74837_a((String)"tooltip.bl.elixir.when_applied", (Object[])new Object[0]));
            for (Tuple tuple : modifiers) {
                AttributeModifier modifier = (AttributeModifier)tuple.func_76340_b();
                double amount = modifier.func_111164_d();
                double adjustedAmount = modifier.func_111169_c() != 1 && modifier.func_111169_c() != 2 ? modifier.func_111164_d() : modifier.func_111164_d() * 100.0;
                if (amount > 0.0) {
                    tooltip.add(TextFormatting.BLUE + I18n.func_74837_a((String)("attribute.modifier.plus." + modifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(adjustedAmount), I18n.func_74837_a((String)("attribute.name." + (String)tuple.func_76341_a()), (Object[])new Object[0])}));
                    continue;
                }
                if (!(amount < 0.0)) continue;
                tooltip.add(TextFormatting.RED + I18n.func_74837_a((String)("attribute.modifier.take." + modifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(adjustedAmount *= -1.0), I18n.func_74837_a((String)("attribute.name." + (String)tuple.func_76341_a()), (Object[])new Object[0])}));
            }
            if (hasEffectDescription) {
                tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_74837_a((String)("tooltip." + elixirEffect.getEffectName() + ".effect"), (Object[])new Object[0]), 0));
            }
        }
    }

    @Override
    public Map<Integer, String> getVariants() {
        HashMap<Integer, String> variants = new HashMap<Integer, String>();
        for (ElixirEffect effect : this.effects) {
            variants.put(effect.getID() * 2, "green");
            variants.put(effect.getID() * 2 + 1, "orange");
        }
        return variants;
    }

    public boolean func_77634_r() {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return ItemRegistry.DENTROTHYST_VIAL.createStack(stack.func_77952_i() % 2 == 0 ? 1 : 2);
    }
}

