/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;

public class ItemMob
extends Item {
    private final Class<? extends Entity> defaultMob;
    private final Consumer<Entity> defaultMobSetter;

    public <T extends Entity> ItemMob(int maxStackSize, @Nullable Class<T> defaultMob, @Nullable Consumer<T> defaultMobSetter) {
        this.field_77777_bU = maxStackSize;
        this.defaultMob = defaultMob;
        this.defaultMobSetter = defaultMobSetter;
        this.func_77637_a(BLCreativeTabs.ITEMS);
    }

    public ItemStack capture(Class<? extends Entity> cls) {
        return this.capture(cls, null);
    }

    public ItemStack capture(Class<? extends Entity> cls, @Nullable NBTTagCompound nbt) {
        ResourceLocation id = EntityList.func_191306_a(cls);
        if (id != null) {
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            nbt.func_74778_a("id", id.toString());
            ItemStack stack = new ItemStack((Item)this);
            stack.func_77983_a("Entity", (NBTBase)nbt);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack capture(Entity entity) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.field_77777_bU == 1) {
            entity.func_70039_c(nbt);
        } else {
            NBTTagCompound entityNbt = new NBTTagCompound();
            if (entity.func_70039_c(entityNbt) && entityNbt.func_150297_b("id", 8)) {
                nbt.func_74778_a("id", entityNbt.func_74779_i("id"));
            }
        }
        if (!nbt.func_82582_d()) {
            ItemStack stack = new ItemStack((Item)this);
            stack.func_77983_a("Entity", (NBTBase)nbt);
            if (entity.func_145818_k_()) {
                stack.func_151001_c(entity.func_95999_t());
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean isCapturedEntity(ItemStack stack, Class<? extends Entity> cls) {
        NBTTagCompound entityNbt;
        if (stack.func_77973_b() != this) {
            return false;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("Entity", 10) && (entityNbt = nbt.func_74775_l("Entity")).func_150297_b("id", 8)) {
            Class entityCls = EntityList.getClass((ResourceLocation)new ResourceLocation(entityNbt.func_74779_i("id")));
            return entityCls != null && cls.isAssignableFrom(entityCls);
        }
        return this.defaultMob != null && cls.isAssignableFrom(this.defaultMob);
    }

    @Nullable
    public ResourceLocation getCapturedEntityId(ItemStack stack) {
        NBTTagCompound entityNbt;
        if (stack.func_77973_b() != this) {
            return null;
        }
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("Entity", 10) && (entityNbt = stack.func_77978_p().func_74775_l("Entity")).func_150297_b("id", 8)) {
            return new ResourceLocation(entityNbt.func_74779_i("id"));
        }
        if (this.defaultMob != null) {
            return EntityList.func_191306_a(this.defaultMob);
        }
        return null;
    }

    @Nullable
    public Entity createCapturedEntity(World world, double x, double y, double z, ItemStack stack) {
        ResourceLocation id;
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("Entity", 10)) {
            return this.createCapturedEntityFromNBT(world, x, y, z, stack.func_77978_p().func_74775_l("Entity"));
        }
        if (this.defaultMob != null && (id = EntityList.func_191306_a(this.defaultMob)) != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("id", id.toString());
            Entity entity = this.createCapturedEntityFromNBT(world, x, y, z, nbt);
            if (this.defaultMobSetter != null) {
                this.defaultMobSetter.accept(entity);
            }
            return entity;
        }
        return null;
    }

    @Nullable
    protected Entity createCapturedEntityFromNBT(World world, double x, double y, double z, NBTTagCompound nbt) {
        Entity entity = EntityList.func_75615_a((NBTTagCompound)nbt, (World)world);
        if (entity != null) {
            entity.func_184221_a(UUID.randomUUID());
            entity.func_70012_b(x, y, z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
            return entity;
        }
        return null;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.defaultMob != null && this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Entity entity;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && (entity = this.createCapturedEntity(world, (float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY, (float)pos.func_177952_p() + hitZ, stack)) != null) {
            if (facing.func_82601_c() != 0) {
                entity.func_70107_b(entity.field_70165_t + (double)((float)facing.func_82601_c() * entity.field_70130_N * 0.5f), entity.field_70163_u, entity.field_70161_v);
            }
            if (facing.func_96559_d() < 0) {
                entity.func_70107_b(entity.field_70165_t, entity.field_70163_u - (double)entity.field_70131_O, entity.field_70161_v);
            }
            if (facing.func_82599_e() != 0) {
                entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v + (double)((float)facing.func_82599_e() * entity.field_70130_N * 0.5f));
            }
            if (world.func_184144_a(entity, entity.func_174813_aQ()).isEmpty()) {
                this.spawnCapturedEntity(player, world, entity);
                stack.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.SUCCESS;
    }

    protected void spawnCapturedEntity(EntityPlayer player, World world, Entity entity) {
        world.func_72838_d(entity);
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_70642_aH();
        }
    }

    public void onCapturedByPlayer(EntityPlayer player, EnumHand hand, ItemStack captured) {
    }

    public String func_77667_c(ItemStack stack) {
        ResourceLocation id = this.getCapturedEntityId(stack);
        if (id != null) {
            return "entity." + id.func_110624_b() + "." + id.func_110623_a();
        }
        return super.func_77667_c(stack);
    }

    public boolean func_185040_i() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Entity entity;
        if (worldIn != null && (entity = this.createCapturedEntity(worldIn, 0.0, 0.0, 0.0, stack)) instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            tooltip.add(I18n.func_135052_a((String)"tooltip.bl.item_mob.health", (Object[])new Object[]{MathHelper.func_76123_f((float)(living.func_110143_aJ() / 2.0f)), MathHelper.func_76123_f((float)(living.func_110138_aP() / 2.0f))}));
        }
    }
}

