/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.item.CorrosionHelper;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.common.entity.EntityShockwaveBlock;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.item.tools.ItemBLSword;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.NBTHelper;

public class ItemShockwaveSword
extends ItemBLSword {
    private static final ImmutableList<String> STACK_NBT_EXCLUSIONS = ImmutableList.of((Object)"cooldown");

    public ItemShockwaveSword(Item.ToolMaterial material) {
        super(material);
        this.func_185043_a(new ResourceLocation("charging"), (stack, worldIn, entityIn) -> stack.func_77978_p() != null && stack.func_77978_p().func_74762_e("cooldown") < 60 ? 1.0f : 0.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77952_i() == stack.func_77958_k()) {
            tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.bl.tool.broken", (Object[])new Object[]{stack.func_82833_r()}), 0));
        } else {
            tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.bl.shockwave_sword.usage", (Object[])new Object[0]), 0));
        }
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeldItem) {
        CorrosionHelper.updateCorrosion(stack, world, entity, slot, isHeldItem);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("cooldown")) {
            stack.func_77978_p().func_74768_a("cooldown", 0);
        }
        if (!stack.func_77978_p().func_74764_b("uses")) {
            stack.func_77978_p().func_74768_a("uses", 0);
        }
        if (stack.func_77978_p().func_74762_e("uses") == 3) {
            if (stack.func_77978_p().func_74762_e("cooldown") < 60) {
                stack.func_77978_p().func_74768_a("cooldown", stack.func_77978_p().func_74762_e("cooldown") + 1);
            }
            if (stack.func_77978_p().func_74762_e("cooldown") >= 60) {
                stack.func_77978_p().func_74768_a("cooldown", 60);
                stack.func_77978_p().func_74768_a("uses", 0);
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return EnumActionResult.PASS;
        }
        if (stack.func_77952_i() == stack.func_77958_k()) {
            stack.func_77978_p().func_74768_a("cooldown", 0);
            return EnumActionResult.PASS;
        }
        if (stack.func_77978_p().func_74762_e("uses") < 3) {
            if (!world.field_72995_K) {
                stack.func_77972_a(2, (EntityLivingBase)player);
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundRegistry.SHOCKWAVE_SWORD, SoundCategory.BLOCKS, 1.25f, 1.0f + world.field_73012_v.nextFloat() * 0.1f);
                double direction = Math.toRadians(player.field_70177_z);
                Vec3d diag = new Vec3d(Math.sin(direction + 1.5707963267948966), 0.0, Math.cos(direction + 1.5707963267948966)).func_72432_b();
                ArrayList<BlockPos> spawnedPos = new ArrayList<BlockPos>();
                for (int distance = -1; distance <= 16; ++distance) {
                    block1: for (int distance2 = -distance; distance2 <= distance; ++distance2) {
                        for (int yo = -1; yo <= 1; ++yo) {
                            int originZ;
                            int originY;
                            int originX = MathHelper.func_76128_c((double)((double)pos.func_177958_n() + 0.5 - Math.sin(direction) * (double)distance - diag.field_72450_a * (double)distance2 * 0.25));
                            BlockPos origin = new BlockPos(originX, originY = pos.func_177956_o() + yo, originZ = MathHelper.func_76128_c((double)((double)pos.func_177952_p() + 0.5 + Math.cos(direction) * (double)distance + diag.field_72449_c * (double)distance2 * 0.25)));
                            if (spawnedPos.contains(origin)) continue;
                            spawnedPos.add(origin);
                            IBlockState block = world.func_180495_p(new BlockPos(originX, originY, originZ));
                            if (!block.func_185915_l() || block.func_177230_c().hasTileEntity(block) || !(block.func_185887_b(world, origin) <= 5.0f) || !(block.func_185887_b(world, origin) >= 0.0f) || world.func_180495_p(origin.func_177984_a()).func_185914_p()) continue;
                            stack.func_77978_p().func_74768_a("blockID", Block.func_149682_b((Block)world.func_180495_p(origin).func_177230_c()));
                            stack.func_77978_p().func_74768_a("blockMeta", world.func_180495_p(origin).func_177230_c().func_176201_c(world.func_180495_p(origin)));
                            EntityShockwaveBlock shockwaveBlock = new EntityShockwaveBlock(world);
                            shockwaveBlock.setOrigin(origin, MathHelper.func_76128_c((double)Math.sqrt(distance * distance + distance2 * distance2)), (double)pos.func_177958_n() + 0.5, (double)pos.func_177952_p() + 0.5, (Entity)player);
                            shockwaveBlock.func_70012_b((double)originX + 0.5, originY, (double)originZ + 0.5, 0.0f, 0.0f);
                            shockwaveBlock.setBlock(Block.func_149729_e((int)stack.func_77978_p().func_74762_e("blockID")), stack.func_77978_p().func_74762_e("blockMeta"));
                            world.func_72838_d((Entity)shockwaveBlock);
                            continue block1;
                        }
                    }
                }
                stack.func_77978_p().func_74768_a("uses", stack.func_77978_p().func_74762_e("uses") + 1);
                if (stack.func_77978_p().func_74762_e("uses") >= 3) {
                    stack.func_77978_p().func_74768_a("uses", 3);
                    stack.func_77978_p().func_74768_a("cooldown", 0);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        boolean wasCharging = oldStack.func_77978_p() != null && oldStack.func_77978_p().func_74762_e("cooldown") < 60;
        boolean isCharging = newStack.func_77978_p() != null && newStack.func_77978_p().func_74762_e("cooldown") < 60;
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && !isCharging || isCharging != wasCharging || !NBTHelper.areItemStackTagsEqual(oldStack, newStack, STACK_NBT_EXCLUSIONS);
    }

    public void setDamage(ItemStack stack, int damage) {
        int maxDamage = stack.func_77958_k();
        if (damage > maxDamage) {
            damage = maxDamage;
        }
        super.setDamage(stack, damage);
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        if (slot == EntityEquipmentSlot.MAINHAND && stack.func_77952_i() == stack.func_77958_k()) {
            HashMultimap map = HashMultimap.create();
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", -1.0, 1));
            return map;
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public int getMinRepairFuelCost(ItemStack stack) {
        return BLMaterialRegistry.getMinRepairFuelCost(BLMaterialRegistry.TOOL_LEGEND);
    }

    @Override
    public int getFullRepairFuelCost(ItemStack stack) {
        return BLMaterialRegistry.getFullRepairFuelCost(BLMaterialRegistry.TOOL_LEGEND);
    }

    @Override
    public int getMinRepairLifeCost(ItemStack stack) {
        return BLMaterialRegistry.getMinRepairLifeCost(BLMaterialRegistry.TOOL_LEGEND);
    }

    @Override
    public int getFullRepairLifeCost(ItemStack stack) {
        return BLMaterialRegistry.getFullRepairLifeCost(BLMaterialRegistry.TOOL_LEGEND);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }
}

