/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.loot.shared;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTable;
import thebetweenlands.api.loot.ISharedLootPool;
import thebetweenlands.api.loot.LootTableView;
import thebetweenlands.common.loot.shared.SharedLootTableView;
import thebetweenlands.common.world.storage.SharedLootPoolStorage;

public class SharedLootPool
implements ISharedLootPool {
    protected ResourceLocation lootTableLocation;
    protected SharedLootPoolStorage storage;
    protected LootTable view;
    protected final Object2IntMap<String> removedItems = new Object2IntOpenHashMap();
    protected final Object2LongMap<String> poolSeeds = new Object2LongOpenHashMap();
    protected final Object2LongMap<String> entrySeeds = new Object2LongOpenHashMap();
    protected long sharedLootSeed;
    protected int guaranteeCounter;

    private SharedLootPool(ResourceLocation lootTableLocation, long seed) {
        this.lootTableLocation = lootTableLocation;
        this.sharedLootSeed = seed;
    }

    public SharedLootPool(ResourceLocation lootTableLocation, long seed, @Nullable SharedLootPoolStorage storage) {
        this(lootTableLocation, seed);
        this.storage = storage;
    }

    public SharedLootPool(NBTTagCompound nbt, @Nullable SharedLootPoolStorage storage) {
        this(null, 0L);
        this.storage = storage;
        this.readFromNBT(nbt);
    }

    @Override
    public ResourceLocation getLootTable() {
        return this.lootTableLocation;
    }

    @Override
    public LootTableView getLootTableView() {
        return new SharedLootTableView(this);
    }

    @Override
    public void regenerate() {
        this.removedItems.clear();
        this.entrySeeds.clear();
        this.poolSeeds.clear();
        this.guaranteeCounter = 0;
        this.setLocationDirty();
    }

    @Override
    public void refill() {
        this.removedItems.clear();
        this.guaranteeCounter = 0;
        this.setLocationDirty();
    }

    @Override
    public int getRemovedItems(String pool, int poolRoll, String entry) {
        return this.removedItems.getInt((Object)String.format("%s#%d#%s", pool, poolRoll, entry));
    }

    @Override
    public void setRemovedItems(String pool, int poolRoll, String entry, int count) {
        this.removedItems.put((Object)String.format("%s#%d#%s", pool, poolRoll, entry), count);
        this.setLocationDirty();
    }

    @Override
    public long getLootPoolSeed(Random rand, String pool, int poolRoll) {
        long seed;
        String key = String.format("%s#%d", pool, poolRoll);
        if (this.poolSeeds.containsKey((Object)key)) {
            seed = (Long)this.poolSeeds.get((Object)key);
        } else {
            seed = rand.nextLong();
            this.poolSeeds.put((Object)key, seed);
            this.setLocationDirty();
        }
        return seed;
    }

    @Override
    public long getLootEntrySeed(Random rand, String pool, int poolRoll, String entry) {
        long seed;
        String key = String.format("%s#%d#%s", pool, poolRoll, entry);
        if (this.entrySeeds.containsKey((Object)key)) {
            seed = (Long)this.entrySeeds.get((Object)key);
        } else {
            seed = rand.nextLong();
            this.entrySeeds.put((Object)key, seed);
            this.setLocationDirty();
        }
        return seed;
    }

    @Override
    public int getGuaranteeCounter() {
        return this.guaranteeCounter;
    }

    void incrementGuaranteeCounter() {
        ++this.guaranteeCounter;
        this.setLocationDirty();
    }

    @Override
    public float getGuaranteePercentage() {
        int lootInventories = this.storage != null ? this.storage.getSharedLootInventories(this.lootTableLocation) : 0;
        return lootInventories <= 0 ? 1.0f : Math.min((float)this.getGuaranteeCounter() / (float)lootInventories, 1.0f);
    }

    protected void setLocationDirty() {
        if (this.storage != null) {
            this.storage.markDirty();
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (!this.removedItems.isEmpty()) {
            NBTTagCompound removedItemsNbt = new NBTTagCompound();
            for (Object2IntMap.Entry entry : this.removedItems.object2IntEntrySet()) {
                removedItemsNbt.func_74768_a((String)entry.getKey(), entry.getIntValue());
            }
            nbt.func_74782_a("removedItems", (NBTBase)removedItemsNbt);
        }
        if (!this.poolSeeds.isEmpty()) {
            NBTTagCompound poolSeedsNbt = new NBTTagCompound();
            for (Object2IntMap.Entry entry : this.poolSeeds.object2LongEntrySet()) {
                poolSeedsNbt.func_74772_a((String)entry.getKey(), entry.getLongValue());
            }
            nbt.func_74782_a("poolSeeds", (NBTBase)poolSeedsNbt);
        }
        if (!this.entrySeeds.isEmpty()) {
            NBTTagCompound entrySeedsNbt = new NBTTagCompound();
            for (Object2IntMap.Entry entry : this.entrySeeds.object2LongEntrySet()) {
                entrySeedsNbt.func_74772_a((String)entry.getKey(), entry.getLongValue());
            }
            nbt.func_74782_a("entrySeeds", (NBTBase)entrySeedsNbt);
        }
        if (this.lootTableLocation != null) {
            nbt.func_74778_a("lootTable", this.lootTableLocation.toString());
        }
        nbt.func_74768_a("generatedLootTables", this.guaranteeCounter);
        nbt.func_74772_a("sharedLootSeed", this.sharedLootSeed);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.removedItems.clear();
        NBTTagCompound removedItemsNbt = nbt.func_74775_l("removedItems");
        for (Object key : removedItemsNbt.func_150296_c()) {
            this.removedItems.put(key, removedItemsNbt.func_74762_e((String)key));
        }
        this.poolSeeds.clear();
        NBTTagCompound poolSeedsNbt = nbt.func_74775_l("poolSeeds");
        for (String key : poolSeedsNbt.func_150296_c()) {
            this.poolSeeds.put((Object)key, poolSeedsNbt.func_74763_f(key));
        }
        this.entrySeeds.clear();
        NBTTagCompound entrySeedsNbt = nbt.func_74775_l("entrySeeds");
        for (String key : entrySeedsNbt.func_150296_c()) {
            this.entrySeeds.put((Object)key, entrySeedsNbt.func_74763_f(key));
        }
        this.lootTableLocation = null;
        if (nbt.func_150297_b("lootTable", 8)) {
            this.lootTableLocation = new ResourceLocation(nbt.func_74779_i("lootTable"));
        }
        this.guaranteeCounter = nbt.func_74762_e("generatedLootTables");
        this.sharedLootSeed = nbt.func_74763_f("sharedLootSeed");
    }

    @Override
    public long getLootTableSeed() {
        return this.sharedLootSeed;
    }
}

