/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.capability.foodsickness.FoodSickness;
import thebetweenlands.common.network.MessageBase;

public class MessageShowFoodSicknessLine
extends MessageBase {
    private FoodSickness sickness;
    private ItemStack stack;

    public MessageShowFoodSicknessLine() {
    }

    public MessageShowFoodSicknessLine(ItemStack stack, FoodSickness sickness) {
        this.sickness = sickness;
        this.stack = stack.func_77946_l();
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.func_179249_a((Enum)this.sickness);
        buf.func_150788_a(this.stack);
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        this.sickness = (FoodSickness)buf.func_179257_a(FoodSickness.class);
        try {
            this.stack = buf.func_150791_c();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IMessage process(MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.showMessage(this.stack, this.sickness);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void showMessage(ItemStack stack, FoodSickness sickness) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            player.func_146105_b((ITextComponent)new TextComponentString(String.format(sickness.getRandomLine(player.func_70681_au()), stack.func_82833_r())), true);
        }
    }
}

