/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe.censer;

import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.api.block.ICenser;
import thebetweenlands.api.recipes.ICenserRecipe;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.shader.postprocessing.GroundFog;
import thebetweenlands.common.recipe.censer.AbstractCenserRecipe;
import thebetweenlands.common.recipe.censer.CenserRecipeAspectContext;
import thebetweenlands.common.registries.ItemRegistry;

public class CenserRecipeAspect
extends AbstractCenserRecipe<CenserRecipeAspectContext> {
    private static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "aspect");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public boolean matchesInput(ItemStack stack) {
        return stack.func_77973_b() == ItemRegistry.ASPECT_VIAL && !ItemAspectContainer.fromItem(stack).getAspects().isEmpty();
    }

    @Override
    public int getInputAmount(ItemStack stack) {
        return Math.min(ItemAspectContainer.fromItem((ItemStack)stack).getAspects().get((int)0).amount / 5, 1000);
    }

    @Override
    public CenserRecipeAspectContext createContext(ItemStack stack) {
        return new CenserRecipeAspectContext(ItemAspectContainer.fromItem((ItemStack)stack).getAspects().get((int)0).type);
    }

    @Override
    public int getConsumptionDuration(CenserRecipeAspectContext context, ICenser censer) {
        return 120;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(CenserRecipeAspectContext context, ICenser censer, double x, double y, double z, float partialTicks) {
        float effectStrength = censer.getEffectStrength(partialTicks);
        if (effectStrength > 0.01f && ShaderHelper.INSTANCE.isWorldShaderActive()) {
            ShaderHelper.INSTANCE.require();
            float fogBrightness = 0.4f;
            float inScattering = 0.018f * effectStrength;
            float extinction = 2.5f;
            AxisAlignedBB fogArea = new AxisAlignedBB(censer.getCenserPos()).func_72314_b(6.0, 0.1, 6.0).func_72321_a(0.0, 12.0, 0.0);
            int fogColor = this.getEffectColor(context, censer, ICenserRecipe.EffectColorType.FOG);
            float r = (float)(fogColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(fogColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(fogColor >> 0 & 0xFF) / 255.0f;
            ShaderHelper.INSTANCE.getWorldShader().addGroundFogVolume(new GroundFog.GroundFogVolume(new Vec3d(fogArea.field_72340_a, fogArea.field_72338_b, fogArea.field_72339_c), new Vec3d(fogArea.field_72336_d - fogArea.field_72340_a, fogArea.field_72337_e - fogArea.field_72338_b, fogArea.field_72334_f - fogArea.field_72339_c), inScattering, extinction, fogBrightness * r, fogBrightness * g, fogBrightness * b));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getEffectColor(CenserRecipeAspectContext context, ICenser censer, ICenserRecipe.EffectColorType type) {
        return context.type.getColor();
    }

    @Override
    public IAspectType getAspectFogType(CenserRecipeAspectContext context, ICenser censer) {
        return context.type;
    }
}

